/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.util;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.provider.BeanProvider;
import com.opensymphony.provider.bean.DefaultBeanProvider;
import com.opensymphony.workflow.WorkflowException;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.workflowtool.util.InfogluePropertySet;
import org.infoglue.cms.util.workflow.DatabaseSession;

public abstract class InfoglueWorkflowBase {
    private static final Logger logger = Logger.getLogger((String)InfoglueWorkflowBase.class.getName());
    protected static final String UTF8_ENCODING = "utf-8";
    public static final String WORKFLOW_PROPERTYSET_PREFIX = "workflow_";
    public static final String FUNCTION_STATUS_PROPERTYSET_KEY = "workflow_status";
    public static final String ERROR_PROPERTYSET_PREFIX = "error_";
    private static final String DB_PARAMETER = "db";
    private Map parameters;
    private Map arguments;
    private InfogluePropertySet propertySet;
    private DatabaseSession workflowDatabase;
    private Exception lastException;
    private static BeanProvider beanProvider = new DefaultBeanProvider();

    protected void initialize() throws WorkflowException {
        this.workflowDatabase = (DatabaseSession)this.getParameter(DB_PARAMETER);
    }

    protected void storeContext(Map transientVars, Map args, PropertySet ps) {
        this.parameters = transientVars;
        this.arguments = Collections.unmodifiableMap(args);
        this.propertySet = new InfogluePropertySet(ps);
    }

    protected void throwException(String message) throws WorkflowException {
        this.throwException((Exception)((Object)new WorkflowException(message)));
    }

    protected void throwException(Exception e) throws WorkflowException {
        if (this.lastException != e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        this.lastException = e;
        this.workflowDatabase.setRollbackOnly();
        throw e instanceof WorkflowException ? (WorkflowException)((Object)e) : new WorkflowException((Throwable)e);
    }

    protected final boolean argumentExists(String name) {
        return this.arguments.containsKey(name);
    }

    protected final String getArgument(String name) throws WorkflowException {
        if (!this.arguments.containsKey(name)) {
            this.throwException("Required argument " + name + " is missing.");
        }
        return this.arguments.get(name).toString();
    }

    protected final String getArgument(String name, String defaultValue) throws WorkflowException {
        return this.arguments.containsKey(name) ? this.arguments.get(name).toString() : defaultValue;
    }

    protected final boolean parameterExists(String key) {
        return this.parameters.containsKey(key);
    }

    protected final Object getParameter(String key) throws WorkflowException {
        return this.getParameter(key, true);
    }

    protected final String getParameterStringValue(String key, boolean required) throws WorkflowException {
        Object o = this.getParameter(key, required);
        if (o instanceof String[]) {
            return ((String[])o)[0];
        }
        return o == null ? null : o.toString();
    }

    protected final Object getParameter(String key, Object defaultValue) throws WorkflowException {
        return this.parameters.containsKey(key) ? this.parameters.get(key) : defaultValue;
    }

    protected final Object getParameter(String key, boolean required) throws WorkflowException {
        Object parameter = this.parameters.get(key);
        if (required && parameter == null) {
            WorkflowException e = new WorkflowException("Required parameter " + key + " is missing.");
            logger.error((Object)e.toString());
            throw e;
        }
        return parameter;
    }

    protected final void setParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    protected final Map getParameters() {
        return this.parameters;
    }

    protected final boolean propertySetContains(String key) {
        return this.propertySet.exists(key);
    }

    protected final String getPropertySetDataString(String key) {
        return this.propertySet.getDataString(key);
    }

    protected final void setPropertySetDataString(String key, String value) {
        this.propertySet.setDataString(key, value);
    }

    protected final String getPropertySetString(String key) {
        return this.propertySet.getString(key);
    }

    protected final void setPropertySetString(String key, String value) {
        this.propertySet.setString(key, value);
    }

    protected final void removeFromPropertySet(String key) {
        this.removeFromPropertySet(key, false);
    }

    protected final void removeFromPropertySet(String key, boolean isPrefix) {
        this.propertySet.removeKeys(key, isPrefix);
    }

    protected final String translate(String s) {
        Object o = InfoglueWorkflowBase.translateVariables(s, this.parameters, this.propertySet);
        return o == null ? null : o.toString();
    }

    protected final InfogluePropertySet getPropertySet() {
        return this.propertySet;
    }

    protected final Database getDatabase() throws WorkflowException {
        return this.workflowDatabase.getDB();
    }

    public static Object translateVariables(String s, Map transientVars, PropertySet ps) {
        Object result = null;
        String temp = s.trim();
        if (temp.startsWith("${") && temp.endsWith("}") && temp.indexOf(36, 1) == -1) {
            String var = temp.substring(2, temp.length() - 1);
            result = InfoglueWorkflowBase.getVariableFromMaps(var, transientVars, ps);
        } else {
            while (true) {
                int x = s.indexOf("${");
                int y = s.indexOf("}", x);
                if (x == -1 || y == -1) break;
                String var = s.substring(x + 2, y);
                String t = null;
                Object o = InfoglueWorkflowBase.getVariableFromMaps(var, transientVars, ps);
                if (o != null) {
                    t = o.toString();
                }
                if (t != null) {
                    s = String.valueOf(s.substring(0, x)) + t + s.substring(y + 1);
                    continue;
                }
                s = String.valueOf(s.substring(0, x)) + s.substring(y + 1);
            }
            result = s;
        }
        return result;
    }

    public static Object getVariableFromMaps(String var, Map transientVars, PropertySet ps) {
        Object o;
        int firstDot = var.indexOf(46);
        String actualVar = var;
        if (firstDot != -1) {
            actualVar = var.substring(0, firstDot);
        }
        if ((o = transientVars.get(actualVar)) == null) {
            o = ps.getAsActualType(actualVar);
        }
        if (firstDot != -1) {
            o = beanProvider.getProperty(o, var.substring(firstDot + 1));
        }
        return o;
    }
}

