/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.util;

import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetSchema;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class InfogluePropertySet
implements PropertySet {
    private static final Logger logger = Logger.getLogger((String)InfogluePropertySet.class.getName());
    private static final String UTF8_ENCODING = "utf-8";
    private final PropertySet delegate;

    public InfogluePropertySet(PropertySet delegate) {
        this.delegate = delegate;
    }

    public void setDataString(String key, String value) throws PropertyException {
        if (value == null || value.length() == 0) {
            if (this.exists(key)) {
                this.remove(key);
            }
        } else {
            try {
                logger.debug((Object)("PropertysetHelper.setData(\"" + key + "\",\"" + value + "\")"));
                this.setData(key, value.getBytes(UTF8_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                throw new PropertyException("Unable to set data for [" + key + "].");
            }
        }
    }

    public String getDataString(String key) throws PropertyException {
        try {
            byte[] b = this.getData(key);
            String value = b == null ? null : new String(b, UTF8_ENCODING);
            logger.debug((Object)("PropertysetHelper.getData(\"" + key + "\")=\"" + (value == null ? "NULL" : value) + "\""));
            return value;
        }
        catch (UnsupportedEncodingException e) {
            throw new PropertyException("Unable to get data for [" + key + "].");
        }
    }

    public void removeKeys(String key, boolean isPrefix) throws PropertyException {
        if (key == null) {
            this.remove();
        } else if (isPrefix) {
            Iterator i = this.getKeys(key).iterator();
            while (i.hasNext()) {
                this.remove(i.next().toString());
            }
        } else if (this.exists(key)) {
            this.remove(key);
        }
    }

    public String getAsString(String key) {
        if (!this.exists(key) || this.getAsActualType(key) == null) {
            return null;
        }
        switch (this.getType(key)) {
            case 1: {
                return new Boolean(this.getBoolean(key)).toString();
            }
            case 10: {
                return this.getDataString(key);
            }
            case 7: {
                return this.getDate(key).toString();
            }
            case 4: {
                return new Double(this.getDouble(key)).toString();
            }
            case 2: {
                return new Integer(this.getInt(key)).toString();
            }
            case 3: {
                return new Long(this.getLong(key)).toString();
            }
            case 5: {
                return this.getString(key);
            }
            case 6: {
                return this.getText(key);
            }
        }
        logger.warn((Object)("Unsupported type [" + this.getType(key) + "]."));
        return null;
    }

    public boolean exists(String key) throws PropertyException {
        return this.delegate.exists(key);
    }

    public Object getAsActualType(String key) throws PropertyException {
        return this.delegate.exists(key) ? this.delegate.getAsActualType(key) : null;
    }

    public boolean getBoolean(String key) throws PropertyException {
        return this.delegate.getBoolean(key);
    }

    public byte[] getData(String key) throws PropertyException {
        return this.delegate.getData(key);
    }

    public Date getDate(String key) throws PropertyException {
        return this.delegate.getDate(key);
    }

    public double getDouble(String key) throws PropertyException {
        return this.delegate.getDouble(key);
    }

    public int getInt(String key) throws PropertyException {
        return this.delegate.getInt(key);
    }

    public Collection getKeys() throws PropertyException {
        return this.delegate.getKeys();
    }

    public Collection getKeys(int type) throws PropertyException {
        return this.delegate.getKeys(type);
    }

    public Collection getKeys(String prefix, int type) throws PropertyException {
        return this.delegate.getKeys(prefix, type);
    }

    public Collection getKeys(String prefix) throws PropertyException {
        return this.delegate.getKeys(prefix);
    }

    public long getLong(String key) throws PropertyException {
        return this.delegate.getLong(key);
    }

    public Object getObject(String key) throws PropertyException {
        return this.delegate.getObject(key);
    }

    public Properties getProperties(String key) throws PropertyException {
        return this.delegate.getProperties(key);
    }

    public PropertySetSchema getSchema() throws PropertyException {
        return this.delegate.getSchema();
    }

    public String getString(String key) throws PropertyException {
        return this.delegate.getString(key);
    }

    public String getText(String key) throws PropertyException {
        return this.delegate.getText(key);
    }

    public int getType(String key) throws PropertyException {
        return this.delegate.getType(key);
    }

    public Document getXML(String key) throws PropertyException {
        return this.delegate.getXML(key);
    }

    public void init(Map config, Map args) {
        this.delegate.init(config, args);
    }

    public boolean isSettable(String property) {
        return this.delegate.isSettable(property);
    }

    public void remove() throws PropertyException {
        this.delegate.remove();
    }

    public void remove(String key) throws PropertyException {
        this.delegate.remove(key);
    }

    public void setAsActualType(String key, Object value) throws PropertyException {
        this.delegate.setAsActualType(key, value);
    }

    public void setBoolean(String key, boolean value) throws PropertyException {
        this.delegate.setBoolean(key, value);
    }

    public void setData(String key, byte[] value) throws PropertyException {
        this.delegate.setData(key, value);
    }

    public void setDate(String key, Date value) throws PropertyException {
        this.delegate.setDate(key, value);
    }

    public void setDouble(String key, double value) throws PropertyException {
        this.delegate.setDouble(key, value);
    }

    public void setInt(String key, int value) throws PropertyException {
        this.delegate.setInt(key, value);
    }

    public void setLong(String key, long value) throws PropertyException {
        this.delegate.setLong(key, value);
    }

    public void setObject(String key, Object value) throws PropertyException {
        this.delegate.setObject(key, value);
    }

    public void setProperties(String key, Properties value) throws PropertyException {
        this.delegate.setProperties(key, value);
    }

    public void setSchema(PropertySetSchema schema) throws PropertyException {
        this.delegate.setSchema(schema);
    }

    public void setString(String key, String value) throws PropertyException {
        this.delegate.setString(key, value);
    }

    public void setText(String key, String value) throws PropertyException {
        this.delegate.setText(key, value);
    }

    public void setXML(String key, Document value) throws PropertyException {
        this.delegate.setXML(key, value);
    }

    public boolean supportsType(int type) {
        return this.delegate.supportsType(type);
    }

    public boolean supportsTypes() {
        return this.delegate.supportsTypes();
    }
}

