/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.workflowtool.util.ContentValues;
import org.infoglue.cms.applications.workflowtool.util.ContentVersionValues;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentCategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.Category;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.management.ContentTypeAttribute;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.dom.DOMBuilder;

public class ContentFactory {
    private static final Logger logger = Logger.getLogger((String)ContentFactory.class.getName());
    private final ContentTypeDefinitionVO contentTypeDefinitionVO;
    private final ContentValues contentValues;
    private final ContentVersionValues contentVersionValues;
    private final InfoGluePrincipal principal;
    private final LanguageVO language;
    private Database db;

    public ContentFactory(ContentTypeDefinitionVO contentTypeDefinitionVO, ContentValues contentValues, ContentVersionValues contentVersionValues, InfoGluePrincipal principal, LanguageVO language) {
        this.contentTypeDefinitionVO = contentTypeDefinitionVO;
        this.contentValues = contentValues;
        this.contentVersionValues = contentVersionValues;
        this.principal = principal;
        this.language = language;
        if (logger.isDebugEnabled()) {
            logger.info((Object)"*********ContentFactory**********");
            logger.info((Object)("contentTypeDefinitionVO:" + contentTypeDefinitionVO));
            logger.info((Object)("contentValues:" + contentValues));
            logger.info((Object)("contentVersionValues:" + contentVersionValues));
            logger.info((Object)("principal:" + principal));
            logger.info((Object)("language:" + language));
            logger.info((Object)"*********END ContentFactory**********");
        }
    }

    public ContentVO create(ContentVO parentContent, Map categories, Database db) throws ConstraintException, SystemException, Exception {
        Document contentVersionDocument;
        ContentVersionVO contentVersionVO;
        if (logger.isDebugEnabled()) {
            logger.info((Object)"*********ContentFactory.create**********");
            logger.info((Object)("contentTypeDefinitionVO:" + this.contentTypeDefinitionVO));
            logger.info((Object)("contentValues:" + this.contentValues));
            logger.info((Object)("contentVersionValues:" + this.contentVersionValues));
            logger.info((Object)("principal:" + this.principal));
            logger.info((Object)("language:" + this.language));
            logger.info((Object)("parentContent:" + parentContent));
            logger.info((Object)("categories:" + categories));
        }
        this.db = db;
        ContentVO contentVO = this.createContentVO();
        ConstraintExceptionBuffer ceb = this.validate(contentVO, contentVersionVO = this.createContentVersionVO((contentVersionDocument = this.buildContentVersionDocument()).asXML()));
        if (ceb.isEmpty()) {
            return this.createContent(parentContent, contentVO, contentVersionVO, categories);
        }
        try {
            ceb.throwIfNotEmpty();
        }
        catch (ConstraintException e) {
            logger.error((Object)("Problem creating content:" + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("Problem creating content:" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    public ContentVO update(ContentVO contentVO, Map categories, Database db) throws ConstraintException {
        this.db = db;
        this.populateContentVO(contentVO);
        ContentVersionVO contentVersionVO = this.createContentVersionVO(this.buildContentVersionDocument().asXML());
        ConstraintExceptionBuffer ceb = this.validate(contentVO, contentVersionVO);
        if (ceb.isEmpty()) {
            return this.updateContent(contentVO, contentVersionVO, categories);
        }
        logger.error((Object)"Error: Not valid content or version - cancelling update.");
        return null;
    }

    public ConstraintExceptionBuffer validate() {
        ContentVO contentVO = this.createContentVO();
        ContentVersionVO contentVersionVO = this.createContentVersionVO(this.buildContentVersionDocument().asXML());
        return this.validate(contentVO, contentVersionVO);
    }

    private ConstraintExceptionBuffer validate(ContentVO contentVO, ContentVersionVO contentVersionVO) {
        ConstraintExceptionBuffer ceb = contentVO.validate();
        ceb.add(contentVersionVO.validateAdvanced(this.contentTypeDefinitionVO));
        return ceb;
    }

    private ContentVO createContent(ContentVO parentContent, ContentVO contentVO, ContentVersionVO contentVersionVO, Map categories) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.info((Object)"************createContent**********");
            logger.info((Object)("parentContent:" + parentContent));
            logger.info((Object)("contentVO:" + contentVO));
            logger.info((Object)("contentVersionVO:" + contentVersionVO));
            logger.info((Object)("categories:" + categories));
        }
        Content content = ContentControllerProxy.getContentController().create(this.db, parentContent.getId(), this.contentTypeDefinitionVO.getId(), parentContent.getRepositoryId(), contentVO);
        ContentVersion newContentVersion = ContentVersionController.getContentVersionController().create(content.getId(), this.language.getId(), contentVersionVO, null, this.db);
        this.createCategories(newContentVersion, categories);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Returning:" + content + ":" + content.getValueObject()));
        }
        return content.getValueObject();
    }

    private ContentVO updateContent(ContentVO contentVO, ContentVersionVO contentVersionVO, Map categories) {
        try {
            Content content = ContentControllerProxy.getContentController().getContentWithId(contentVO.getId(), this.db);
            content.setValueObject(contentVO);
            ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(content.getId(), this.language.getId(), this.db);
            if (contentVersion != null) {
                contentVersion.getValueObject().setVersionValue(contentVersionVO.getVersionValue());
                this.deleteCategories(contentVersion);
                this.createCategories(contentVersion, categories);
            } else {
                ContentVersion newContentVersion = ContentVersionController.getContentVersionController().create(content.getId(), this.language.getId(), contentVersionVO, null, this.db);
                this.createCategories(newContentVersion, categories);
            }
            return content.getValueObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)e);
            return null;
        }
    }

    private void deleteCategories(ContentVersion contentVersion) throws Exception {
        ContentCategoryController.getController().deleteByContentVersion(contentVersion.getId(), this.db);
    }

    private void createCategories(ContentVersion contentVersion, Map categorieVOs) throws Exception {
        if (categorieVOs != null) {
            for (String attributeName : categorieVOs.keySet()) {
                List categoryVOs = (List)categorieVOs.get(attributeName);
                this.createCategory(contentVersion, attributeName, categoryVOs);
            }
        }
    }

    private void createCategory(ContentVersion contentVersion, String attributeName, List categoryVOs) throws Exception {
        List categories = this.categoryVOListToCategoryList(categoryVOs);
        ContentCategoryController.getController().create(categories, contentVersion, attributeName, this.db);
    }

    private List categoryVOListToCategoryList(List categoryVOList) throws Exception {
        ArrayList<Category> result = new ArrayList<Category>();
        for (CategoryVO categoryVO : categoryVOList) {
            result.add(CategoryController.getController().findById(categoryVO.getCategoryId(), this.db));
        }
        return result;
    }

    private ContentVO createContentVO() {
        ContentVO contentVO = new ContentVO();
        this.populateContentVO(contentVO);
        return contentVO;
    }

    private void populateContentVO(ContentVO contentVO) {
        contentVO.setName(this.contentValues.getName());
        if (this.contentValues.getPublishDateTime() != null) {
            contentVO.setPublishDateTime(this.contentValues.getPublishDateTime());
        }
        if (this.contentValues.getExpireDateTime() != null) {
            contentVO.setExpireDateTime(this.contentValues.getExpireDateTime());
        }
        contentVO.setIsBranch(Boolean.FALSE);
        contentVO.setCreatorName(this.principal.getName());
    }

    private ContentVersionVO createContentVersionVO(String versionValue) {
        ContentVersionVO contentVersion = new ContentVersionVO();
        contentVersion.setVersionComment("");
        contentVersion.setVersionModifier(this.principal.getName());
        contentVersion.setVersionValue(versionValue);
        return contentVersion;
    }

    private Collection getContentTypeAttributes() {
        return ContentTypeDefinitionController.getController().getContentTypeAttributes(this.contentTypeDefinitionVO.getSchemaValue());
    }

    private Document buildContentVersionDocument() {
        DOMBuilder builder = new DOMBuilder();
        Document document = builder.createDocument();
        Element rootElement = builder.addElement(document, "root");
        builder.addAttribute(rootElement, "xmlns", "x-schema:Schema.xml");
        Element attributesRoot = builder.addElement(rootElement, "attributes");
        this.buildAttributes(builder, attributesRoot);
        return document;
    }

    private void buildAttributes(DOMBuilder domBuilder, Element parentElement) {
        Collection typeAttributes = this.getContentTypeAttributes();
        for (ContentTypeAttribute attribute : typeAttributes) {
            Element element = domBuilder.addElement(parentElement, attribute.getName());
            String value = this.contentVersionValues.get(attribute.getName());
            if (value == null) continue;
            domBuilder.addCDATAElement(element, value);
        }
    }
}

