/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function.email;

import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.workflowtool.function.InfoglueFunction;
import org.infoglue.cms.applications.workflowtool.function.email.Attachment;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.mail.ByteDataSource;
import org.infoglue.cms.util.mail.MailService;
import org.infoglue.cms.util.mail.MailServiceFactory;
import org.infoglue.cms.util.mail.StringDataSource;

public class EmailFunction
extends InfoglueFunction {
    private static final Logger logger = Logger.getLogger((String)EmailFunction.class.getName());
    private static final String ADDRESS_DELIMITER = ",";
    private static final String EMAIL_PARAMETER_PREFIX = "email_";
    public static final String ILLEGAL_ADDRESSES_PARAMETER = "email_IllegalAddresses";
    public static final String ILLEGAL_ADDRESSES_PROPERTYSET_KEY = "email_IllegalAddresses";
    public static final String TO_PARAMETER = "email_to";
    public static final String FROM_PARAMETER = "email_from";
    public static final String ATTACHMENTS_PARAMETER = "attachments";
    private static final String TO_ARGUMENT = "to";
    private static final String FROM_ARGUMENT = "from";
    private static final String SUBJECT_ARGUMENT = "subject";
    private static final String BODY_ARGUMENT = "body";
    private static final String BODY_TYPE_ARGUMENT = "type";
    private static final String SILENT_MODE_ARGUMENT = "silent";
    private static final String STATUS_OK = "status.email.ok";
    private static final String STATUS_NOK = "status.email.nok";
    private MailService service;
    private MimeMessage message;
    private MimeMultipart multipart;
    private Collection attachments = new ArrayList();
    private Collection illegalAddresses;
    private boolean silentMode;

    protected void execute() throws WorkflowException {
        this.setFunctionStatus(this.silentMode ? STATUS_OK : STATUS_NOK);
        try {
            this.process();
        }
        catch (Exception e) {
            if (!this.silentMode) {
                this.throwException(e);
            }
            logger.warn((Object)"[silent mode]", (Throwable)e);
        }
        this.processIllegalAddresses();
    }

    private void processIllegalAddresses() {
        if (this.illegalAddresses.isEmpty()) {
            this.removeFromPropertySet("email_IllegalAddresses");
        } else {
            StringBuffer sb = new StringBuffer();
            Iterator i = this.illegalAddresses.iterator();
            while (i.hasNext()) {
                String address = i.next().toString();
                sb.append(String.valueOf(sb.length() > 0 ? ADDRESS_DELIMITER : "") + address);
            }
            this.setPropertySetDataString("email_IllegalAddresses", sb.toString());
        }
        this.setParameter("email_IllegalAddresses", new ArrayList());
    }

    private void process() throws WorkflowException {
        if (this.illegalAddresses.isEmpty()) {
            this.initializeMailService();
            this.createMessage();
            this.sendMessage();
        }
    }

    private void createMessage() throws WorkflowException {
        if (this.attachments.isEmpty()) {
            this.createSimpleMessage();
        } else {
            this.createMultipartMessage();
        }
    }

    private void createSimpleMessage() throws WorkflowException {
        logger.debug((Object)"Creating simple message.");
        this.initializeMessage();
        this.initializeSimpleBody();
    }

    private void createMultipartMessage() throws WorkflowException {
        logger.debug((Object)"Creating message.");
        this.initializeMessage();
        this.initializeMultipart();
        this.createMainBodyPart();
        this.createAttachments();
    }

    private void initializeMessage() throws WorkflowException {
        logger.debug((Object)"Initializing message.");
        this.message = this.service.createMessage();
        this.initializeTo();
        this.initializeFrom();
        this.initializeSubject();
    }

    private void initializeSimpleBody() throws WorkflowException {
        logger.debug((Object)"Initializing simple body.");
        try {
            this.message.setDataHandler(this.getDataHandler(this.translate(this.getArgument(BODY_ARGUMENT)), this.translate(this.getArgument(BODY_TYPE_ARGUMENT))));
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    private void initializeMultipart() throws WorkflowException {
        logger.debug((Object)"Initializing multipart.");
        try {
            this.multipart = new MimeMultipart();
            this.message.setContent((Multipart)this.multipart);
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    private void initializeTo() throws WorkflowException {
        logger.debug((Object)"Initializing to.");
        try {
            if (this.argumentExists(TO_ARGUMENT)) {
                logger.debug((Object)("Adding 'to' from argument [" + this.getArgument(TO_ARGUMENT) + "]."));
                this.message.addRecipients(Message.RecipientType.TO, (Address[])this.createAddresses(this.getArgument(TO_ARGUMENT)));
            }
            if (this.parameterExists(TO_PARAMETER)) {
                logger.debug((Object)"Adding 'to' from parameters");
                this.message.addRecipients(Message.RecipientType.TO, (Address[])this.addressesToArray((List)this.getParameter(TO_PARAMETER)));
            }
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    private void initializeFrom() throws WorkflowException {
        logger.debug((Object)"Initializing from.");
        try {
            if (this.argumentExists(FROM_ARGUMENT)) {
                logger.debug((Object)("Adding 'from' from argument [" + this.getArgument(FROM_ARGUMENT) + "]."));
                this.message.addFrom((Address[])this.createAddresses(this.getArgument(FROM_ARGUMENT)));
            }
            if (this.parameterExists(FROM_PARAMETER)) {
                logger.debug((Object)"Adding 'from' from parameter.");
                this.message.addFrom((Address[])this.addressesToArray((List)this.getParameter(FROM_PARAMETER)));
            }
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    private void initializeSubject() throws WorkflowException {
        logger.debug((Object)"Initializing subject.");
        try {
            this.message.setSubject(this.translate(this.getArgument(SUBJECT_ARGUMENT)), "utf-8");
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    private void createMainBodyPart() throws WorkflowException {
        logger.debug((Object)"Initializing main body part.");
        try {
            MimeBodyPart part = new MimeBodyPart();
            part.setDataHandler(this.getDataHandler(this.translate(this.getArgument(BODY_ARGUMENT)), this.translate(this.getArgument(BODY_TYPE_ARGUMENT))));
            this.multipart.addBodyPart((BodyPart)part);
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    private void createAttachments() throws WorkflowException {
        logger.debug((Object)("Found " + this.attachments.size() + " attachments."));
        Iterator i = this.attachments.iterator();
        while (i.hasNext()) {
            this.createAttachment((Attachment)i.next());
        }
    }

    private void createAttachment(Attachment attachment) throws WorkflowException {
        try {
            MimeBodyPart part = new MimeBodyPart();
            part.setDataHandler(this.getDataHandler(attachment.getBytes(), attachment.getContentType()));
            part.setFileName(attachment.getName());
            this.multipart.addBodyPart((BodyPart)part);
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    private InternetAddress[] createAddresses(String s) throws WorkflowException {
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
        StringTokenizer st = new StringTokenizer(s, ADDRESS_DELIMITER);
        while (st.hasMoreTokens()) {
            InternetAddress address = this.createAddress(st.nextToken());
            if (address == null) continue;
            addresses.add(address);
        }
        return this.addressesToArray(addresses);
    }

    private InternetAddress[] addressesToArray(List list) {
        InternetAddress[] addresses = new InternetAddress[list.size()];
        int i = 0;
        while (i < list.size()) {
            addresses[i] = (InternetAddress)list.get(i);
            ++i;
        }
        return addresses;
    }

    private InternetAddress createAddress(String email) {
        try {
            return new InternetAddress(email);
        }
        catch (Exception e) {
            this.illegalAddresses.add(email);
            return null;
        }
    }

    private void initializeMailService() throws WorkflowException {
        logger.debug((Object)"Initializing mail service.");
        try {
            this.service = MailServiceFactory.getService();
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    private void sendMessage() throws WorkflowException {
        logger.debug((Object)"Sending message.");
        if (this.illegalAddresses.isEmpty()) {
            try {
                if (this.hasRecipients()) {
                    this.service.send((Message)this.message);
                }
                this.setFunctionStatus(STATUS_OK);
            }
            catch (SystemException e) {
                this.handleSendException(e);
            }
        }
    }

    private boolean hasRecipients() throws WorkflowException {
        try {
            return this.message.getAllRecipients() != null && this.message.getAllRecipients().length > 0;
        }
        catch (Exception e) {
            this.throwException(e);
            return false;
        }
    }

    private void handleSendException(SystemException e) throws WorkflowException {
        if (e.getCause() instanceof SendFailedException) {
            this.populateIllegalAddresses((SendFailedException)e.getCause());
        } else {
            this.throwException(e);
        }
    }

    private void populateIllegalAddresses(SendFailedException e) {
        Address[] invalidAddresses = e.getInvalidAddresses() == null ? new Address[]{} : e.getInvalidAddresses();
        int i = 0;
        while (i < invalidAddresses.length) {
            this.illegalAddresses.add(invalidAddresses[i].toString());
            ++i;
        }
    }

    private DataHandler getDataHandler(String content, String type) {
        return new DataHandler((DataSource)new StringDataSource(content, this.getContentType(type), "utf-8"));
    }

    private DataHandler getDataHandler(byte[] content, String type) {
        return new DataHandler((DataSource)new ByteDataSource(content, type));
    }

    private String getContentType(String type) {
        return String.valueOf(type) + ";charset=" + "utf-8";
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.illegalAddresses = (Collection)this.getParameter("email_IllegalAddresses", new ArrayList());
        this.silentMode = this.getArgument(SILENT_MODE_ARGUMENT, "false").equalsIgnoreCase("true");
        this.attachments = (Collection)this.getParameter(ATTACHMENTS_PARAMETER, new ArrayList());
    }
}

