/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function.email;

import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.Collection;
import org.infoglue.cms.applications.workflowtool.function.ContentFunction;
import org.infoglue.cms.applications.workflowtool.function.email.DigitalAssetAttachment;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.DigitalAsset;

public class AttachmentsProvider
extends ContentFunction {
    protected void execute() throws WorkflowException {
        this.setParameter("attachments", this.getAttachments());
    }

    private Collection getAttachments() throws WorkflowException {
        Collection digitalAssets = this.getDigitalAssets();
        ArrayList<DigitalAssetAttachment> attachments = new ArrayList<DigitalAssetAttachment>();
        for (DigitalAsset digitalAsset : digitalAssets) {
            attachments.add(new DigitalAssetAttachment(digitalAsset.getAssetFileName(), digitalAsset.getAssetContentType(), digitalAsset.getAssetBytes()));
        }
        return attachments;
    }

    private Collection getDigitalAssets() throws WorkflowException {
        if (this.getContentVersionVO() != null) {
            try {
                ContentVersion contentVersion = ContentVersionController.getContentVersionController().getReadOnlyContentVersionWithId(this.getContentVersionVO().getContentVersionId(), this.getDatabase());
                if (contentVersion != null) {
                    return contentVersion.getDigitalAssets();
                }
            }
            catch (Exception e) {
                this.throwException(e);
            }
        }
        return new ArrayList();
    }
}

