/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function.defaultvalue;

import com.opensymphony.workflow.WorkflowException;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.workflowtool.function.defaultvalue.DatePopulator;

public class ExpireDatePopulator
extends DatePopulator {
    private static final Logger logger = Logger.getLogger((String)ExpireDatePopulator.class.getName());
    private static final String YEARS_AHEAD_ARGUMENT = "yearsAhead";
    private static final int DEFAULT_YEARS_AHEAD = 50;
    private int yearsAhead = 50;

    protected void populate() throws WorkflowException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, calendar.get(1) + this.yearsAhead);
        super.populate("content_ExpireDateTime", calendar.getTime());
    }

    protected void populate(String name) throws WorkflowException {
        this.populate();
    }

    protected void populate(String name, String value) throws WorkflowException {
        this.populate();
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.initializeYearsAhead();
    }

    private void initializeYearsAhead() {
        block5: {
            if (this.argumentExists(YEARS_AHEAD_ARGUMENT)) {
                try {
                    int temporary = Integer.parseInt(this.getArgument(YEARS_AHEAD_ARGUMENT).toString());
                    if (temporary > 0) {
                        this.yearsAhead = temporary;
                        logger.debug((Object)("Using [" + temporary + "] as years ahead value."));
                        break block5;
                    }
                    logger.warn((Object)("Illegal years ahead argument [" + temporary + "]."));
                }
                catch (Exception e) {
                    logger.warn((Object)("Illegal years ahead argument [" + e.getMessage() + "]."));
                }
            } else {
                logger.debug((Object)"Using default years ahead value.");
            }
        }
    }
}

