/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import org.infoglue.cms.applications.workflowtool.function.ErrorPopulator;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class UserErrorPopulator
extends ErrorPopulator {
    private static final String USER_ERROR_PROPERTYSET_PREFIX = "error_systemuser_";
    private SystemUserVO systemUserVO;

    protected void clean() throws WorkflowException {
        this.clean(USER_ERROR_PROPERTYSET_PREFIX);
    }

    protected void populate() throws WorkflowException {
        ConstraintExceptionBuffer ceb = this.systemUserVO.validate();
        this.populate(ceb, null);
        if (ceb.isEmpty()) {
            this.checkUniqueUserName();
        }
    }

    protected void checkUniqueUserName() throws WorkflowException {
        try {
            if (UserControllerProxy.getController().getUser(this.systemUserVO.getUserName()) != null) {
                this.setPropertySetString("error_systemuser_userName", this.getStringManager().getString("302"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.systemUserVO = (SystemUserVO)this.getParameter("systemuser");
    }
}

