/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.workflowtool.function.InfoglueFunction;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGlueRole;

public class UserCreator
extends InfoglueFunction {
    private static final Logger logger = Logger.getLogger((String)UserCreator.class.getName());
    private static final String STATUS_OK = "status.user.ok";
    private static final String STATUS_NOK = "status.user.nok";
    private SystemUserVO systemUserVO;
    private String[] roleNames;
    private String[] groupNames;

    protected void execute() throws WorkflowException {
        this.setFunctionStatus(STATUS_NOK);
        if (this.systemUserVO.validate().isEmpty()) {
            try {
                UserControllerProxy controller = UserControllerProxy.getController(this.getDatabase());
                controller.createUser(this.systemUserVO);
                controller.updateUser(this.systemUserVO, this.roleNames, this.groupNames);
                this.setFunctionStatus(STATUS_OK);
            }
            catch (Exception e) {
                this.throwException(e);
            }
        }
    }

    private String[] getRoleNames(List roles) {
        String[] names = new String[roles.size()];
        int i = 0;
        while (i < roles.size()) {
            InfoGlueRole role = (InfoGlueRole)roles.get(i);
            names[i] = role.getName();
            logger.debug((Object)("Adding role [" + role.getName() + "]"));
            ++i;
        }
        return names;
    }

    private String[] getGroupNames(List groups) {
        String[] names = new String[groups.size()];
        int i = 0;
        while (i < groups.size()) {
            InfoGlueGroup group = (InfoGlueGroup)groups.get(i);
            names[i] = group.getName();
            logger.debug((Object)("Adding group [" + group.getName() + "]"));
            ++i;
        }
        return names;
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.systemUserVO = (SystemUserVO)this.getParameter("systemuser");
        this.roleNames = this.getRoleNames((List)this.getParameter("roles"));
        this.groupNames = this.getGroupNames((List)this.getParameter("groups"));
    }
}

