/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import org.infoglue.cms.applications.workflowtool.function.CategoryProvider;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.entities.management.CategoryVO;

public class SimpleCategoryProvider
extends CategoryProvider {
    private static final String CATEGORY_PROPERTYSET_PREFIX = "category_";
    private static final String NAME_ARGUMENT = "attributeName";
    private static final String ROOT_ARGUMENT = "rootCategory";
    private CategoryVO rootCategory;
    private String attributeName;

    protected void execute() throws WorkflowException {
        this.cleanPropertySet();
        this.populate();
    }

    private void populate() throws WorkflowException {
        ArrayList<CategoryVO> result = new ArrayList<CategoryVO>();
        for (CategoryVO categoryVO : this.rootCategory.getChildren()) {
            String key = this.getCategoryKey(categoryVO);
            String value = this.getRequestParameter(key);
            if (!this.parameterExists(key) || value == null || !value.equals("1")) continue;
            this.setPropertySetDataString(this.getCategoryKey(categoryVO), "1");
            result.add(categoryVO);
        }
        this.getCategories().put(this.attributeName, result);
    }

    private void cleanPropertySet() throws WorkflowException {
        this.removeFromPropertySet(this.getBaseKey(), true);
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.attributeName = this.getArgument(NAME_ARGUMENT);
        this.rootCategory = this.getRootCategory(this.getArgument(ROOT_ARGUMENT));
    }

    private CategoryVO getRootCategory(String path) throws WorkflowException {
        try {
            CategoryVO categoryVO = CategoryController.getController().findByPath(path, this.getDatabase());
            return CategoryController.getController().findWithChildren(categoryVO.getId(), this.getDatabase());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkflowException("SimpleCategoryProvider.getRootCategory() : " + e);
        }
    }

    private String getBaseKey() {
        return CATEGORY_PROPERTYSET_PREFIX + this.attributeName + "_";
    }

    private String getCategoryKey(CategoryVO categoryVO) {
        return String.valueOf(this.getBaseKey()) + categoryVO.getName();
    }
}

