/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.workflowtool.function.InfoglueFunction;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;

public class RolesProvider
extends InfoglueFunction {
    private static final Logger logger = Logger.getLogger((String)RolesProvider.class.getName());
    public static final String ROLES_PARAMETER = "roles";
    private static final String ROLES_PROPERTYSET_PREFIX = "roles_";
    private static final String MODE_ARGUMENT = "mode";
    private static final int REQUEST_MODE = 0;
    private static final String REQUEST_MODE_NAME = "request";
    private static final int ARGUMENT_MODE = 1;
    private static final String ARGUMENT_MODE_NAME = "argument";
    private static final int PRINCIPAL_MODE = 2;
    private static final String PRINCIPAL_MODE_NAME = "principal";
    private static final String ROLES_ARGUMENT = "roles";
    private int mode;
    private List roles = new ArrayList();

    protected void execute() throws WorkflowException {
        switch (this.mode) {
            case 1: {
                this.populateRolesFromAttribute();
                break;
            }
            case 2: {
                this.populateRolesFromPrincipal();
                break;
            }
            default: {
                this.populateRolesFromRequest();
            }
        }
        this.setParameter("roles", this.roles);
    }

    private void populateRolesFromAttribute() throws WorkflowException {
        logger.debug((Object)"Populating from attribute.");
        StringTokenizer st = new StringTokenizer(this.getArgument("roles"), ",");
        while (st.hasMoreTokens()) {
            this.populateRole(st.nextToken());
        }
    }

    private void populateRolesFromPrincipal() throws WorkflowException {
        logger.debug((Object)"Populating from principal.");
        Iterator i = this.getPrincipal().getRoles().iterator();
        while (i.hasNext()) {
            this.roles.add(i.next());
        }
    }

    private void populateRolesFromRequest() throws WorkflowException {
        logger.debug((Object)"Populating from request.");
        Iterator i = this.getParameters().keySet().iterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            if (!key.startsWith(ROLES_PROPERTYSET_PREFIX)) continue;
            this.populateRole(key.substring(ROLES_PROPERTYSET_PREFIX.length()));
        }
    }

    private void populateRole(String roleName) throws WorkflowException {
        try {
            this.roles.add(RoleControllerProxy.getController(this.getDatabase()).getRole(roleName));
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.mode = this.getMode(this.getArgument(MODE_ARGUMENT, REQUEST_MODE_NAME));
    }

    private int getMode(String modeName) {
        HashMap<String, Integer> modes = new HashMap<String, Integer>();
        modes.put(REQUEST_MODE_NAME, new Integer(0));
        modes.put(ARGUMENT_MODE_NAME, new Integer(1));
        modes.put(PRINCIPAL_MODE_NAME, new Integer(2));
        return modes.containsKey(modeName) ? (Integer)modes.get(modeName) : 0;
    }
}

