/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.workflowtool.function.ContentProvider;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.entities.management.Repository;

public class PathContentProvider
extends ContentProvider {
    private static final Logger logger = Logger.getLogger((String)PathContentProvider.class.getName());
    private static final String CONTENT_PARAMETER_NAME_ARGUMENT = "contentParameterName";
    private static final String CONTENT_VERSION_PARAMETER_NAME_ARGUMENT = "contentVersionParameterName";
    private static final String PATH_ARGUMENT = "path";
    private static final String REPOSITORY_NAME_ARGUMENT = "repository";
    private String repositoryName;
    private String path;
    private String contentParameterName;
    private String contentVersionParameterName;

    protected String getContentParameterName() {
        return this.contentParameterName;
    }

    protected String getContentVersionParameterName() {
        return this.contentVersionParameterName;
    }

    protected void initializeContentVO() throws WorkflowException {
        try {
            logger.debug((Object)("Using repository=[" + this.repositoryName + "] path=[" + this.path + "]"));
            Repository repository = RepositoryController.getController().getRepositoryWithName(this.repositoryName, this.getDatabase());
            if (repository == null) {
                this.throwException("No repository with the name [" + this.repositoryName + "] found.");
            }
            this.setContentVO(ContentController.getContentController().getContentVOWithPath(repository.getId(), this.path, false, this.getPrincipal(), this.getDatabase()));
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.path = this.getArgument(PATH_ARGUMENT);
        this.repositoryName = this.getArgument(REPOSITORY_NAME_ARGUMENT);
        this.contentParameterName = this.getArgument(CONTENT_PARAMETER_NAME_ARGUMENT, "content");
        this.contentVersionParameterName = this.getArgument(CONTENT_VERSION_PARAMETER_NAME_ARGUMENT, "contentVersion");
    }
}

