/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import org.infoglue.cms.applications.workflowtool.function.InfoglueFunction;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.workflow.OwnerFactory;

public class Owner
extends InfoglueFunction {
    private static final String OWNER_PARAMETER = "owner";
    private static final String ROLE_ARGUMENT = "role";
    private static final String GROUP_ARGUMENT = "group";
    private String roleName;
    private String groupName;

    protected void execute() throws WorkflowException {
        try {
            InfoGlueRole role = RoleControllerProxy.getController(this.getDatabase()).getRole(this.roleName);
            if (this.groupName == null) {
                this.setParameter(OWNER_PARAMETER, OwnerFactory.create(role).getIdentifier());
            } else {
                InfoGlueGroup group = GroupControllerProxy.getController(this.getDatabase()).getGroup(this.groupName);
                this.setParameter(OWNER_PARAMETER, OwnerFactory.create(role, group).getIdentifier());
            }
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.roleName = this.getArgument(ROLE_ARGUMENT);
        this.groupName = this.getArgument(GROUP_ARGUMENT, null);
    }
}

