/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import java.util.List;
import org.infoglue.cms.applications.workflowtool.function.InfoglueFunction;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.management.LanguageVO;

public class LanguageProvider
extends InfoglueFunction {
    public static final String LANGUAGE_PARAMETER = "language";
    public static final String LANGUAGE_PROPERTYSET_KEY = "languageId";
    public static final String LANGUAGE_CODE_ARGUMENT = "code";
    public static final String ARGUMENT_SCOPE_ARGUMENT = "scope";
    public static final String LANGUAGE_ID_IDENTIFIER = "languageId";

    protected void execute() throws WorkflowException {
        LanguageVO languageVO = null;
        if (this.argumentExists(ARGUMENT_SCOPE_ARGUMENT) && this.getArgument(ARGUMENT_SCOPE_ARGUMENT).equalsIgnoreCase("argument")) {
            languageVO = this.getLanguageWithCode(this.getArgument(LANGUAGE_CODE_ARGUMENT).toString());
        } else if (this.argumentExists(ARGUMENT_SCOPE_ARGUMENT) && this.getArgument(ARGUMENT_SCOPE_ARGUMENT).equalsIgnoreCase("parameter")) {
            String altLanguageIdString;
            String parameterNameString;
            String languageIdString = this.getParameterStringValue("languageId", false);
            if (this.argumentExists("parameterName") && (parameterNameString = this.getArgument("parameterName")) != null && !parameterNameString.equals("") && (altLanguageIdString = this.getParameterStringValue(parameterNameString, false)) != null && !altLanguageIdString.equals("")) {
                languageIdString = altLanguageIdString;
            }
            if (languageIdString != null) {
                languageVO = this.getLanguageWithID(languageIdString);
            }
        }
        if (languageVO == null) {
            if (this.propertySetContains("languageId")) {
                languageVO = this.getLanguageWithID(this.getPropertySetString("languageId"));
            }
            if (languageVO == null && this.parameterExists("languageId")) {
                languageVO = this.getLanguageWithID(this.getParameter("languageId").toString());
            }
            if (languageVO == null && this.argumentExists(LANGUAGE_CODE_ARGUMENT)) {
                languageVO = this.getLanguageWithCode(this.getArgument(LANGUAGE_CODE_ARGUMENT));
            }
            if (languageVO == null) {
                languageVO = this.getAnyLanguage();
            }
        }
        this.populate(languageVO);
    }

    private void populate(LanguageVO languageVO) throws WorkflowException {
        if (languageVO == null && this.propertySetContains("languageId")) {
            this.removeFromPropertySet("languageId");
        }
        if (languageVO != null) {
            this.setParameter(LANGUAGE_PARAMETER, languageVO);
            this.setPropertySetString("languageId", languageVO.getId().toString());
        }
    }

    public LanguageVO getAnyLanguage() throws WorkflowException {
        LanguageVO languageVO = null;
        try {
            List languages = LanguageController.getController().getLanguageVOList(this.getDatabase());
            if (!languages.isEmpty()) {
                languageVO = (LanguageVO)languages.get(0);
            }
            this.throwException("No languages found...");
        }
        catch (Exception e) {
            this.throwException("Language.getAnyLanguage() : " + e);
        }
        return languageVO;
    }

    public LanguageVO getLanguageWithID(String languageId) throws WorkflowException {
        LanguageVO languageVO = null;
        try {
            languageVO = LanguageController.getController().getLanguageVOWithId(new Integer(languageId), this.getDatabase());
        }
        catch (Exception e) {
            throw new WorkflowException("Language.getLanguageWithID() : " + e);
        }
        return languageVO;
    }

    public LanguageVO getLanguageWithCode(String code) throws WorkflowException {
        LanguageVO languageVO = null;
        try {
            languageVO = LanguageController.getController().getLanguageVOWithCode(code, this.getDatabase());
        }
        catch (Exception e) {
            this.throwException("Language.getLanguageWithCode() : " + e);
        }
        return languageVO;
    }
}

