/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.WorkflowException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.Session;
import org.infoglue.cms.applications.workflowtool.util.InfoglueWorkflowBase;
import org.infoglue.cms.security.InfoGluePrincipal;

public abstract class InfoglueFunction
extends InfoglueWorkflowBase
implements FunctionProvider {
    private static final Logger logger = Logger.getLogger((String)InfoglueFunction.class.getName());
    private static final String REQUEST_PARAMETER = "request";
    public static final String PRINCIPAL_PARAMETER = "principal";
    public static final String LOCALE_PARAMETER = "locale";
    private Locale locale;
    private InfoGluePrincipal principal;

    public final void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        try {
            this.storeContext(transientVars, args, ps);
            logger.debug((Object)(String.valueOf(this.getClass().getName()) + ".execute()--------- START"));
            this.initialize();
            this.execute();
            logger.debug((Object)(String.valueOf(this.getClass().getName()) + ".execute()--------- STOP"));
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.initializeLocale();
        this.initializePrincipal();
    }

    private void initializeLocale() throws WorkflowException {
        this.locale = this.parameterExists(LOCALE_PARAMETER) ? (Locale)this.getParameter(LOCALE_PARAMETER) : this.getSession().getLocale();
    }

    private void initializePrincipal() throws WorkflowException {
        this.principal = this.parameterExists(PRINCIPAL_PARAMETER) ? (InfoGluePrincipal)this.getParameter(PRINCIPAL_PARAMETER) : this.getSession().getInfoGluePrincipal();
    }

    private Session getSession() throws WorkflowException {
        return new Session(((HttpServletRequest)this.getParameter(REQUEST_PARAMETER)).getSession());
    }

    protected abstract void execute() throws WorkflowException;

    protected final String getRequestParameter(String key) {
        Object value = this.getParameters().get(key);
        if (value != null && value.getClass().isArray()) {
            String[] values = (String[])value;
            value = values.length == 1 ? values[0] : null;
        }
        return value == null ? null : value.toString();
    }

    protected final Locale getLocale() throws WorkflowException {
        return this.locale;
    }

    protected final InfoGluePrincipal getPrincipal() {
        return this.principal;
    }

    protected final void setFunctionStatus(String status) {
        logger.debug((Object)("setFunctionStatus(" + status + ")"));
        this.getPropertySet().setString("workflow_status", status);
    }
}

