/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import java.io.File;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.workflowtool.function.InfoglueFunction;
import org.infoglue.cms.io.FileHelper;
import org.infoglue.cms.util.CmsPropertyHandler;

public class FilePopulator
extends InfoglueFunction {
    private static final Logger logger = Logger.getLogger((String)FilePopulator.class.getName());
    private static final String PATH_ARGUMENT = "path";
    private static final String PROPERTYSET_KEY_ARGUMENT = "key";
    private String path;
    private String key;

    protected void execute() throws WorkflowException {
        try {
            String fullPath = this.getFullPath();
            String unparsed = FileHelper.getFileAsString(new File(fullPath));
            String parsed = this.translate(unparsed);
            logger.debug((Object)("path=[" + fullPath + "],unparsed=[" + unparsed + "],parsed=[" + parsed + "]"));
            this.setPropertySetDataString(this.key, parsed);
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    private String getFullPath() {
        return String.valueOf(CmsPropertyHandler.getContextRootPath()) + this.path;
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.path = this.getArgument(PATH_ARGUMENT);
        this.key = this.getArgument(PROPERTYSET_KEY_ARGUMENT);
    }
}

