/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.workflowtool.function.InfoglueFunction;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.StringManager;
import org.infoglue.cms.util.StringManagerFactory;

public abstract class ErrorPopulator
extends InfoglueFunction {
    private static final Logger logger = Logger.getLogger((String)ErrorPopulator.class.getName());
    private static final String PACKAGE = "org.infoglue.cms.entities";
    private StringManager stringManager;

    protected ErrorPopulator() {
    }

    protected final void execute() throws WorkflowException {
        this.clean();
        this.populate();
    }

    protected abstract void clean() throws WorkflowException;

    protected abstract void populate() throws WorkflowException;

    protected final void clean(String errorPrefix) throws WorkflowException {
        this.removeFromPropertySet(errorPrefix, true);
    }

    protected void populate(ConstraintExceptionBuffer ceb, String languageCode) throws WorkflowException {
        ConstraintException e = ceb.toConstraintException();
        while (e != null) {
            this.populateError(e, languageCode);
            e = e.getChainedException();
        }
    }

    private void populateError(ConstraintException e, String languageCode) throws WorkflowException {
        this.setPropertySetString(this.getErrorKey(e, languageCode), this.getStringManager().getString(e.getErrorCode()));
    }

    private String getErrorKey(ConstraintException e, String languageCode) {
        String fieldName = e.getFieldName();
        int index = fieldName.indexOf(46);
        if (index == -1) {
            return "error_" + e.getFieldName();
        }
        String before = fieldName.substring(0, index).toLowerCase();
        String after = fieldName.substring(index + 1);
        String key = "error_" + before + "_" + after;
        logger.debug((Object)("error field name converted from [" + fieldName + "] to [" + before + "_" + after + "]."));
        if (languageCode != null && !languageCode.equals("")) {
            key = String.valueOf(languageCode) + "_" + key;
        }
        return key;
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.stringManager = StringManagerFactory.getPresentationStringManager(PACKAGE, this.getLocale());
    }

    protected final StringManager getStringManager() {
        return this.stringManager;
    }
}

