/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.applications.workflowtool.function.ContentFunction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentStateController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.PublicationController;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.publishing.PublicationVO;

public class ContentPublisher
extends ContentFunction {
    private static final String STATUS_OK = "status.publish.ok";
    private static final String STATUS_NOK = "status.publish.nok";
    private static final String STATUS_MORE_VERSIONS = "status.publish.okwithmoreworkingversions";

    protected void execute() throws WorkflowException {
        this.setFunctionStatus(STATUS_NOK);
        if (this.getContentVO() != null && this.getContentVersionVO() != null) {
            this.publish();
        }
    }

    private void publish() throws WorkflowException {
        try {
            if (this.getContentVersionVO().getStateId().equals(ContentVersionVO.WORKING_STATE)) {
                ArrayList events = new ArrayList();
                ContentStateController.changeState(this.getContentVersionVO().getContentVersionId(), ContentVersionVO.PUBLISH_STATE, "Auto", false, this.getPrincipal(), this.getContentVO().getId(), this.getDatabase(), events);
                PublicationController.getController().createAndPublish(this.createPublicationVO(), events, true, this.getPrincipal(), this.getDatabase());
                boolean ok = true;
                List languages = LanguageController.getController().getLanguageVOList(this.getContentVO().getRepositoryId(), this.getDatabase());
                for (LanguageVO languageVO : languages) {
                    ContentVersionVO contentVersionVO;
                    if (languageVO.getId().intValue() == this.getContentVersionVO().getLanguageId().intValue() || (contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(this.getContentVO().getId(), languageVO.getId(), this.getDatabase())) == null || contentVersionVO.getStateId().intValue() != ContentVersionVO.WORKING_STATE.intValue()) continue;
                    if (languageVO == null && this.propertySetContains("languageId")) {
                        this.removeFromPropertySet("languageId");
                    }
                    if (languageVO != null) {
                        this.setParameter("language", languageVO);
                        this.setPropertySetString("languageId", languageVO.getId().toString());
                    }
                    this.setFunctionStatus(STATUS_MORE_VERSIONS);
                    ok = false;
                    break;
                }
                if (ok) {
                    this.setFunctionStatus(STATUS_OK);
                }
            }
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    private PublicationVO createPublicationVO() {
        PublicationVO publicationVO = new PublicationVO();
        publicationVO.setName("Workflow publication by " + this.getPrincipal().getName());
        publicationVO.setDescription("Workflow publication by " + this.getPrincipal().getName());
        publicationVO.setRepositoryId(this.getContentVO().getRepositoryId());
        return publicationVO;
    }
}

