/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.workflowtool.function.InfoglueFunction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.LanguageVO;

public class ContentProvider
extends InfoglueFunction {
    private static final Logger logger = Logger.getLogger((String)ContentProvider.class.getName());
    public static final String CONTENT_ID_PROPERTYSET_KEY = "content_contentID";
    private LanguageVO languageVO;
    private ContentVO contentVO;
    private ContentVersionVO contentVersionVO;

    protected void execute() throws WorkflowException {
        this.initializeContentVO();
        this.initializeContentVersionVO();
        if (this.getContentParameterName() != null && this.getContentParameterName().length() > 0) {
            this.setParameter(this.getContentParameterName(), this.contentVO);
        }
        if (this.getContentVersionParameterName() != null && this.getContentVersionParameterName().length() > 0) {
            this.setParameter(this.getContentVersionParameterName(), this.contentVersionVO);
        }
    }

    protected void setContentVO(ContentVO contentVO) {
        this.contentVO = contentVO;
    }

    protected void setContentVersionVO(ContentVersionVO contentVersionVO) {
        this.contentVersionVO = contentVersionVO;
    }

    protected final LanguageVO getLanguageVO() {
        return this.languageVO;
    }

    protected String getContentParameterName() {
        return "content";
    }

    protected String getContentVersionParameterName() {
        return "contentVersion";
    }

    protected void initializeContentVO() throws WorkflowException {
        if (!this.propertySetContains(CONTENT_ID_PROPERTYSET_KEY)) {
            return;
        }
        try {
            Integer contentID = new Integer(this.getPropertySetString(CONTENT_ID_PROPERTYSET_KEY));
            this.setContentVO(ContentController.getContentController().getContentVOWithId(contentID, this.getDatabase()));
        }
        catch (Exception e) {
            logger.warn((Object)"Non-existing contentId found; removing from the resultset.");
            this.removeFromPropertySet(CONTENT_ID_PROPERTYSET_KEY);
        }
    }

    protected void initializeContentVersionVO() throws WorkflowException {
        if (this.contentVO != null) {
            try {
                ContentVersionController controller = ContentVersionController.getContentVersionController();
                this.setContentVersionVO(controller.getLatestActiveContentVersionVO(this.contentVO.getId(), this.languageVO.getId(), this.getDatabase()));
            }
            catch (Exception e) {
                this.throwException(e);
            }
        }
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.languageVO = (LanguageVO)this.getParameter("language");
    }
}

