/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infoglue.cms.applications.workflowtool.function.ContentFunction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.entities.management.ContentTypeAttribute;
import org.infoglue.cms.entities.management.ContentTypeDefinition;

public class ContentPropertysetPopulator
extends ContentFunction {
    private final String PROPERTYSET_PREFIX_ARGUMENT = "propertysetPrefix";
    private final String ATTRIBUTE_PREFIX_ARGUMENT = "attributePrefix";
    private String propertysetPrefix;
    private String attributePrefix;

    protected void execute() throws WorkflowException {
        Map attributeValues = this.getAttributeValues();
        Iterator i = attributeValues.keySet().iterator();
        while (i.hasNext()) {
            String name = i.next().toString();
            String value = (String)attributeValues.get(name);
            if (!name.startsWith(this.attributePrefix)) continue;
            this.setPropertySetDataString(String.valueOf(this.propertysetPrefix) + name, value);
        }
    }

    protected final Map getAttributeValues() throws WorkflowException {
        HashMap<String, String> values = new HashMap<String, String>();
        if (this.getContentVO() != null && this.getContentVersionVO() != null) {
            try {
                ContentTypeDefinitionController ctdController = ContentTypeDefinitionController.getController();
                ContentTypeDefinition ctd = ctdController.getContentTypeDefinitionWithId(this.getContentVO().getContentTypeDefinitionId(), this.getDatabase());
                List contentTypeAttributes = ctdController.getContentTypeAttributes(ctd.getSchemaValue());
                for (ContentTypeAttribute attribute : contentTypeAttributes) {
                    values.put(attribute.getName(), ContentVersionController.getContentVersionController().getAttributeValue(this.getContentVersionVO(), attribute.getName(), false));
                }
            }
            catch (Exception e) {
                this.throwException(e);
            }
        }
        return values;
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.propertysetPrefix = this.getArgument("propertysetPrefix", "");
        this.attributePrefix = this.getArgument("attributePrefix", "");
    }
}

