/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.workflowtool.function.InfoglueFunction;
import org.infoglue.cms.applications.workflowtool.util.ContentValues;
import org.infoglue.cms.applications.workflowtool.util.ContentVersionValues;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.entities.management.ContentTypeAttribute;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;

public class ContentPopulator
extends InfoglueFunction {
    private static final Logger logger = Logger.getLogger((String)ContentPopulator.class.getName());
    public static final String CONTENT_PROPERTYSET_PREFIX = "content_";
    public static final String CONTENT_VERSION_PROPERTYSET_PREFIX = "contentversion_";
    public static final String CONTENT_VERSION_PROPERTYSET_LANGUAGE_PREFIX = "languageId_";
    public static final String CONTENT_VALUES_PARAMETER = "contentValues";
    public static final String CONTENT_VERSION_VALUES_PARAMETER = "contentVersionValues";
    private ContentTypeDefinitionVO contentTypeDefinitionVO;
    private LanguageVO languageVO;

    protected void execute() throws WorkflowException {
        this.populateContentValues();
        this.populateContentVersionValues();
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.contentTypeDefinitionVO = (ContentTypeDefinitionVO)this.getParameter("contentTypeDefinition");
        this.languageVO = (LanguageVO)this.getParameter("language");
    }

    protected void populateContentValues() throws WorkflowException {
        ContentValues result = new ContentValues();
        result.setName(this.populate("content_Name"));
        result.setPublishDateTime(this.populate("content_PublishDateTime"));
        result.setExpireDateTime(this.populate("content_ExpireDateTime"));
        this.setParameter(CONTENT_VALUES_PARAMETER, result);
    }

    protected void populateContentVersionValues() throws WorkflowException {
        ContentVersionValues result = new ContentVersionValues();
        List contentTypeAttributes = this.getContentTypeAttributes();
        for (ContentTypeAttribute attribute : contentTypeAttributes) {
            result.set(attribute.getName(), this.populate(CONTENT_VERSION_PROPERTYSET_PREFIX + attribute.getName()));
        }
        this.setParameter(CONTENT_VERSION_VALUES_PARAMETER, result);
    }

    private String populate(String name) throws WorkflowException {
        if (this.parameterExists(name)) {
            if (this.languageVO == null) {
                this.setPropertySetDataString(name, this.getRequestParameter(name));
            } else {
                this.setPropertySetDataString(name, this.getRequestParameter(name));
                this.setPropertySetDataString(String.valueOf(this.languageVO.getLanguageCode()) + "_" + name, this.getRequestParameter(name));
            }
            logger.debug((Object)(String.valueOf(name) + " is found in the request; propertyset updated."));
        } else {
            logger.debug((Object)(String.valueOf(name) + " is not found in the request; propertyset not updated."));
        }
        if (this.languageVO == null) {
            return this.propertySetContains(name) ? this.getPropertySetDataString(name) : "";
        }
        return this.propertySetContains(String.valueOf(this.languageVO.getLanguageCode()) + "_" + name) ? this.getPropertySetDataString(String.valueOf(this.languageVO.getLanguageCode()) + "_" + name) : "";
    }

    private List getContentTypeAttributes() {
        return ContentTypeDefinitionController.getController().getContentTypeAttributes(this.contentTypeDefinitionVO.getSchemaValue());
    }
}

