/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import java.util.Calendar;
import org.infoglue.cms.applications.workflowtool.function.ContentFunction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.entities.content.ContentVO;

public class ContentMover
extends ContentFunction {
    public static final String DESTINATION_PARAMETER = "move_newParentFolder";
    public static final String DESTINATION_PATH_ALGORITHM = "pathAlgorithm";
    private ContentVO destinationContentVO;

    protected void execute() throws WorkflowException {
        if (this.getContentVO() != null) {
            try {
                if (!this.getContentVO().getParentContentId().equals(this.destinationContentVO.getContentId())) {
                    ContentController.getContentController().moveContent(this.getContentVO(), this.destinationContentVO.getId(), this.getDatabase());
                }
            }
            catch (Exception e) {
                this.throwException(e);
            }
        }
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.destinationContentVO = (ContentVO)this.getParameter(DESTINATION_PARAMETER, this.getContentVO() != null);
        if (this.argumentExists(DESTINATION_PATH_ALGORITHM) && this.getArgument(DESTINATION_PATH_ALGORITHM).equalsIgnoreCase("YEAR_MONTH")) {
            try {
                ContentVO newParentContentVO;
                String contentPath = "";
                Calendar aCal = Calendar.getInstance();
                int aYear = aCal.get(1);
                int aMonth = aCal.get(2) + 1;
                contentPath = ContentController.getContentController().getContentPath(this.destinationContentVO.getContentId());
                contentPath = String.valueOf(contentPath) + "/" + aYear + "/" + aMonth;
                this.destinationContentVO = newParentContentVO = ContentController.getContentController().getContentVOWithPath(this.destinationContentVO.getRepositoryId(), contentPath, true, this.getPrincipal(), this.getDatabase());
            }
            catch (Exception e) {
                this.throwException(e);
            }
        }
    }
}

