/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import org.infoglue.cms.applications.workflowtool.function.InfoglueFunction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;

public abstract class ContentFunction
extends InfoglueFunction {
    public static final String CONTENT_PARAMETER = "content";
    public static final String CONTENT_VERSION_PARAMETER = "contentVersion";
    private static final String CONTENT_PARAMETER_NAME_ARGUMENT = "contentParameterName";
    private static final String CONTENT_VERSION_PARAMETER_NAME_ARGUMENT = "contentVersionParameterName";
    private Content content;
    private ContentVO contentVO;
    private ContentVersion contentVersion;
    private ContentVersionVO contentVersionVO;

    protected ContentFunction() {
    }

    protected ContentVO getContentVO() {
        return this.contentVO;
    }

    protected ContentVersionVO getContentVersionVO() {
        return this.contentVersionVO;
    }

    protected Content getContent() {
        if (this.contentVO != null && this.content == null) {
            try {
                this.content = ContentController.getContentController().getContentWithId(this.contentVO.getContentId(), this.getDatabase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.content;
    }

    protected ContentVersion getContentVersion() {
        if (this.contentVersionVO != null && this.contentVersion == null) {
            try {
                this.contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(this.contentVersionVO.getContentVersionId(), this.getDatabase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.contentVersion;
    }

    protected String getAttribute(String name, boolean escapeHTML) throws WorkflowException {
        if (this.contentVersionVO == null) {
            this.throwException("No content version.");
        }
        String value = "";
        try {
            value = ContentVersionController.getContentVersionController().getAttributeValue(this.contentVersionVO, name, escapeHTML);
        }
        catch (Exception e) {
            this.throwException(e);
        }
        return value;
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.contentVO = (ContentVO)this.getParameter(this.getArgument(CONTENT_PARAMETER_NAME_ARGUMENT, CONTENT_PARAMETER), false);
        this.contentVersionVO = (ContentVersionVO)this.getParameter(this.getArgument(CONTENT_VERSION_PARAMETER_NAME_ARGUMENT, CONTENT_VERSION_PARAMETER), false);
    }
}

