/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.workflowtool.function.ContentFunction;
import org.infoglue.cms.applications.workflowtool.util.ContentFactory;
import org.infoglue.cms.applications.workflowtool.util.ContentValues;
import org.infoglue.cms.applications.workflowtool.util.ContentVersionValues;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.exception.ConstraintException;

public class ContentCreator
extends ContentFunction {
    private static final Logger logger = Logger.getLogger((String)ContentCreator.class.getName());
    public static final String FOLDER_PARAMETER = "create_folder";
    private static final String STATUS_OK = "status.content.ok";
    private static final String STATUS_NOK = "status.content.nok";
    private LanguageVO languageVO;
    private ContentTypeDefinitionVO contentTypeDefinitionVO;
    private Map categories;
    private ContentValues contentValues;
    private ContentVersionValues contentVersionValues;
    private ContentVO parentContentVO;

    protected void execute() throws WorkflowException {
        this.setFunctionStatus(STATUS_NOK);
        try {
            ContentFactory factory = new ContentFactory(this.contentTypeDefinitionVO, this.contentValues, this.contentVersionValues, this.getPrincipal(), this.languageVO);
            ContentVO newContentVO = null;
            if (this.getContentVO() == null) {
                this.parentContentVO = (ContentVO)this.getParameter(FOLDER_PARAMETER);
                newContentVO = factory.create(this.parentContentVO, this.categories, this.getDatabase());
            } else {
                newContentVO = factory.update(this.getContentVO(), this.categories, this.getDatabase());
            }
            if (newContentVO != null) {
                this.setPropertySetString("content_contentID", newContentVO.getContentId().toString());
            }
            this.setFunctionStatus(newContentVO != null ? STATUS_OK : STATUS_NOK);
        }
        catch (ConstraintException e) {
            logger.debug((Object)e.toString());
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.contentTypeDefinitionVO = (ContentTypeDefinitionVO)this.getParameter("contentTypeDefinition");
        this.languageVO = (LanguageVO)this.getParameter("language");
        this.categories = (Map)this.getParameter("categories", new HashMap());
        this.contentValues = (ContentValues)this.getParameter("contentValues");
        this.contentVersionValues = (ContentVersionValues)this.getParameter("contentVersionValues");
    }
}

