/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.infoglue.cms.applications.workflowtool.function.ErrorPopulator;
import org.infoglue.cms.applications.workflowtool.util.RangeCheck;

public class CategoryErrorPopulator
extends ErrorPopulator {
    private static final String NAME_ARGUMENT = "name";
    private static final String CATEGORY_ERROR_PROPERTYSET_PREFIX = "error_category_";
    private static final String NON_DEFAULT_NAME_ARGUMENT = "nonDefaultName";
    private static final String MIN_ARGUMENT = "min";
    private static final String MAX_ARGUMENT = "max";
    private static final String EXACTLY_MESSAGE_KEY = "3601";
    private static final String EXACTLY_ONE_MESSAGE_KEY = "3602";
    private static final String LESS_THAN_MESSAGE_KEY = "3603";
    private static final String GREATER_THAN_MESSAGE_KEY = "3604";
    private static final String GREATER_THAN_ONE_MESSAGE_KEY = "3605";
    private static final String BETWEEN_MESSAGE_KEY = "3606";
    private static final String BETWEEN_ONE_AND_MANY_MESSAGE_KEY = "3607";
    private Map categories;
    private String attributeName;
    private RangeCheck range;

    protected void clean() throws WorkflowException {
        this.clean(this.getErrorKey());
    }

    protected void populate() throws WorkflowException {
        int count = this.getCategoryCount();
        int result = this.range.check(count);
        if (result != 0) {
            this.setPropertySetString(this.getErrorKey(), this.getErrorKey(result));
        }
    }

    private String getErrorKey(int result) throws WorkflowException {
        switch (result) {
            case 1: {
                return this.getStringManager().getString(EXACTLY_MESSAGE_KEY, this.range.getMin());
            }
            case 2: {
                return this.getStringManager().getString(EXACTLY_ONE_MESSAGE_KEY, this.range.getMin());
            }
            case 3: {
                return this.getStringManager().getString(LESS_THAN_MESSAGE_KEY, this.range.getMax());
            }
            case 4: {
                return this.getStringManager().getString(GREATER_THAN_MESSAGE_KEY, this.range.getMin());
            }
            case 5: {
                return this.getStringManager().getString(GREATER_THAN_ONE_MESSAGE_KEY, this.range.getMin());
            }
            case 6: {
                return this.getStringManager().getString(BETWEEN_MESSAGE_KEY, this.range.getMin(), this.range.getMax());
            }
            case 7: {
                return this.getStringManager().getString(BETWEEN_ONE_AND_MANY_MESSAGE_KEY, this.range.getMin(), this.range.getMax());
            }
        }
        this.throwException("Illegal result value [" + result + "]");
        return null;
    }

    private int getCategoryCount() {
        Collection category = (Collection)this.categories.get(this.attributeName);
        return category == null ? 0 : category.size();
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.categories = (Map)this.getParameter("categories", new HashMap());
        this.attributeName = this.getArgument(NAME_ARGUMENT);
        Integer min = this.getIntegerArgument(MIN_ARGUMENT);
        Integer max = this.getIntegerArgument(MAX_ARGUMENT);
        this.checkArguments(min, max);
        this.range = new RangeCheck(min, max);
    }

    private String getErrorKey() throws WorkflowException {
        return CATEGORY_ERROR_PROPERTYSET_PREFIX + (this.argumentExists(NON_DEFAULT_NAME_ARGUMENT) ? this.getArgument(NON_DEFAULT_NAME_ARGUMENT) : this.attributeName);
    }

    private Integer getIntegerArgument(String key) throws WorkflowException {
        if (this.argumentExists(key)) {
            try {
                return new Integer(this.getArgument(key));
            }
            catch (Exception e) {
                this.throwException(e);
            }
        }
        return null;
    }

    private void checkArguments(Integer min, Integer max) throws WorkflowException {
        if (min != null && min < 0) {
            this.throwException("min must be a natural.");
        }
        if (max != null && max < 0) {
            this.throwException("max must be a natural.");
        }
        if (min != null && max != null && min > max) {
            this.throwException("max must be greater than min.");
        }
    }
}

