/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.workflowtool.function;

import com.opensymphony.workflow.WorkflowException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.workflowtool.function.ContentFunction;
import org.infoglue.cms.applications.workflowtool.function.email.Attachment;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.util.CmsPropertyHandler;

public class Attach
extends ContentFunction {
    private static final Logger logger = Logger.getLogger((String)Attach.class.getName());
    private static final String ATTACHMENTS_PARAMETER = "attachments";
    private Collection attachments;

    protected void execute() throws WorkflowException {
        if (this.getContentVersion() != null) {
            try {
                for (Attachment attachment : this.attachments) {
                    logger.debug((Object)("Adding attachment : " + attachment));
                    DigitalAssetController.create(this.createDigitalAssetVO(attachment), this.getInputStream(attachment), this.getContentVersion(), this.getDatabase());
                }
            }
            catch (Exception e) {
                this.throwException(e);
            }
        }
    }

    private DigitalAssetVO createDigitalAssetVO(Attachment attachment) {
        DigitalAssetVO digitalAssetVO = new DigitalAssetVO();
        digitalAssetVO.setAssetContentType(attachment.getContentType());
        digitalAssetVO.setAssetKey(attachment.getName());
        digitalAssetVO.setAssetFileName(attachment.getName());
        digitalAssetVO.setAssetFilePath(this.getDigitalAssetsDirectory());
        digitalAssetVO.setAssetFileSize(new Integer(attachment.getSize()));
        return digitalAssetVO;
    }

    private InputStream getInputStream(Attachment attachment) {
        return new ByteArrayInputStream(attachment.getBytes());
    }

    private String getDigitalAssetsDirectory() {
        return CmsPropertyHandler.getDigitalAssetPath();
    }

    protected void initialize() throws WorkflowException {
        super.initialize();
        this.attachments = (Collection)this.getParameter(ATTACHMENTS_PARAMETER, new ArrayList());
    }
}

