/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.wizards.actions;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.structuretool.wizards.actions.CreateSiteNodeWizardAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.PageTemplateController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeTypeDefinitionController;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.sorters.ReflectionComparator;

public class CreateSiteNodeWizardInputSiteNodeAction
extends CreateSiteNodeWizardAbstractAction {
    private static final Logger logger = Logger.getLogger((String)CreateSiteNodeWizardInputSiteNodeAction.class.getName());
    private static final long serialVersionUID = 1L;
    private String returnAddress;
    private SiteNodeVO siteNodeVO = new SiteNodeVO();
    private Integer siteNodeTypeDefinitionId = null;
    private ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();

    public String doInput() throws Exception {
        return "input";
    }

    public String doExecute() throws Exception {
        this.siteNodeVO.setCreatorName(this.getInfoGluePrincipal().getName());
        this.ceb = this.siteNodeVO.validate();
        this.ceb.throwIfNotEmpty();
        this.getCreateSiteNodeWizardInfoBean().setSiteNodeVO(this.siteNodeVO);
        return "success";
    }

    public List getSortedPageTemplates(String sortProperty) throws Exception {
        SiteNodeVO parentSiteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.getCreateSiteNodeWizardInfoBean().getParentSiteNodeId());
        LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(parentSiteNodeVO.getRepositoryId());
        List components = PageTemplateController.getController().getPageTemplates(this.getInfoGluePrincipal(), masterLanguageVO.getId());
        Collections.sort(components, new ReflectionComparator(sortProperty));
        return components;
    }

    public String getDigitalAssetUrl(Integer contentId, String key) throws Exception {
        String imageHref = null;
        try {
            LanguageVO masterLanguage = LanguageController.getController().getMasterLanguage(ContentController.getContentController().getContentVOWithId(contentId).getRepositoryId());
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, masterLanguage.getId());
            List digitalAssets = DigitalAssetController.getDigitalAssetVOList(contentVersionVO.getId());
            for (DigitalAssetVO digitalAssetVO : digitalAssets) {
                if (!digitalAssetVO.getAssetKey().equals(key)) continue;
                imageHref = DigitalAssetController.getDigitalAssetUrl(digitalAssetVO.getId());
                break;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the digitalAsset: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public List getSiteNodeTypeDefinitions() throws Exception {
        return SiteNodeTypeDefinitionController.getController().getSortedSiteNodeTypeDefinitionVOList();
    }

    public String getName() {
        return this.siteNodeVO.getName();
    }

    public void setName(String name) {
        this.siteNodeVO.setName(name);
    }

    public String getPublishDateTime() {
        return new VisualFormatter().formatDate(this.siteNodeVO.getPublishDateTime(), "yyyy-MM-dd HH:mm");
    }

    public void setPublishDateTime(String publishDateTime) {
        this.siteNodeVO.setPublishDateTime(new VisualFormatter().parseDate(publishDateTime, "yyyy-MM-dd HH:mm"));
    }

    public String getExpireDateTime() {
        return new VisualFormatter().formatDate(this.siteNodeVO.getExpireDateTime(), "yyyy-MM-dd HH:mm");
    }

    public void setExpireDateTime(String expireDateTime) {
        this.siteNodeVO.setExpireDateTime(new VisualFormatter().parseDate(expireDateTime, "yyyy-MM-dd HH:mm"));
    }

    public long getPublishDateTimeAsLong() {
        return this.siteNodeVO.getPublishDateTime().getTime();
    }

    public long getExpireDateTimeAsLong() {
        return this.siteNodeVO.getExpireDateTime().getTime();
    }

    public Integer getSiteNodeTypeDefinitionId() {
        return this.siteNodeTypeDefinitionId;
    }

    public void setSiteNodeTypeDefinitionId(Integer siteNodeTypeDefinitionId) {
        this.siteNodeTypeDefinitionId = siteNodeTypeDefinitionId;
    }

    public void setPageTemplateContentId(Integer pageTemplateContentId) {
        this.getCreateSiteNodeWizardInfoBean().setPageTemplateContentId(pageTemplateContentId);
    }

    public Integer getPageTemplateContentId() {
        return this.getCreateSiteNodeWizardInfoBean().getPageTemplateContentId();
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(String string) {
        this.returnAddress = string;
    }
}

