/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.actions;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.ImageButton;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.util.CmsPropertyHandler;

public class ViewStructureToolToolBarAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewStructureToolToolBarAction.class.getName());
    private static final long serialVersionUID = 1L;
    private String title = "";
    private String name = "";
    private String toolbarKey = "";
    private String url = "";
    private Boolean isBranch = new Boolean(false);
    private Integer repositoryId = null;
    private Integer siteNodeId = null;
    private Integer siteNodeVersionId = null;
    private Integer lastPublishedSiteNodeVersionId = null;
    private Integer metaInfoAvailableServiceBindingId = null;
    private SiteNodeVersionVO siteNodeVersionVO = null;
    private SiteNodeVO siteNodeVO = null;
    private VisualFormatter formatter = new VisualFormatter();

    public String doExecute() throws Exception {
        try {
            if (this.siteNodeVersionId != null) {
                this.siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(this.siteNodeVersionId);
                this.siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.siteNodeVersionVO.getSiteNodeId());
            } else if (this.siteNodeId != null) {
                this.siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.siteNodeId);
                this.siteNodeVersionVO = SiteNodeVersionController.getController().getLatestActiveSiteNodeVersionVO(this.siteNodeId);
                if (this.siteNodeVersionVO != null) {
                    this.siteNodeVersionId = this.siteNodeVersionVO.getSiteNodeVersionId();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "success";
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public Integer getSiteNodeVersionId() {
        return this.siteNodeVersionId;
    }

    public void setSiteNodeVersionId(Integer siteNodeVersionId) {
        this.siteNodeVersionId = siteNodeVersionId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getIsBranch() {
        return this.isBranch;
    }

    public void setIsBranch(Boolean isBranch) {
        this.isBranch = isBranch;
    }

    public String getToolbarKey() {
        return this.toolbarKey;
    }

    public void setToolbarKey(String toolbarKey) {
        this.toolbarKey = toolbarKey;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    private boolean isReadOnly() {
        boolean isReadOnly = false;
        try {
            if (this.siteNodeVersionVO != null && (this.siteNodeVersionVO.getStateId() == 1 || this.siteNodeVersionVO.getStateId() == 2 || this.siteNodeVersionVO.getStateId() == 3)) {
                isReadOnly = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isReadOnly;
    }

    public List getButtons() {
        logger.info((Object)("Title:" + this.title));
        logger.info((Object)("toolbarKey:" + this.toolbarKey));
        try {
            if (this.toolbarKey.equalsIgnoreCase("tool.structuretool.siteNodeDetailsHeader") || this.toolbarKey.equalsIgnoreCase("tool.structuretool.siteNodeComponentsHeader")) {
                if (this.isBranch.booleanValue()) {
                    return this.getBranchSiteNodeButtons();
                }
                return this.getSiteNodeButtons();
            }
            if (this.toolbarKey.equalsIgnoreCase("tool.structuretool.siteNodeVersionHeader")) {
                return this.getSiteNodeVersionButtons();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)("Exception when generating buttons:" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private boolean hasPublishedVersion() {
        boolean hasPublishedVersion = false;
        try {
            SiteNodeVersionVO siteNodeVersion = SiteNodeVersionController.getLatestPublishedSiteNodeVersionVO(this.siteNodeId);
            if (siteNodeVersion != null) {
                SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(siteNodeVersion.getSiteNodeId());
                hasPublishedVersion = true;
                this.lastPublishedSiteNodeVersionId = siteNodeVersion.getId();
                this.repositoryId = siteNodeVO.getRepositoryId();
                this.name = siteNodeVO.getName();
                this.siteNodeId = siteNodeVO.getId();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Exception when generating buttons:" + e.getMessage()), (Throwable)e);
        }
        return hasPublishedVersion;
    }

    private List getBranchSiteNodeButtons() throws Exception {
        ArrayList<ImageButton> buttons = new ArrayList<ImageButton>();
        buttons.add(new ImageButton(String.valueOf(this.getCMSBaseUrl()) + "/CreateSiteNode!input.action?isBranch=true&parentSiteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId, this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.newSiteNode"), "New SiteNode"));
        ImageButton moveButton = this.getMoveButton();
        moveButton.getSubButtons().add(this.getMoveMultipleButton());
        buttons.add(moveButton);
        if (!this.hasPublishedVersion()) {
            buttons.add(new ImageButton(String.valueOf(this.getCMSBaseUrl()) + "/Confirm.action?header=tool.structuretool.deleteSiteNode.header&yesDestination=" + URLEncoder.encode(URLEncoder.encode("DeleteSiteNode.action?siteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId + "&changeTypeId=4", "UTF-8"), "UTF-8") + "&noDestination=" + URLEncoder.encode(URLEncoder.encode("ViewSiteNode.action?title=SiteNode&siteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId, "UTF-8"), "UTF-8") + "&message=tool.structuretool.deleteSiteNode.message", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.deleteSiteNode"), "Delete SiteNode"));
        }
        if (this.siteNodeVersionVO != null && this.siteNodeVersionVO.getStateId().equals(SiteNodeVersionVO.WORKING_STATE)) {
            buttons.add(new ImageButton(true, "javascript:openPopup('ViewAndCreateContentForServiceBinding.action?siteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId + "&siteNodeVersionId=" + this.siteNodeVersionVO.getId() + "', 'PageProperties', 'width=750,height=700,resizable=no,status=yes,scrollbars=yes');", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.editSiteNodeProperties"), "Edit siteNode properties"));
        } else if (this.siteNodeVersionVO != null) {
            buttons.add(new ImageButton(true, "javascript:openPopupWithOptionalParameter('ViewAndCreateContentForServiceBinding.action?siteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId + "&siteNodeVersionId=" + this.siteNodeVersionVO.getId() + "', 'PageProperties', 'width=750,height=700,resizable=no,status=yes,scrollbars=yes', '" + this.getLocalizedString(this.getSession().getLocale(), "tool.structuretool.changeSiteNodeStateToWorkingQuestion") + "', 'changeStateToWorking=true');", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.editSiteNodeProperties"), "Edit siteNode properties"));
        }
        buttons.add(this.getPreviewButtons());
        if (this.hasPublishedVersion()) {
            ImageButton unpublishButton = new ImageButton(String.valueOf(this.getCMSBaseUrl()) + "/UnpublishSiteNodeVersion!input.action?siteNodeId=" + this.siteNodeId + "&siteNodeVersionId=" + this.siteNodeVersionId, this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.unpublishVersion"), "tool.contenttool.unpublishVersion.header");
            ImageButton unpublishAllButton = new ImageButton(String.valueOf(this.getCMSBaseUrl()) + "/UnpublishSiteNodeVersion!inputChooseSiteNodes.action?siteNodeId=" + this.siteNodeId + "&siteNodeVersionId=" + this.siteNodeVersionId, this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.unpublishAllVersion"), "tool.contenttool.unpublishAllVersion.header");
            unpublishButton.getSubButtons().add(unpublishAllButton);
            buttons.add(unpublishButton);
        }
        ImageButton coverButton = new ImageButton(String.valueOf(this.getCMSBaseUrl()) + "/ViewSiteNode.action?siteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId + "&stay=true", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.siteNodeCover"), "SiteNode Cover");
        coverButton.getSubButtons().add(this.getSimplePageComponentsButton());
        buttons.add(coverButton);
        if (!this.isReadOnly()) {
            ImageButton pageComponentsButton = this.getViewPageComponentsButton();
            pageComponentsButton.getSubButtons().add(this.getSimplePageComponentsButton());
            buttons.add(pageComponentsButton);
        }
        ImageButton publishButton = this.getPublishCurrentNodeButton();
        publishButton.getSubButtons().add(this.getPublishButton());
        buttons.add(publishButton);
        buttons.add(this.getExecuteTaskButton());
        if (this.siteNodeVersionVO != null && this.siteNodeVersionVO.getIsProtected().intValue() == SiteNodeVersionVO.YES.intValue()) {
            buttons.add(this.getAccessRightsButton());
        }
        return buttons;
    }

    private ImageButton getPreviewButtons() throws Exception {
        int startIndex;
        RepositoryVO repositoryVO = RepositoryController.getController().getRepositoryVOWithId(this.repositoryId);
        String dnsName = repositoryVO.getDnsName();
        String workingUrl = null;
        String keyword = "working=";
        int n = startIndex = dnsName == null ? -1 : dnsName.indexOf(keyword);
        if (startIndex != -1) {
            int endIndex = dnsName.indexOf(",", startIndex);
            dnsName = endIndex > -1 ? dnsName.substring(startIndex, endIndex) : dnsName.substring(startIndex);
            workingUrl = String.valueOf(dnsName.split("=")[1]) + CmsPropertyHandler.getComponentRendererUrl() + "ViewPage.action";
        } else {
            workingUrl = CmsPropertyHandler.getPreviewDeliveryUrl();
        }
        ImageButton imageButton = new ImageButton(true, "javascript:openPopup('" + workingUrl + "?siteNodeId=" + this.siteNodeId + "' , 'SiteNode', 'width=800,height=600,resizable=yes,toolbar=yes,scrollbars=yes,status=yes,location=yes,menubar=yes');", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.previewSiteNode"), "Preview siteNode");
        return imageButton;
    }

    private List getSiteNodeButtons() throws Exception {
        ArrayList<ImageButton> buttons = new ArrayList<ImageButton>();
        buttons.add(new ImageButton("Confirm.action?header=Delete%20siteNode&yesDestination=" + URLEncoder.encode(URLEncoder.encode("DeleteSiteNode.action?siteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId + "&changeTypeId=4", "UTF-8"), "UTF-8") + "&noDestination=" + URLEncoder.encode(URLEncoder.encode("ViewSiteNode.action?title=SiteNode&siteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId, "UTF-8"), "UTF-8") + "&message=" + URLEncoder.encode("Do you really want to delete the siteNode " + this.name + " and all its children", "UTF-8"), this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.deleteSiteNode"), "Delete SiteNode"));
        buttons.add(this.getMoveButton());
        buttons.add(this.getMoveMultipleButton());
        buttons.add(this.getPublishButton());
        return buttons;
    }

    private List getSiteNodeVersionButtons() throws Exception {
        ArrayList<ImageButton> buttons = new ArrayList<ImageButton>();
        if (this.siteNodeVersionId != null) {
            buttons.add(new ImageButton(true, "javascript:openPopup('ViewSiteNodeVersion!preview.action?siteNodeVersionId=" + this.siteNodeVersionId + "&siteNodeId=" + this.siteNodeId + "', 'SiteNodePreview', 'width=600,height=600,resizable=yes');", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.previewSiteNode"), "Preview siteNode version"));
        }
        return buttons;
    }

    private ImageButton getMoveButton() throws Exception {
        return new ImageButton(true, "javascript:openPopup('ViewSiteNodeTree.action?siteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId + "&hideLeafs=true', 'SiteNode', 'width=400,height=600,resizable=no');", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.moveSiteNode"), "Move siteNode");
    }

    private ImageButton getMoveMultipleButton() {
        return new ImageButton(true, "javascript:openPopup('MoveMultipleSiteNodes!input.action?siteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId + "', 'MoveMultipleSiteNodes', 'width=400,height=600,resizable=no');", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.moveMultipleSiteNodes"), "tool.structuretool.moveMultipleSiteNodes.header");
    }

    private ImageButton getViewPageComponentsButton() throws Exception {
        try {
            ContentVersionVO contentVersionVO;
            boolean isMetaInfoInWorkingState = false;
            LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(this.repositoryId);
            Integer languageId = masterLanguageVO.getLanguageId();
            SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.siteNodeId);
            if (siteNodeVO.getMetaInfoContentId() != null && siteNodeVO.getMetaInfoContentId() != -1 && (contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(siteNodeVO.getMetaInfoContentId(), languageId)).getStateId().equals(ContentVersionVO.WORKING_STATE)) {
                isMetaInfoInWorkingState = true;
            }
            logger.info((Object)("isMetaInfoInWorkingState:" + isMetaInfoInWorkingState));
            if (isMetaInfoInWorkingState) {
                return new ImageButton(String.valueOf(CmsPropertyHandler.getComponentRendererUrl()) + "ViewPage!renderDecoratedPage.action?siteNodeId=" + this.siteNodeId + "&languageId=" + masterLanguageVO.getId() + "&contentId=-1" + "&cmsUserName=" + this.formatter.encodeURI(this.getInfoGluePrincipal().getName()), this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.siteNodeComponents"), "Site Node Components");
            }
            return new ImageButton(true, "javascript:alert('Cannot edit this page. You must first set the meta info to working. Do this by entering node properties and changing the state to working.');", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.siteNodeComponents"), "Site Node Components");
        }
        catch (Exception e) {
            return new ImageButton(true, "javascript:alert('Cannot edit this page. You must first assign a metainfo content. Do this by entering node properties and fill in the information requested.');", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.siteNodeComponents"), "Site Node Components");
        }
    }

    private ImageButton getSimplePageComponentsButton() throws Exception {
        try {
            ContentVersionVO contentVersionVO;
            boolean isMetaInfoInWorkingState = false;
            LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(this.repositoryId);
            Integer languageId = masterLanguageVO.getLanguageId();
            SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.siteNodeId);
            if (siteNodeVO.getMetaInfoContentId() != null && siteNodeVO.getMetaInfoContentId() != -1 && (contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(siteNodeVO.getMetaInfoContentId(), languageId)).getStateId().equals(ContentVersionVO.WORKING_STATE)) {
                isMetaInfoInWorkingState = true;
            }
            logger.info((Object)("isMetaInfoInWorkingState:" + isMetaInfoInWorkingState));
            if (isMetaInfoInWorkingState) {
                return new ImageButton(String.valueOf(CmsPropertyHandler.getComponentRendererUrl()) + "ViewPage!renderDecoratedPage.action?siteNodeId=" + this.siteNodeId + "&languageId=" + masterLanguageVO.getId() + "&contentId=-1&showSimple=true" + "&cmsUserName=" + this.formatter.encodeURI(this.getInfoGluePrincipal().getName()), this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.siteNodeStructure"), "Site Node Structure");
            }
            return new ImageButton(true, "javascript:alert('Cannot edit this page. You must first set the meta info to working. Do this by entering node properties and changing the state to working.');", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.siteNodeStructure"), "Site Node Structure");
        }
        catch (Exception e) {
            return new ImageButton(true, "javascript:alert('Cannot edit this page. You must first assign a metainfo content. Do this by entering node properties and fill in the information requested.');", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.siteNodeStructure"), "Site Node Structure");
        }
    }

    private ImageButton getExecuteTaskButton() {
        return new ImageButton(true, "javascript:openPopup('ViewExecuteTask.action?contentId=" + this.siteNodeId + "', 'SiteNode', 'width=400,height=600,resizable=yes,scrollbars=yes');", this.getLocalizedString(this.getSession().getLocale(), "images.global.buttons.executeTask"), "tool.common.executeTask.header");
    }

    private ImageButton getPublishButton() {
        return new ImageButton(String.valueOf(this.getCMSBaseUrl()) + "/ViewListSiteNodeVersion.action?siteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId, this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.publishSiteNode"), "tool.structuretool.publishSiteNode.header");
    }

    private ImageButton getPublishCurrentNodeButton() {
        return new ImageButton(String.valueOf(this.getCMSBaseUrl()) + "/ViewListSiteNodeVersion.action?siteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId + "&recurseSiteNodes=false", this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.publishCurrentSiteNode"), "tool.structuretool.publishCurrentSiteNode.header");
    }

    private ImageButton getAccessRightsButton() throws Exception {
        String returnAddress = URLEncoder.encode(URLEncoder.encode("ViewSiteNode.action?siteNodeId=" + this.siteNodeId + "&repositoryId=" + this.repositoryId + "&stay=true", "UTF-8"), "UTF-8");
        return new ImageButton(String.valueOf(this.getCMSBaseUrl()) + "/ViewAccessRights.action?interceptionPointCategory=SiteNodeVersion&extraParameters=" + this.siteNodeVersionId + "&colorScheme=StructureTool&returnAddress=" + returnAddress, this.getLocalizedString(this.getSession().getLocale(), "images.structuretool.buttons.siteNodeAccessRights"), "Site Node Access Rights");
    }

    public String getStateDescription() {
        String state = "";
        if (this.siteNodeVersionVO != null) {
            if (this.siteNodeVersionVO.getStateId().equals(SiteNodeVersionVO.WORKING_STATE)) {
                state = "<span style=\"color:#333333; font-weight: bold;\">(" + this.getLocalizedString(this.getSession().getLocale(), "tool.contenttool.state.working") + ")</span>";
            } else if (this.siteNodeVersionVO.getStateId().equals(SiteNodeVersionVO.FINAL_STATE)) {
                state = "<span style=\"color:#AAAAAA; font-weight: bold;\">(" + this.getLocalizedString(this.getSession().getLocale(), "tool.contenttool.state.final") + ")</span>";
            } else if (this.siteNodeVersionVO.getStateId().equals(SiteNodeVersionVO.PUBLISH_STATE)) {
                state = "<span style=\"color:#888888; font-weight: bold;\">(" + this.getLocalizedString(this.getSession().getLocale(), "tool.contenttool.state.publish") + ")</span>";
            } else if (this.siteNodeVersionVO.getStateId().equals(SiteNodeVersionVO.PUBLISHED_STATE)) {
                state = "<span style=\"color:#666666; font-weight: bold;\">(" + this.getLocalizedString(this.getSession().getLocale(), "tool.contenttool.state.published") + ")</span>";
            }
        }
        return state;
    }

    public SiteNodeVersionVO getSiteNodeVersionVO() {
        return this.siteNodeVersionVO;
    }

    public SiteNodeVO getSiteNodeVO() {
        return this.siteNodeVO;
    }
}

