/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.actions;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ComponentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeStateController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionControllerProxy;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.XMLHelper;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.applications.databeans.Slot;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.PageEditorHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewSiteNodePageComponentsAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewSiteNodePageComponentsAction.class.getName());
    private static final long serialVersionUID = 1L;
    public static final String CATEGORY_TREE = "showCategoryTree";
    public static final String CATEGORY_TREE_MULTIPLE = "showCategoryTreeForMultipleBinding";
    private Integer repositoryId = null;
    private Integer siteNodeId = null;
    private Integer languageId = null;
    private Integer contentId = null;
    private String assetKey = null;
    private Integer parentComponentId = null;
    private Integer componentId = null;
    private Integer newComponentContentId = null;
    private String propertyName = null;
    private String path = null;
    private String slotId = null;
    private String specifyBaseTemplate = null;
    private String url = null;
    private Integer direction = null;
    private boolean showSimple = false;
    private Integer pageTemplateContentId;
    private String showDecorated = "true";
    private String slotPositionComponentId = null;
    private Integer pagePartContentId = null;
    LanguageVO masterLanguageVO = null;
    private List repositories = null;
    private String currentAction = null;
    private Integer filterRepositoryId = null;
    private String sortProperty = "name";
    private String[] allowedContentTypeIds = null;
    private String[] allowedComponentNames = null;
    private String[] disallowedComponentNames = null;

    private void initialize() throws Exception {
        SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getACLatestActiveSiteNodeVersionVO(this.getInfoGluePrincipal(), this.siteNodeId);
        logger.info((Object)("siteNodeVersionVO:" + siteNodeVersionVO.getId() + ":" + siteNodeVersionVO.getIsActive()));
        if (siteNodeVersionVO.getStateId().intValue() != SiteNodeVersionVO.WORKING_STATE.intValue()) {
            ArrayList events = new ArrayList();
            SiteNodeStateController.getController().changeState(siteNodeVersionVO.getId(), SiteNodeVersionVO.WORKING_STATE, "Edit on sight editing", true, this.getInfoGluePrincipal(), this.siteNodeId, events);
        }
        Integer currentRepositoryId = SiteNodeController.getController().getSiteNodeVOWithId(this.siteNodeId).getRepositoryId();
        this.masterLanguageVO = LanguageController.getController().getMasterLanguage(currentRepositoryId);
        SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.siteNodeId);
        if (this.filterRepositoryId == null) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("globalKey", "infoglue");
            PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
            String defaultTemplateRepository = ps.getString("repository_" + currentRepositoryId + "_defaultTemplateRepository");
            this.filterRepositoryId = defaultTemplateRepository != null && !defaultTemplateRepository.equals("") ? new Integer(defaultTemplateRepository) : currentRepositoryId;
        }
    }

    private void initializeTreeView(String currentAction) throws Exception {
        this.currentAction = currentAction;
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), true);
        if (this.repositoryId == null) {
            this.repositoryId = RepositoryController.getController().getFirstRepositoryVO().getRepositoryId();
        }
    }

    public String doExecute() throws Exception {
        this.initialize();
        return "success";
    }

    public String doListComponents() throws Exception {
        logger.info((Object)("queryString:" + this.getRequest().getQueryString()));
        this.initialize();
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), true);
        return "listComponents";
    }

    public String doListComponentsForChange() throws Exception {
        logger.info((Object)("queryString:" + this.getRequest().getQueryString()));
        this.initialize();
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), true);
        return "listComponentsForChange";
    }

    public String doListComponentsForPalette() throws Exception {
        this.initialize();
        return "listComponentsForPalette";
    }

    public String doShowContentTree() throws Exception {
        this.initialize();
        this.initializeTreeView("ViewSiteNodePageComponents!showContentTree.action");
        return "showContentTree";
    }

    public String doShowContentTreeForMultipleBinding() throws Exception {
        this.initialize();
        this.initializeTreeView("ViewSiteNodePageComponents!showContentTreeForMultipleBinding.action");
        return "showContentTreeForMultipleBinding";
    }

    public String doShowContentTreeForMultipleAssetBinding() throws Exception {
        this.initialize();
        this.initializeTreeView("ViewSiteNodePageComponents!showContentTreeForMultipleAssetBinding.action");
        return "showContentTreeForMultipleAssetBinding";
    }

    public String doShowStructureTree() throws Exception {
        this.initialize();
        this.initializeTreeView("ViewSiteNodePageComponents!showStructureTree.action");
        return "showStructureTree";
    }

    public String doShowStructureTreeForMultipleBinding() throws Exception {
        this.initialize();
        this.initializeTreeView("ViewSiteNodePageComponents!showStructureTreeForMultipleBinding.action");
        return "showStructureTreeForMultipleBinding";
    }

    public String doShowCategoryTree() throws Exception {
        this.initialize();
        this.initializeTreeView("ViewSiteNodePageComponents!showCategoryTree.action");
        return CATEGORY_TREE;
    }

    public String doShowCategoryTreeForMultipleBinding() throws Exception {
        this.initialize();
        this.initializeTreeView("ViewSiteNodePageComponents!showCategoryTreeForMultipleBinding.action");
        return CATEGORY_TREE_MULTIPLE;
    }

    public List getRepositories() {
        return this.repositories;
    }

    public String getCurrentAction() {
        return this.currentAction;
    }

    public String getContentAttribute(Integer contentId, String attributeName) throws Exception {
        String attribute = "Undefined";
        ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId);
        LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(SiteNodeController.getController().getSiteNodeVOWithId(this.siteNodeId).getRepositoryId());
        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), masterLanguageVO.getId());
        attribute = ContentVersionController.getContentVersionController().getAttributeValue(contentVersionVO, attributeName, false);
        return attribute;
    }

    public String doAddPageTemplate() throws Exception {
        logger.info((Object)"************************************************************");
        logger.info((Object)"* ADDING PAGE TEMPLATE                                     *");
        logger.info((Object)"************************************************************");
        logger.info((Object)("siteNodeId:" + this.siteNodeId));
        logger.info((Object)("languageId:" + this.languageId));
        logger.info((Object)("contentId:" + this.contentId));
        logger.info((Object)("pageTemplateContentId:" + this.pageTemplateContentId));
        logger.info((Object)("specifyBaseTemplate:" + this.specifyBaseTemplate));
        this.initialize();
        Integer newComponentId = new Integer(0);
        NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.languageId, this.contentId);
        if (this.pageTemplateContentId != null) {
            Integer languageId = LanguageController.getController().getMasterLanguage(this.repositoryId).getId();
            ContentVersionVO pageTemplateContentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(this.pageTemplateContentId, languageId);
            String componentXML = ContentVersionController.getContentVersionController().getAttributeValue(pageTemplateContentVersionVO.getId(), "ComponentStructure", false);
            Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
            String componentXPath = "//component";
            logger.info((Object)("componentXPath:" + componentXPath));
            NodeList componentNodes = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
            logger.info((Object)("Found componentNodes:" + componentNodes.getLength()));
            int i = 0;
            while (i < componentNodes.getLength()) {
                Element element = (Element)componentNodes.item(i);
                String componentId = element.getAttribute("id");
                String componentContentId = element.getAttribute("contentId");
                logger.info((Object)("componentId:" + componentId));
                logger.info((Object)("componentContentId:" + componentContentId));
                ComponentController.getController().checkAndAutoCreateContents(this.siteNodeId, languageId, this.masterLanguageVO.getId(), this.assetKey, new Integer(componentId), document, new Integer(componentContentId), this.getInfoGluePrincipal());
                componentXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
                ++i;
            }
            ContentVO pageMetaInfoContentVO = nodeDeliveryController.getBoundContent(this.getInfoGluePrincipal(), this.siteNodeId, languageId, true, "Meta information", DeliveryContext.getDeliveryContext());
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(pageMetaInfoContentVO.getId(), languageId);
            if (contentVersionVO == null) {
                SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.siteNodeId);
                String versionValue = "<?xml version='1.0' encoding='UTF-8'?><article xmlns=\"x-schema:ArticleSchema.xml\"><attributes><Title><![CDATA[" + siteNodeVO.getName() + "]]></Title><NavigationTitle><![CDATA[" + siteNodeVO.getName() + "]]></NavigationTitle><NiceURIName><![CDATA[" + new VisualFormatter().replaceNiceURINonAsciiWithSpecifiedChars(siteNodeVO.getName(), '_') + "]]></NiceURIName><Description><![CDATA[" + siteNodeVO.getName() + "]]></Description><MetaInfo><![CDATA[" + siteNodeVO.getName() + "]]></MetaInfo><ComponentStructure><![CDATA[]]></ComponentStructure></attributes></article>";
                contentVersionVO = new ContentVersionVO();
                contentVersionVO.setVersionComment("Autogenerated version");
                contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
                contentVersionVO.setVersionValue(versionValue);
                contentVersionVO = ContentVersionController.getContentVersionController().create(pageMetaInfoContentVO.getId(), languageId, contentVersionVO, null);
            }
            ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", componentXML, new InfoGluePrincipal("ComponentEditor", "none", "none", "none", new ArrayList(), new ArrayList(), true, null));
        }
        this.url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&activatedComponentId=" + newComponentId + "&showSimple=" + this.showSimple;
        this.url = this.getResponse().encodeURL(this.url);
        this.getResponse().sendRedirect(this.url);
        return "none";
    }

    public String doAddComponent() throws Exception {
        logger.info((Object)"************************************************************");
        logger.info((Object)"* ADDING COMPONENT                                         *");
        logger.info((Object)"************************************************************");
        logger.info((Object)("siteNodeId:" + this.siteNodeId));
        logger.info((Object)("languageId:" + this.languageId));
        logger.info((Object)("contentId:" + this.contentId));
        logger.info((Object)("queryString:" + this.getRequest().getQueryString()));
        logger.info((Object)("parentComponentId:" + this.parentComponentId));
        logger.info((Object)("componentId:" + this.componentId));
        logger.info((Object)("slotId:" + this.slotId));
        logger.info((Object)("specifyBaseTemplate:" + this.specifyBaseTemplate));
        this.initialize();
        logger.info((Object)("masterLanguageId:" + this.masterLanguageVO.getId()));
        Integer newComponentId = new Integer(0);
        NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.languageId, this.contentId);
        if (this.specifyBaseTemplate.equalsIgnoreCase("true")) {
            String componentXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><components><component contentId=\"" + this.componentId + "\" id=\"" + newComponentId + "\" name=\"base\"><properties></properties><bindings></bindings><components></components></component></components>";
            ContentVO templateContentVO = nodeDeliveryController.getBoundContent(this.getInfoGluePrincipal(), this.siteNodeId, this.languageId, true, "Meta information", DeliveryContext.getDeliveryContext());
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(templateContentVO.getId(), this.masterLanguageVO.getId());
            if (contentVersionVO == null) {
                SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.siteNodeId);
                String versionValue = "<?xml version='1.0' encoding='UTF-8'?><article xmlns=\"x-schema:ArticleSchema.xml\"><attributes><Title><![CDATA[" + siteNodeVO.getName() + "]]></Title><NavigationTitle><![CDATA[" + siteNodeVO.getName() + "]]></NavigationTitle><NiceURIName><![CDATA[" + new VisualFormatter().replaceNiceURINonAsciiWithSpecifiedChars(siteNodeVO.getName(), '_') + "]]></NiceURIName><Description><![CDATA[" + siteNodeVO.getName() + "]]></Description><MetaInfo><![CDATA[" + siteNodeVO.getName() + "]]></MetaInfo><ComponentStructure><![CDATA[]]></ComponentStructure></attributes></article>";
                contentVersionVO = new ContentVersionVO();
                contentVersionVO.setVersionComment("Autogenerated version");
                contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
                contentVersionVO.setVersionValue(versionValue);
                contentVersionVO = ContentVersionController.getContentVersionController().create(templateContentVO.getId(), this.languageId, contentVersionVO, null);
            }
            ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", componentXML, new InfoGluePrincipal("ComponentEditor", "none", "none", "none", new ArrayList(), new ArrayList(), true, null));
        } else {
            String componentXML = this.getPageComponentsString(this.siteNodeId, this.masterLanguageVO.getId());
            Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
            String componentXPath = "//component[@id=" + this.parentComponentId + "]/components";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
            if (anl.getLength() > 0) {
                Object childNodes;
                Element component = (Element)anl.item(0);
                String componentsXPath = "//component";
                NodeList nodes = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentsXPath);
                int i = 0;
                while (i < nodes.getLength()) {
                    Element element = (Element)nodes.item(i);
                    if (new Integer(element.getAttribute("id")) > newComponentId) {
                        newComponentId = new Integer(element.getAttribute("id"));
                    }
                    ++i;
                }
                newComponentId = new Integer(newComponentId + 1);
                ContentVO templateContentVO = ContentController.getContentController().getContentVOWithId(this.componentId);
                ContentTypeDefinitionVO contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(templateContentVO.getContentTypeDefinitionId());
                boolean isPagePartReference = false;
                if (contentTypeDefinitionVO.getName().equals("PagePartTemplate")) {
                    isPagePartReference = true;
                }
                if (this.slotPositionComponentId != null && !this.slotPositionComponentId.equals("")) {
                    childNodes = component.getChildNodes();
                    int i2 = 0;
                    while (i2 < childNodes.getLength()) {
                        Element element;
                        Node node = childNodes.item(i2);
                        if (node.getNodeType() == 1 && (element = (Element)node).getAttribute("id").equals(this.slotPositionComponentId)) {
                            logger.info((Object)("Inserting component before: " + element));
                            Element newComponent = this.addComponentElementBefore(component, element, new Integer(newComponentId), this.slotId, this.componentId, isPagePartReference);
                            break;
                        }
                        ++i2;
                    }
                } else {
                    childNodes = this.addComponentElement(component, new Integer(newComponentId), this.slotId, this.componentId, isPagePartReference);
                }
                ComponentController.getController().checkAndAutoCreateContents(this.siteNodeId, this.languageId, this.masterLanguageVO.getId(), this.assetKey, newComponentId, document, templateContentVO.getId(), this.getInfoGluePrincipal());
                String modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
                ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.masterLanguageVO.getId(), this.contentId).getBoundContent(this.getInfoGluePrincipal(), this.siteNodeId, this.masterLanguageVO.getId(), true, "Meta information", DeliveryContext.getDeliveryContext());
                ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), this.masterLanguageVO.getId());
                ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", modifiedXML, this.getInfoGluePrincipal());
            }
        }
        logger.info((Object)("newComponentId:" + newComponentId));
        this.url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + newComponentId + "&activatedComponentId=" + newComponentId + "&componentContentId=" + this.componentId + "&showSimple=" + this.showSimple;
        this.url = this.getResponse().encodeURL(this.url);
        this.getResponse().sendRedirect(this.url);
        return "none";
    }

    public String doAddOrReplaceComponent() throws Exception {
        try {
            logger.info((Object)"************************************************************");
            logger.info((Object)"* ADDING OR REPLACING COMPONENT                            *");
            logger.info((Object)"************************************************************");
            logger.info((Object)("siteNodeId:" + this.siteNodeId));
            logger.info((Object)("languageId:" + this.languageId));
            logger.info((Object)("contentId:" + this.contentId));
            logger.info((Object)("queryString:" + this.getRequest().getQueryString()));
            logger.info((Object)("parentComponentId:" + this.parentComponentId));
            logger.info((Object)("slotId:" + this.slotId));
            logger.info((Object)("specifyBaseTemplate:" + this.specifyBaseTemplate));
            logger.info((Object)("pagePartContentId:" + this.pagePartContentId));
            this.initialize();
            logger.info((Object)("masterLanguageId:" + this.masterLanguageVO.getId()));
            Integer newComponentId = new Integer(0);
            String componentXML = this.getPageComponentsString(this.siteNodeId, this.masterLanguageVO.getId());
            Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
            String componentXPath = "//component[@id=" + this.parentComponentId + "]";
            Node componentNode = XPathAPI.selectSingleNode((Node)document.getDocumentElement(), (String)componentXPath);
            if (componentNode != null) {
                String componentsXPath = "//component";
                NodeList nodes = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentsXPath);
                int i = 0;
                while (i < nodes.getLength()) {
                    Element element = (Element)nodes.item(i);
                    if (new Integer(element.getAttribute("id")) > newComponentId) {
                        newComponentId = new Integer(element.getAttribute("id"));
                    }
                    ++i;
                }
                newComponentId = new Integer(newComponentId + 1);
                NodeList childNodes = componentNode.getChildNodes();
                logger.info((Object)("childNodes:" + childNodes.getLength()));
                Node child = componentNode.getFirstChild();
                while (child != null) {
                    logger.info((Object)("Removing:" + child));
                    componentNode.removeChild(child);
                    child = componentNode.getFirstChild();
                }
                logger.info((Object)("childNodes:" + childNodes.getLength()));
                if (this.pagePartContentId != null) {
                    ContentVersionVO pagePartContentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(this.pagePartContentId, this.masterLanguageVO.getId());
                    String componentStructure = ContentVersionController.getContentVersionController().getAttributeValue(pagePartContentVersionVO.getId(), "ComponentStructure", false);
                    componentStructure = componentStructure.replaceAll(" isInherited=\"true\"", "");
                    componentStructure = componentStructure.replaceAll(" pagePartTemplateContentId=\"-1\"", "");
                    componentStructure = componentStructure.replaceAll("<property name=\"pagePartContentId\" path=\".*?\"></property>", "");
                    componentStructure = componentStructure.replaceAll("<property name=\"pagePartContentId\" path=\".*?\"/>", "");
                    componentStructure = componentStructure.replaceAll("<properties>", "<properties><property name=\"pagePartContentId\" path=\"" + this.pagePartContentId + "\"/>");
                    logger.info((Object)("componentStructure:" + componentStructure));
                    Document componentStructureDocument = XMLHelper.readDocumentFromByteArray(componentStructure.getBytes("UTF-8"));
                    Element rootNode = componentStructureDocument.getDocumentElement();
                    componentNode.appendChild(document.importNode(rootNode, true));
                    String modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
                    ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.masterLanguageVO.getId(), this.contentId).getBoundContent(this.getInfoGluePrincipal(), this.siteNodeId, this.masterLanguageVO.getId(), true, "Meta information", DeliveryContext.getDeliveryContext());
                    ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), this.masterLanguageVO.getId());
                    ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", modifiedXML, this.getInfoGluePrincipal());
                }
            }
            logger.info((Object)("newComponentId:" + newComponentId));
            this.url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + newComponentId + "&activatedComponentId=" + newComponentId + "&componentContentId=" + this.componentId + "&showSimple=" + this.showSimple;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.url = this.getResponse().encodeURL(this.url);
        this.getResponse().sendRedirect(this.url);
        return "none";
    }

    public String doMoveComponentToSlot() throws Exception {
        logger.info((Object)"************************************************************");
        logger.info((Object)"* MOVING COMPONENT TO ANOTHER SLOT                         *");
        logger.info((Object)"************************************************************");
        logger.info((Object)("siteNodeId:" + this.siteNodeId));
        logger.info((Object)("languageId:" + this.languageId));
        logger.info((Object)("contentId:" + this.contentId));
        logger.info((Object)("queryString:" + this.getRequest().getQueryString()));
        logger.info((Object)("parentComponentId:" + this.parentComponentId));
        logger.info((Object)("componentId:" + this.componentId));
        logger.info((Object)("slotId:" + this.slotId));
        logger.info((Object)("specifyBaseTemplate:" + this.specifyBaseTemplate));
        this.initialize();
        logger.info((Object)("masterLanguageId:" + this.masterLanguageVO.getId()));
        ContentVO componentContentVO = null;
        if (this.specifyBaseTemplate.equalsIgnoreCase("true")) {
            throw new SystemException("Not possible to move component to base slot");
        }
        String componentXML = this.getPageComponentsString(this.siteNodeId, this.masterLanguageVO.getId());
        Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String componentXPath = "//component[@id=" + this.componentId + "]";
        String parentComponentXPath = "//component[@id=" + this.parentComponentId + "]/components";
        logger.info((Object)("componentXPath:" + componentXPath));
        logger.info((Object)("parentComponentXPath:" + parentComponentXPath));
        Node componentNode = XPathAPI.selectSingleNode((Node)document.getDocumentElement(), (String)componentXPath);
        logger.info((Object)("Found componentNode:" + componentNode));
        Node parentComponentComponentsNode = XPathAPI.selectSingleNode((Node)document.getDocumentElement(), (String)parentComponentXPath);
        logger.info((Object)("Found parentComponentComponentsNode:" + parentComponentComponentsNode));
        if (componentNode != null && parentComponentComponentsNode != null) {
            String modifiedXML;
            Element component = (Element)componentNode;
            Element currentParentElement = (Element)componentNode.getParentNode();
            Element parentComponentComponentsElement = (Element)parentComponentComponentsNode;
            Element parentComponentElement = (Element)parentComponentComponentsNode.getParentNode();
            Integer componentContentId = new Integer(component.getAttribute("contentId"));
            Integer parentComponentContentId = new Integer(parentComponentElement.getAttribute("contentId"));
            logger.info((Object)("componentContentId:" + componentContentId));
            logger.info((Object)("parentComponentContentId:" + parentComponentContentId));
            componentContentVO = ContentController.getContentController().getContentVOWithId(componentContentId);
            PageEditorHelper peh = new PageEditorHelper();
            List<Slot> slots = peh.getSlots(parentComponentContentId, this.languageId, this.getInfoGluePrincipal());
            boolean allowed = true;
            Iterator<Slot> slotsIterator = slots.iterator();
            if (slotsIterator.hasNext()) {
                Slot slot = slotsIterator.next();
                logger.info((Object)(String.valueOf(slot.getId()) + "=" + this.slotId));
                if (slot.getId().equals(this.slotId)) {
                    int i;
                    String[] allowedComponentNames = slot.getAllowedComponentsArray();
                    String[] disallowedComponentNames = slot.getDisallowedComponentsArray();
                    if (allowedComponentNames != null && allowedComponentNames.length > 0) {
                        allowed = false;
                        i = 0;
                        while (i < allowedComponentNames.length) {
                            if (allowedComponentNames[i].equalsIgnoreCase(componentContentVO.getName())) {
                                allowed = true;
                            }
                            ++i;
                        }
                    }
                    if (disallowedComponentNames != null && disallowedComponentNames.length > 0) {
                        i = 0;
                        while (i < disallowedComponentNames.length) {
                            if (disallowedComponentNames[i].equalsIgnoreCase(componentContentVO.getName())) {
                                allowed = false;
                            }
                            ++i;
                        }
                    }
                }
            }
            logger.info((Object)("Should the component:" + componentContentVO + " be allowed to be put in " + this.slotId + ":" + allowed));
            logger.info((Object)("currentParentElement:" + currentParentElement.getNodeName() + ":" + currentParentElement.hashCode()));
            logger.info((Object)("parentComponentComponentsElement:" + parentComponentComponentsElement.getNodeName() + ":" + parentComponentComponentsElement.hashCode()));
            logger.info((Object)("slotPositionComponentId:" + this.slotPositionComponentId));
            if (component.getParentNode() == parentComponentComponentsElement && this.slotId.equalsIgnoreCase(component.getAttribute("name"))) {
                logger.info((Object)"Yes...");
                component.getParentNode().removeChild(component);
                component.setAttribute("name", this.slotId);
                logger.info((Object)("slotPositionComponentId:" + this.slotPositionComponentId));
                if (this.slotPositionComponentId != null && !this.slotPositionComponentId.equals("")) {
                    logger.info((Object)("Moving component to slot: " + this.slotPositionComponentId));
                    Element afterElement = null;
                    NodeList childNodes = parentComponentComponentsElement.getChildNodes();
                    int i = 0;
                    while (i < childNodes.getLength()) {
                        Element element;
                        Node node = childNodes.item(i);
                        if (node.getNodeType() == 1 && (element = (Element)node).getAttribute("id").equals(this.slotPositionComponentId)) {
                            afterElement = element;
                            break;
                        }
                        ++i;
                    }
                    if (afterElement != null) {
                        logger.info((Object)("Inserting component before: " + afterElement));
                        parentComponentComponentsElement.insertBefore(component, afterElement);
                    } else {
                        parentComponentComponentsElement.appendChild(component);
                    }
                } else {
                    logger.info((Object)"Appending component...");
                    parentComponentComponentsElement.appendChild(component);
                }
                modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
                ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.masterLanguageVO.getId(), this.contentId).getBoundContent(this.getInfoGluePrincipal(), this.siteNodeId, this.masterLanguageVO.getId(), true, "Meta information", DeliveryContext.getDeliveryContext());
                ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), this.masterLanguageVO.getId());
                ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", modifiedXML, this.getInfoGluePrincipal());
                this.url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + this.componentId + "&componentContentId=" + componentContentVO.getId() + "&showSimple=" + this.showSimple;
            } else if (allowed && (component.getParentNode() != parentComponentComponentsElement || !this.slotId.equalsIgnoreCase(component.getAttribute("name")))) {
                logger.info((Object)"Moving component...");
                component.getParentNode().removeChild(component);
                component.setAttribute("name", this.slotId);
                if (this.slotPositionComponentId != null && !this.slotPositionComponentId.equals("")) {
                    NodeList childNodes = parentComponentComponentsElement.getChildNodes();
                    int i = 0;
                    while (i < childNodes.getLength()) {
                        Element element;
                        Node node = childNodes.item(i);
                        if (node.getNodeType() == 1 && (element = (Element)node).getAttribute("id").equals(this.slotPositionComponentId)) {
                            logger.info((Object)("Inserting component before: " + element));
                            parentComponentComponentsElement.insertBefore(component, element);
                            break;
                        }
                        ++i;
                    }
                } else {
                    parentComponentComponentsElement.appendChild(component);
                }
                modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
                ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.masterLanguageVO.getId(), this.contentId).getBoundContent(this.getInfoGluePrincipal(), this.siteNodeId, this.masterLanguageVO.getId(), true, "Meta information", DeliveryContext.getDeliveryContext());
                ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), this.masterLanguageVO.getId());
                ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", modifiedXML, this.getInfoGluePrincipal());
                this.url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + this.componentId + "&componentContentId=" + componentContentVO.getId() + "&showSimple=" + this.showSimple;
            } else {
                this.url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&showSimple=" + this.showSimple;
            }
        }
        this.url = this.getResponse().encodeURL(this.url);
        this.getResponse().sendRedirect(this.url);
        return "none";
    }

    public String doMoveComponent() throws Exception {
        this.initialize();
        String componentXML = this.getPageComponentsString(this.siteNodeId, this.masterLanguageVO.getId());
        Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String componentXPath = "//component[@id=" + this.componentId + "]";
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
        if (anl.getLength() > 0) {
            Element element;
            Element component = (Element)anl.item(0);
            String name = component.getAttribute("name");
            Node parentNode = component.getParentNode();
            boolean hasChanged = false;
            if (this.direction == 0) {
                Node previousNode = component.getPreviousSibling();
                while (previousNode != null && previousNode.getNodeType() != 1) {
                    previousNode = previousNode.getPreviousSibling();
                }
                element = (Element)previousNode;
                while (element != null && !element.getAttribute("name").equalsIgnoreCase(name)) {
                    previousNode = previousNode.getPreviousSibling();
                    while (previousNode != null && previousNode.getNodeType() != 1) {
                        previousNode = previousNode.getPreviousSibling();
                    }
                    element = (Element)previousNode;
                }
                if (previousNode != null) {
                    parentNode.removeChild(component);
                    parentNode.insertBefore(component, previousNode);
                    hasChanged = true;
                }
            } else if (this.direction == 1) {
                Node nextNode = component.getNextSibling();
                if (nextNode != null && nextNode.getNodeType() != 1) {
                    nextNode = nextNode.getNextSibling();
                }
                element = (Element)nextNode;
                while (element != null && !element.getAttribute("name").equalsIgnoreCase(name)) {
                    nextNode = nextNode.getNextSibling();
                    element = (Element)nextNode;
                }
                if (nextNode != null) {
                    nextNode = nextNode.getNextSibling();
                }
                if (nextNode != null) {
                    parentNode.removeChild(component);
                    parentNode.insertBefore(component, nextNode);
                    hasChanged = true;
                } else {
                    parentNode.removeChild(component);
                    parentNode.appendChild(component);
                    hasChanged = true;
                }
            }
            if (hasChanged) {
                String modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
                ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.languageId, this.contentId).getBoundContent(this.getInfoGluePrincipal(), this.siteNodeId, this.masterLanguageVO.getId(), true, "Meta information", DeliveryContext.getDeliveryContext());
                ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), this.masterLanguageVO.getId());
                ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", modifiedXML, this.getInfoGluePrincipal());
            }
        }
        this.url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + this.componentId + "&showSimple=" + this.showSimple;
        this.url = this.getResponse().encodeURL(this.url);
        this.getResponse().sendRedirect(this.url);
        return "none";
    }

    public String doUpdateComponentProperties() throws Exception {
        this.initialize();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"************************************************************");
            logger.info((Object)"* doUpdateComponentProperties                              *");
            logger.info((Object)"************************************************************");
            logger.info((Object)("siteNodeId:" + this.siteNodeId));
            logger.info((Object)("languageId:" + this.languageId));
            logger.info((Object)("contentId:" + this.contentId));
            logger.info((Object)("componentId:" + this.componentId));
            logger.info((Object)("slotId:" + this.slotId));
            logger.info((Object)("specifyBaseTemplate:" + this.specifyBaseTemplate));
        }
        for (String name : this.getRequest().getParameterMap().keySet()) {
            String value = this.getRequest().getParameter(name);
            logger.info((Object)(String.valueOf(name) + "=" + value));
        }
        Integer siteNodeId = new Integer(this.getRequest().getParameter("siteNodeId"));
        Integer languageId = new Integer(this.getRequest().getParameter("languageId"));
        Locale locale = LanguageController.getController().getLocaleWithId(languageId);
        String entity = this.getRequest().getParameter("entity");
        String componentXML = this.getPageComponentsString(siteNodeId, this.masterLanguageVO.getId());
        ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, this.contentId).getBoundContent(this.getInfoGluePrincipal(), siteNodeId, languageId, true, "Meta information", DeliveryContext.getDeliveryContext());
        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), this.masterLanguageVO.getId());
        Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String characterEncoding = this.getRequest().getCharacterEncoding();
        characterEncoding = this.getResponse().getCharacterEncoding();
        logger.info((Object)("siteNodeId:" + siteNodeId));
        logger.info((Object)("languageId:" + languageId));
        logger.info((Object)("entity:" + entity));
        String componentContentId = null;
        int propertyIndex = 0;
        String propertyName = this.getRequest().getParameter(String.valueOf(propertyIndex) + "_propertyName");
        while (propertyName != null && !propertyName.equals("")) {
            String[] propertyValues = this.getRequest().getParameterValues(propertyName);
            String propertyValue = "";
            if (propertyValues != null && propertyValues.length == 1) {
                propertyValue = propertyValues[0];
            } else if (propertyValues != null) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < propertyValues.length) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(propertyValues[i]);
                    ++i;
                }
                propertyValue = sb.toString();
            }
            logger.info((Object)("propertyName:" + propertyName));
            logger.info((Object)("propertyValue:" + propertyValue));
            String separator = System.getProperty("line.separator");
            propertyValue = propertyValue.replaceAll(separator, "igbr");
            logger.info((Object)("propertyValue1:" + propertyValue));
            propertyValue = PageEditorHelper.untransformAttribute(propertyValue);
            logger.info((Object)("propertyValue2:" + propertyValue));
            if (propertyValue != null && !propertyValue.equals("") && !propertyValue.equalsIgnoreCase("undefined")) {
                String componentPropertyXPath = "//component[@id=" + this.componentId + "]/properties/property[@name='" + propertyName + "']";
                NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentPropertyXPath);
                if (anl.getLength() == 0) {
                    String componentXPath = "//component[@id=" + this.componentId + "]/properties";
                    NodeList componentNodeList = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
                    if (componentNodeList.getLength() > 0) {
                        Element componentProperties = (Element)componentNodeList.item(0);
                        this.addPropertyElement(componentProperties, propertyName, propertyValue, "textfield", locale);
                        anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentPropertyXPath);
                    }
                }
                logger.info((Object)("anl:" + anl));
                if (anl.getLength() > 0) {
                    Element component = (Element)anl.item(0);
                    componentContentId = ((Element)component.getParentNode().getParentNode()).getAttribute("contentId");
                    component.setAttribute("path_" + locale.getLanguage(), propertyValue);
                    logger.info((Object)("Setting 'path_" + locale.getLanguage() + ":" + propertyValue));
                } else {
                    logger.warn((Object)"No property could be updated... must be wrong.");
                }
            }
            propertyName = this.getRequest().getParameter(String.valueOf(++propertyIndex) + "_propertyName");
        }
        String modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
        logger.info((Object)("contentVersionVO:" + contentVersionVO.getContentVersionId()));
        ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", modifiedXML, this.getInfoGluePrincipal());
        this.url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + this.componentId + "&activatedComponentId=" + this.componentId + "&componentContentId=" + componentContentId + "&showSimple=" + this.showSimple;
        this.url = this.getResponse().encodeURL(this.url);
        this.getResponse().sendRedirect(this.url);
        return "none";
    }

    public String doDeleteComponent() throws Exception {
        this.initialize();
        logger.info((Object)("doDeleteComponent:" + this.getRequest().getQueryString()));
        String componentXML = this.getPageComponentsString(this.siteNodeId, this.masterLanguageVO.getId());
        Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String componentXPath = "//component[@id=" + this.componentId + "]";
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
        if (anl.getLength() > 0) {
            Element component = (Element)anl.item(0);
            component.getParentNode().removeChild(component);
            String modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
            ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.languageId, this.contentId).getBoundContent(this.getInfoGluePrincipal(), this.siteNodeId, this.languageId, true, "Meta information", DeliveryContext.getDeliveryContext());
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), this.masterLanguageVO.getId());
            ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", modifiedXML, this.getInfoGluePrincipal());
        }
        this.url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&showSimple=" + this.showSimple;
        this.url = this.getResponse().encodeURL(this.url);
        this.getResponse().sendRedirect(this.url);
        return "none";
    }

    public String doChangeComponent() throws Exception {
        this.initialize();
        logger.info((Object)("doChangeComponent:" + this.getRequest().getQueryString()));
        logger.info((Object)("masterLanguageId:" + this.masterLanguageVO.getId()));
        Integer newComponentId = new Integer(0);
        String componentXML = this.getPageComponentsString(this.siteNodeId, this.masterLanguageVO.getId());
        logger.info((Object)("componentXML:" + componentXML));
        Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String componentXPath = "//component[@id=" + this.componentId + "]";
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
        if (anl.getLength() > 0 && this.newComponentContentId != null) {
            Element component = (Element)anl.item(0);
            ContentVersionVO newComponentContentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(this.newComponentContentId, this.masterLanguageVO.getId());
            String template = ContentVersionController.getContentVersionController().getAttributeValue(newComponentContentVersionVO, "Template", false);
            logger.info((Object)("template:" + template));
            String subComponentsXPath = "//component[@id=" + this.componentId + "]//component";
            NodeList subComponents = XPathAPI.selectNodeList((Node)component, (String)subComponentsXPath);
            logger.info((Object)("subComponents:" + subComponents.getLength()));
            int i = 0;
            while (i < subComponents.getLength()) {
                Element subComponent = (Element)subComponents.item(i);
                String slotId = subComponent.getAttribute("name");
                logger.info((Object)("subComponent slotId:" + slotId));
                if (template.indexOf("id=\"" + slotId + "\"") == -1) {
                    logger.info((Object)"deleting subComponent as it was not part of the new template");
                    Node parentNode = subComponent.getParentNode();
                    parentNode.removeChild(subComponent);
                }
                ++i;
            }
            component.setAttribute("contentId", "" + this.newComponentContentId);
            String modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
            logger.info((Object)("modifiedXML:" + modifiedXML));
            ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.masterLanguageVO.getId(), this.contentId).getBoundContent(this.getInfoGluePrincipal(), this.siteNodeId, this.masterLanguageVO.getId(), true, "Meta information", DeliveryContext.getDeliveryContext());
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), this.masterLanguageVO.getId());
            ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", modifiedXML, this.getInfoGluePrincipal());
        }
        logger.info((Object)("newComponentId:" + newComponentId));
        this.url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + this.componentId + "&activatedComponentId=" + newComponentId + "&showSimple=" + this.showSimple;
        this.url = this.getResponse().encodeURL(this.url);
        this.getResponse().sendRedirect(this.url);
        return "none";
    }

    public String doAddComponentPropertyBinding() throws Exception {
        this.initialize();
        Integer siteNodeId = new Integer(this.getRequest().getParameter("siteNodeId"));
        Integer languageId = new Integer(this.getRequest().getParameter("languageId"));
        Locale locale = LanguageController.getController().getLocaleWithId(languageId);
        String entity = this.getRequest().getParameter("entity");
        Integer entityId = new Integer(this.getRequest().getParameter("entityId"));
        String propertyName = this.getRequest().getParameter("propertyName");
        String componentXML = this.getPageComponentsString(siteNodeId, this.masterLanguageVO.getId());
        Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String componentPropertyXPath = "//component[@id=" + this.componentId + "]/properties/property[@name='" + propertyName + "']";
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentPropertyXPath);
        if (anl.getLength() == 0) {
            String componentXPath = "//component[@id=" + this.componentId + "]/properties";
            NodeList componentNodeList = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
            if (componentNodeList.getLength() > 0) {
                Element componentProperties = (Element)componentNodeList.item(0);
                if (entity.equalsIgnoreCase("SiteNode")) {
                    this.addPropertyElement(componentProperties, propertyName, this.path, "siteNodeBinding", locale);
                } else {
                    this.addPropertyElement(componentProperties, propertyName, this.path, "contentBinding", locale);
                }
                anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentPropertyXPath);
            }
        }
        if (anl.getLength() > 0) {
            Element component = (Element)anl.item(0);
            component.setAttribute("path", this.path);
            NamedNodeMap attributes = component.getAttributes();
            logger.debug((Object)("NumberOfAttributes:" + attributes.getLength() + ":" + attributes));
            ArrayList<String> removableAttributes = new ArrayList<String>();
            int i = 0;
            while (i < attributes.getLength()) {
                Node node = attributes.item(i);
                logger.debug((Object)("Node:" + node.getNodeName()));
                if (node.getNodeName().startsWith("path_")) {
                    removableAttributes.add(node.getNodeName());
                }
                ++i;
            }
            for (String attributeName : removableAttributes) {
                logger.debug((Object)("Removing node:" + attributeName));
                component.removeAttribute(attributeName);
            }
            NodeList children = component.getChildNodes();
            int i2 = 0;
            while (i2 < children.getLength()) {
                Node node = children.item(i2);
                component.removeChild(node);
                ++i2;
            }
            Element newComponent = this.addBindingElement(component, entity, entityId, this.assetKey);
            String modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
            ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, this.contentId).getBoundContent(this.getInfoGluePrincipal(), siteNodeId, languageId, true, "Meta information", DeliveryContext.getDeliveryContext());
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), this.masterLanguageVO.getId());
            ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", modifiedXML, this.getInfoGluePrincipal());
        }
        this.url = this.showDecorated == null || !this.showDecorated.equalsIgnoreCase("false") ? String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + this.componentId + "&activatedComponentId=" + this.componentId + "&showSimple=" + this.showSimple : String.valueOf(this.getComponentRendererUrl()) + "ViewPage.action?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + this.componentId + "&activatedComponentId=" + this.componentId + "&showSimple=" + this.showSimple;
        this.url = this.getResponse().encodeURL(this.url);
        this.getResponse().sendRedirect(this.url);
        return "none";
    }

    public String doAddComponentPropertyBindingWithQualifyer() throws Exception {
        this.initialize();
        Integer siteNodeId = new Integer(this.getRequest().getParameter("siteNodeId"));
        Integer languageId = new Integer(this.getRequest().getParameter("languageId"));
        Integer contentId = new Integer(this.getRequest().getParameter("contentId"));
        Locale locale = LanguageController.getController().getLocaleWithId(languageId);
        String qualifyerXML = this.getRequest().getParameter("qualifyerXML");
        String propertyName = this.getRequest().getParameter("propertyName");
        NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId);
        String componentXML = this.getPageComponentsString(siteNodeId, this.masterLanguageVO.getId());
        Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String componentPropertyXPath = "//component[@id=" + this.componentId + "]/properties/property[@name='" + propertyName + "']";
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentPropertyXPath);
        if (anl.getLength() > 0) {
            Node propertyNode = anl.item(0);
            propertyNode.getParentNode().removeChild(propertyNode);
        }
        String componentXPath = "//component[@id=" + this.componentId + "]/properties";
        NodeList componentNodeList = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
        if (componentNodeList.getLength() > 0) {
            Element componentProperties = (Element)componentNodeList.item(0);
            this.addPropertyElement(componentProperties, propertyName, this.path, "contentBinding", locale);
            anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentPropertyXPath);
        }
        if (anl.getLength() > 0) {
            Element component = (Element)anl.item(0);
            component.setAttribute("path", this.path);
            component.setAttribute("path_" + locale.getLanguage(), this.path);
            this.addBindingElement(component, qualifyerXML);
            String modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
            ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getBoundContent(this.getInfoGluePrincipal(), siteNodeId, languageId, true, "Meta information", DeliveryContext.getDeliveryContext());
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), this.masterLanguageVO.getId());
            ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", modifiedXML, this.getInfoGluePrincipal());
        }
        this.url = this.showDecorated == null || this.showDecorated.equalsIgnoreCase("true") ? String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + this.componentId + "&activatedComponentId=" + this.componentId + "&showSimple=" + this.showSimple : String.valueOf(this.getComponentRendererUrl()) + "ViewPage.action?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + this.componentId + "&activatedComponentId=" + this.componentId + "&showSimple=" + this.showSimple;
        this.url = this.getResponse().encodeURL(this.url);
        this.getResponse().sendRedirect(this.url);
        return "none";
    }

    public String doDeleteComponentBinding() throws Exception {
        this.initialize();
        Integer siteNodeId = new Integer(this.getRequest().getParameter("siteNodeId"));
        Integer languageId = new Integer(this.getRequest().getParameter("languageId"));
        Integer contentId = new Integer(this.getRequest().getParameter("contentId"));
        Integer bindingId = new Integer(this.getRequest().getParameter("bindingId"));
        String componentXML = this.getPageComponentsString(siteNodeId, this.masterLanguageVO.getId());
        Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String componentXPath = "//component[@id=" + this.componentId + "]/bindings/binding[@id=" + bindingId + "]";
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
        if (anl.getLength() > 0) {
            Element component = (Element)anl.item(0);
            component.getParentNode().removeChild(component);
            String modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
            ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getBoundContent(this.getInfoGluePrincipal(), siteNodeId, languageId, true, "Meta information", DeliveryContext.getDeliveryContext());
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), this.masterLanguageVO.getId());
            ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", modifiedXML, this.getInfoGluePrincipal());
        }
        this.url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + this.componentId + "&activatedComponentId=" + this.componentId + "&showSimple=" + this.showSimple;
        this.url = this.getResponse().encodeURL(this.url);
        return "none";
    }

    public List getComponentBindings() throws Exception {
        ArrayList bindings = new ArrayList();
        try {
            Integer siteNodeId = new Integer(this.getRequest().getParameter("siteNodeId"));
            Integer languageId = new Integer(this.getRequest().getParameter("languageId"));
            Integer contentId = new Integer(this.getRequest().getParameter("contentId"));
            String propertyName = this.getRequest().getParameter("propertyName");
            String componentXML = this.getPageComponentsString(siteNodeId, this.masterLanguageVO.getId());
            Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
            String componentXPath = "//component[@id=" + this.componentId + "]/properties/property[@name='" + propertyName + "']/binding";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
            int i = 0;
            while (i < anl.getLength()) {
                Element component = (Element)anl.item(i);
                String entityName = component.getAttribute("entity");
                String entityId = component.getAttribute("entityId");
                String assetKey = component.getAttribute("assetKey");
                try {
                    String path = "Undefined";
                    if (entityName.equalsIgnoreCase("SiteNode")) {
                        SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(new Integer(entityId));
                        path = siteNodeVO.getName();
                    } else if (entityName.equalsIgnoreCase("Content")) {
                        ContentVO contentVO = ContentController.getContentController().getContentVOWithId(new Integer(entityId));
                        path = contentVO.getName();
                    }
                    HashMap<String, String> binding = new HashMap<String, String>();
                    binding.put("entityName", entityName);
                    binding.put("entityId", entityId);
                    binding.put("assetKey", assetKey);
                    binding.put("path", path);
                    bindings.add(binding);
                }
                catch (Exception e) {
                    logger.warn((Object)("There was " + entityName + " bound to property '" + propertyName + "' on siteNode " + siteNodeId + " which appears to have been deleted."));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bindings;
    }

    public String doDeleteComponentPropertyValue() throws Exception {
        this.initialize();
        Integer siteNodeId = new Integer(this.getRequest().getParameter("siteNodeId"));
        Integer languageId = new Integer(this.getRequest().getParameter("languageId"));
        Integer contentId = new Integer(this.getRequest().getParameter("contentId"));
        String propertyName = this.getRequest().getParameter("propertyName");
        Locale locale = LanguageController.getController().getLocaleWithId(languageId);
        String componentXML = this.getPageComponentsString(siteNodeId, this.masterLanguageVO.getId());
        Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String componentPropertyXPath = "//component[@id=" + this.componentId + "]/properties/property[@name='" + propertyName + "']";
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentPropertyXPath);
        if (anl.getLength() > 0) {
            Node propertyNode = anl.item(0);
            Element propertyElement = (Element)propertyNode;
            propertyElement.removeAttribute("path_" + locale.getLanguage());
            if (propertyElement.getAttributes().getLength() == 0) {
                // empty if block
            }
            propertyNode.getParentNode().removeChild(propertyNode);
        }
        String detailSiteNodeIdPropertyXPath = "//component[@id=" + this.componentId + "]/properties/property[@name='" + propertyName + "_detailSiteNodeId']";
        NodeList anl2 = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)detailSiteNodeIdPropertyXPath);
        if (anl2.getLength() > 0) {
            Node propertyNode = anl2.item(0);
            Element propertyElement = (Element)propertyNode;
            propertyElement.removeAttribute("path_" + locale.getLanguage());
            if (propertyElement.getAttributes().getLength() == 0) {
                // empty if block
            }
            propertyNode.getParentNode().removeChild(propertyNode);
        }
        String modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
        ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getBoundContent(this.getInfoGluePrincipal(), siteNodeId, languageId, true, "Meta information", DeliveryContext.getDeliveryContext());
        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), this.masterLanguageVO.getId());
        ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", modifiedXML, this.getInfoGluePrincipal());
        this.url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + this.contentId + "&focusElementId=" + this.componentId + "&activatedComponentId=" + this.componentId + "&showSimple=" + this.showSimple;
        this.url = this.getResponse().encodeURL(this.url);
        this.getResponse().sendRedirect(this.url);
        return "none";
    }

    private Element addPropertyElement(Element parent, String name, String path, String type, Locale locale) {
        Element element = parent.getOwnerDocument().createElement("property");
        element.setAttribute("name", name);
        if (type.equalsIgnoreCase("siteNodeBinding") || type.equalsIgnoreCase("contentBinding")) {
            element.setAttribute("path", path);
            element.setAttribute("path_" + locale.getLanguage(), path);
        } else {
            element.setAttribute("path_" + locale.getLanguage(), path);
        }
        element.setAttribute("type", type);
        parent.appendChild(element);
        return element;
    }

    private Element addComponentElement(Element parent, Integer id, String name, Integer contentId, boolean isPagePartReference) {
        Element element = parent.getOwnerDocument().createElement("component");
        if (isPagePartReference) {
            element.setAttribute("isPagePartReference", "true");
        }
        element.setAttribute("id", id.toString());
        element.setAttribute("contentId", contentId.toString());
        element.setAttribute("name", name);
        Element properties = parent.getOwnerDocument().createElement("properties");
        element.appendChild(properties);
        Element subComponents = parent.getOwnerDocument().createElement("components");
        element.appendChild(subComponents);
        parent.appendChild(element);
        return element;
    }

    private Element addComponentElementBefore(Element parent, Element beforeElement, Integer id, String name, Integer contentId, boolean isPagePartReference) {
        Element element = parent.getOwnerDocument().createElement("component");
        if (isPagePartReference) {
            element.setAttribute("isPagePartReference", "true");
        }
        element.setAttribute("id", id.toString());
        element.setAttribute("contentId", contentId.toString());
        element.setAttribute("name", name);
        Element properties = parent.getOwnerDocument().createElement("properties");
        element.appendChild(properties);
        Element subComponents = parent.getOwnerDocument().createElement("components");
        element.appendChild(subComponents);
        parent.insertBefore(element, beforeElement);
        return element;
    }

    private Element addBindingElement(Element parent, String entity, Integer entityId, String assetKey) {
        Element element = parent.getOwnerDocument().createElement("binding");
        element.setAttribute("entityId", entityId.toString());
        element.setAttribute("entity", entity);
        if (assetKey != null && !assetKey.equals("")) {
            element.setAttribute("assetKey", assetKey);
        }
        parent.appendChild(element);
        return element;
    }

    private void addBindingElement(Element parent, String qualifyerXML) throws Exception {
        Document document = XMLHelper.readDocumentFromByteArray(qualifyerXML.getBytes());
        NodeList nl = document.getChildNodes().item(0).getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element qualifyerElement = (Element)nl.item(i);
            String entityName = qualifyerElement.getNodeName();
            String assetKey = qualifyerElement.getAttribute("assetKey");
            String entityId = qualifyerElement.getFirstChild().getNodeValue();
            Element element = parent.getOwnerDocument().createElement("binding");
            element.setAttribute("entityId", entityId);
            element.setAttribute("entity", entityName);
            element.setAttribute("assetKey", assetKey);
            parent.appendChild(element);
            ++i;
        }
    }

    public List getSortedComponents(String sortProperty) throws Exception {
        List componentVOList = null;
        try {
            String direction = "asc";
            componentVOList = ComponentController.getController().getComponentVOList(sortProperty, direction, this.allowedComponentNames, this.disallowedComponentNames, this.getInfoGluePrincipal());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return componentVOList;
    }

    private String getPageComponentsString(Integer siteNodeId, Integer languageId) throws SystemException, Exception {
        String template = null;
        try {
            ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, this.contentId).getBoundContent(this.getInfoGluePrincipal(), siteNodeId, languageId, true, "Meta information", DeliveryContext.getDeliveryContext());
            if (contentVO == null) {
                throw new SystemException("There was no template bound to this page which makes it impossible to render.");
            }
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), languageId);
            if (contentVersionVO == null) {
                SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(siteNodeId);
                LanguageVO masterLanguage = LanguageController.getController().getMasterLanguage(siteNodeVO.getRepositoryId());
                contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), masterLanguage.getLanguageId());
            }
            if ((template = ContentVersionController.getContentVersionController().getAttributeValue(contentVersionVO.getId(), "ComponentStructure", false)) == null) {
                throw new SystemException("There was no template bound to this page which makes it impossible to render.");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return template;
    }

    public String getDigitalAssetUrl(Integer contentId, String key) throws Exception {
        String imageHref;
        block3: {
            imageHref = null;
            try {
                LanguageVO masterLanguage = LanguageController.getController().getMasterLanguage(ContentController.getContentController().getContentVOWithId(contentId).getRepositoryId());
                ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, masterLanguage.getId());
                if (contentVersionVO == null) break block3;
                List digitalAssets = DigitalAssetController.getDigitalAssetVOList(contentVersionVO.getId());
                for (DigitalAssetVO digitalAssetVO : digitalAssets) {
                    if (!digitalAssetVO.getAssetKey().equals(key)) continue;
                    imageHref = DigitalAssetController.getDigitalAssetUrl(digitalAssetVO.getId());
                    break;
                }
            }
            catch (Exception e) {
                logger.warn((Object)("We could not get the url of the digitalAsset: " + e.getMessage()), (Throwable)e);
                imageHref = e.getMessage();
            }
        }
        return imageHref;
    }

    public String getDigitalAssetThumbnailUrl(Integer contentId, String key) throws Exception {
        String imageHref;
        block3: {
            imageHref = null;
            try {
                LanguageVO masterLanguage = LanguageController.getController().getMasterLanguage(ContentController.getContentController().getContentVOWithId(contentId).getRepositoryId());
                ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, masterLanguage.getId());
                if (contentVersionVO == null) break block3;
                List digitalAssets = DigitalAssetController.getDigitalAssetVOList(contentVersionVO.getId());
                for (DigitalAssetVO digitalAssetVO : digitalAssets) {
                    if (!digitalAssetVO.getAssetKey().equals(key)) continue;
                    imageHref = DigitalAssetController.getDigitalAssetThumbnailUrl(digitalAssetVO.getId());
                    break;
                }
            }
            catch (Exception e) {
                logger.warn((Object)("We could not get the thumbnail url of the digitalAsset: " + e.getMessage()), (Throwable)e);
                imageHref = e.getMessage();
            }
        }
        return imageHref;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setContentId(Integer integer) {
        this.contentId = integer;
    }

    public Integer getComponentId() {
        return this.componentId;
    }

    public void setComponentId(Integer componentId) {
        this.componentId = componentId;
    }

    public Integer getParentComponentId() {
        return this.parentComponentId;
    }

    public void setParentComponentId(Integer parentComponentId) {
        this.parentComponentId = parentComponentId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public void setSlotId(String slotId) {
        this.slotId = slotId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getFilterRepositoryId() {
        return this.filterRepositoryId;
    }

    public void setFilterRepositoryId(Integer filterRepositoryId) {
        this.filterRepositoryId = filterRepositoryId;
    }

    public String getSpecifyBaseTemplate() {
        return this.specifyBaseTemplate;
    }

    public void setSpecifyBaseTemplate(String specifyBaseTemplate) {
        this.specifyBaseTemplate = specifyBaseTemplate;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public LanguageVO getMasterLanguageVO() {
        return this.masterLanguageVO;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSortProperty() {
        return this.sortProperty;
    }

    public void setSortProperty(String sortProperty) {
        this.sortProperty = sortProperty;
    }

    public Integer getDirection() {
        return this.direction;
    }

    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    public String[] getAllowedContentTypeIds() {
        return this.allowedContentTypeIds;
    }

    public void setAllowedContentTypeIds(String[] allowedContentTypeIds) {
        this.allowedContentTypeIds = allowedContentTypeIds;
    }

    public String getAllowedContentTypeIdsAsUrlEncodedString() throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.allowedContentTypeIds.length) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append("allowedContentTypeIds=" + URLEncoder.encode(this.allowedContentTypeIds[i], "UTF-8"));
            ++i;
        }
        return sb.toString();
    }

    public boolean getShowSimple() {
        return this.showSimple;
    }

    public void setShowSimple(boolean showSimple) {
        this.showSimple = showSimple;
    }

    public Integer getPageTemplateContentId() {
        return this.pageTemplateContentId;
    }

    public void setPageTemplateContentId(Integer pageTemplateContentId) {
        this.pageTemplateContentId = pageTemplateContentId;
    }

    public String[] getAllowedComponentNames() {
        return this.allowedComponentNames;
    }

    public void setAllowedComponentNames(String[] allowedComponentNames) {
        this.allowedComponentNames = allowedComponentNames;
    }

    public String[] getDisallowedComponentNames() {
        return this.disallowedComponentNames;
    }

    public void setDisallowedComponentNames(String[] disallowedComponentNames) {
        this.disallowedComponentNames = disallowedComponentNames;
    }

    public String getAllowedComponentNamesAsUrlEncodedString() throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.allowedComponentNames.length) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append("allowedComponentNames=" + URLEncoder.encode(this.allowedComponentNames[i], "UTF-8"));
            ++i;
        }
        return sb.toString();
    }

    public String getDisallowedComponentNamesAsUrlEncodedString() throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.disallowedComponentNames.length) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append("disallowedComponentNames=" + URLEncoder.encode(this.disallowedComponentNames[i], "UTF-8"));
            ++i;
        }
        return sb.toString();
    }

    public String getAssetKey() {
        return this.assetKey;
    }

    public void setAssetKey(String assetKey) {
        this.assetKey = assetKey;
    }

    public void setNewComponentContentId(Integer newComponentContentId) {
        this.newComponentContentId = newComponentContentId;
    }

    public String getShowDecorated() {
        return this.showDecorated;
    }

    public void setShowDecorated(String showDecorated) {
        this.showDecorated = showDecorated;
    }

    public String getSlotPositionComponentId() {
        return this.slotPositionComponentId;
    }

    public void setSlotPositionComponentId(String slotPositionComponentId) {
        this.slotPositionComponentId = slotPositionComponentId;
    }

    public Integer getPagePartContentId() {
        return this.pagePartContentId;
    }

    public void setPagePartContentId(Integer pagePartContentId) {
        this.pagePartContentId = pagePartContentId;
    }
}

