/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.actions;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AvailableServiceBindingController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentStateController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.EventController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ServiceBindingController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionControllerProxy;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.AvailableServiceBindingVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.SiteNodeTypeDefinitionVO;
import org.infoglue.cms.entities.structure.QualifyerVO;
import org.infoglue.cms.entities.structure.ServiceBinding;
import org.infoglue.cms.entities.structure.ServiceBindingVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.entities.workflow.EventVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;

public class ViewSiteNodeAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewSiteNodeAction.class.getName());
    private static final long serialVersionUID = 1L;
    private Integer unrefreshedSiteNodeId = new Integer(0);
    private Integer changeTypeId = new Integer(0);
    private Integer repositoryId = null;
    private SiteNodeTypeDefinitionVO siteNodeTypeDefinitionVO;
    private List availableServiceBindings = null;
    private List serviceBindings = null;
    private List referenceBeanList = new ArrayList();
    private List availableLanguages = new ArrayList();
    private List disabledLanguages = new ArrayList();
    private List enabledLanguages = new ArrayList();
    private List referencingBeanList = new ArrayList();
    private SiteNodeVO siteNodeVO;
    private SiteNodeVersionVO siteNodeVersionVO;
    private String stay = null;
    private String dest = "";
    private VisualFormatter formatter = new VisualFormatter();

    public ViewSiteNodeAction() {
        this(new SiteNodeVO(), new SiteNodeVersionVO());
    }

    public ViewSiteNodeAction(SiteNodeVO siteNodeVO, SiteNodeVersionVO siteNodeVersionVO) {
        logger.info((Object)"Construction ViewSiteNodeAction");
        this.siteNodeVO = siteNodeVO;
        this.siteNodeVersionVO = siteNodeVersionVO;
    }

    protected void initialize(Integer siteNodeId) throws Exception {
        this.siteNodeVersionVO = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getACLatestActiveSiteNodeVersionVO(this.getInfoGluePrincipal(), siteNodeId);
        logger.info((Object)("siteNodeVersionVO:" + this.siteNodeVersionVO));
        this.siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(siteNodeId);
        this.repositoryId = this.siteNodeVO.getRepositoryId();
        if (this.siteNodeVO.getSiteNodeTypeDefinitionId() != null) {
            this.siteNodeTypeDefinitionVO = SiteNodeTypeDefinitionController.getController().getSiteNodeTypeDefinitionVOWithId(this.siteNodeVO.getSiteNodeTypeDefinitionId());
            this.availableServiceBindings = SiteNodeTypeDefinitionController.getController().getAvailableServiceBindingVOList(this.siteNodeVO.getSiteNodeTypeDefinitionId());
            this.serviceBindings = SiteNodeVersionController.getServiceBindningVOList(this.siteNodeVersionVO.getSiteNodeVersionId());
        }
    }

    protected void initialize(Integer siteNodeId, Database db) throws Exception {
        this.siteNodeVersionVO = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getACLatestActiveSiteNodeVersionVO(this.getInfoGluePrincipal(), siteNodeId, db);
        logger.info((Object)("siteNodeVersionVO:" + this.siteNodeVersionVO));
        this.siteNodeVO = SiteNodeController.getSiteNodeVOWithId(siteNodeId, db);
        if (this.siteNodeVO.getMetaInfoContentId() == null || this.siteNodeVO.getMetaInfoContentId() == -1) {
            boolean hadMetaInfo = false;
            AvailableServiceBindingVO availableServiceBindingVO = AvailableServiceBindingController.getController().getAvailableServiceBindingVOWithName("Meta information", db);
            Collection serviceBindings = SiteNodeVersionController.getServiceBindningList(this.siteNodeVersionVO.getId(), db, true);
            for (ServiceBinding serviceBinding : serviceBindings) {
                List boundContents;
                if (serviceBinding.getValueObject().getAvailableServiceBindingId().intValue() != availableServiceBindingVO.getAvailableServiceBindingId().intValue() || (boundContents = ContentController.getBoundContents(db, serviceBinding.getServiceBindingId())).size() <= 0) continue;
                ContentVO contentVO = (ContentVO)boundContents.get(0);
                hadMetaInfo = true;
                if (this.siteNodeVO.getMetaInfoContentId() != null && this.siteNodeVO.getMetaInfoContentId() != -1) break;
                SiteNodeController.getController().setMetaInfoContentId(this.siteNodeVO.getId(), contentVO.getContentId(), db);
                break;
            }
            if (!hadMetaInfo) {
                SiteNode siteNode = SiteNodeController.getController().getSiteNodeWithId(this.siteNodeVO.getId(), db);
                SiteNodeController.getController().createSiteNodeMetaInfoContent(db, siteNode, siteNode.getRepository().getId(), this.getInfoGluePrincipal(), null).getValueObject();
            }
        }
        this.repositoryId = this.siteNodeVO.getRepositoryId();
        if (this.siteNodeVO.getSiteNodeTypeDefinitionId() != null) {
            this.siteNodeTypeDefinitionVO = SiteNodeTypeDefinitionController.getController().getSiteNodeTypeDefinitionVOWithId(this.siteNodeVO.getSiteNodeTypeDefinitionId(), db);
            this.availableServiceBindings = SiteNodeTypeDefinitionController.getController().getAvailableServiceBindingVOList(this.siteNodeVO.getSiteNodeTypeDefinitionId(), db);
            if (this.siteNodeVersionVO != null) {
                this.serviceBindings = SiteNodeVersionController.getServiceBindningVOList(this.siteNodeVersionVO.getSiteNodeVersionId(), db);
            }
        }
    }

    protected void initializeSiteNodeCover(Integer siteNodeId) throws Exception {
        try {
            this.referenceBeanList = RegistryController.getController().getReferencingObjectsForSiteNode(siteNodeId, 100);
            this.referencingBeanList = RegistryController.getController().getReferencedObjects(SiteNodeVersion.class.getName(), this.siteNodeVersionVO.getSiteNodeVersionId().toString());
            logger.info((Object)("referenceBeanList:" + this.referenceBeanList.size()));
            logger.info((Object)("referencingBeanList:" + this.referencingBeanList.size()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.availableLanguages = LanguageController.getController().getLanguageVOList(this.repositoryId);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        String disabledLanguagesString = ps.getString("siteNode_" + siteNodeId + "_disabledLanguages");
        logger.info((Object)("disabledLanguagesString:" + disabledLanguagesString));
        if (disabledLanguagesString != null && !disabledLanguagesString.equalsIgnoreCase("")) {
            String[] disabledLanguagesStringArray = disabledLanguagesString.split(",");
            int i = 0;
            while (i < disabledLanguagesStringArray.length) {
                try {
                    LanguageVO languageVO = LanguageController.getController().getLanguageVOWithId(new Integer(disabledLanguagesStringArray[i]));
                    logger.info((Object)("Adding languageVO to disabledLanguages:" + languageVO.getName()));
                    this.disabledLanguages.add(languageVO);
                }
                catch (Exception e) {
                    logger.warn((Object)("An error occurred when we tried to get disabled language:" + e.getMessage()), (Throwable)e);
                }
                ++i;
            }
        }
        String enabledLanguagesString = ps.getString("siteNode_" + siteNodeId + "_enabledLanguages");
        logger.info((Object)("enabledLanguagesString:" + enabledLanguagesString));
        if (enabledLanguagesString != null && !enabledLanguagesString.equalsIgnoreCase("")) {
            String[] enabledLanguagesStringArray = enabledLanguagesString.split(",");
            int i = 0;
            while (i < enabledLanguagesStringArray.length) {
                try {
                    LanguageVO languageVO = LanguageController.getController().getLanguageVOWithId(new Integer(enabledLanguagesStringArray[i]));
                    logger.info((Object)("Adding languageVO to enabledLanguages:" + languageVO.getName()));
                    this.enabledLanguages.add(languageVO);
                }
                catch (Exception e) {
                    logger.warn((Object)("An error occurred when we tried to get enabled language:" + e.getMessage()), (Throwable)e);
                }
                ++i;
            }
        }
    }

    protected void initializeSiteNodeCover(Integer siteNodeId, Database db) throws Exception {
        try {
            this.referenceBeanList = RegistryController.getController().getReferencingObjectsForSiteNode(siteNodeId, 100, db);
            this.referencingBeanList = RegistryController.getController().getReferencedObjects(SiteNodeVersion.class.getName(), this.siteNodeVersionVO.getSiteNodeVersionId().toString(), db);
            logger.info((Object)("referenceBeanList:" + this.referenceBeanList.size()));
            logger.info((Object)("referencingBeanList:" + this.referencingBeanList.size()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.availableLanguages = LanguageController.getController().getLanguageVOList(this.repositoryId, db);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        String disabledLanguagesString = ps.getString("siteNode_" + siteNodeId + "_disabledLanguages");
        logger.info((Object)("disabledLanguagesString:" + disabledLanguagesString));
        if (disabledLanguagesString != null && !disabledLanguagesString.equalsIgnoreCase("")) {
            String[] disabledLanguagesStringArray = disabledLanguagesString.split(",");
            int i = 0;
            while (i < disabledLanguagesStringArray.length) {
                try {
                    LanguageVO languageVO = LanguageController.getController().getLanguageVOWithId(new Integer(disabledLanguagesStringArray[i]), db);
                    logger.info((Object)("Adding languageVO to disabledLanguages:" + languageVO.getName()));
                    this.disabledLanguages.add(languageVO);
                }
                catch (Exception e) {
                    logger.warn((Object)("An error occurred when we tried to get disabled language:" + e.getMessage()), (Throwable)e);
                }
                ++i;
            }
        }
        String enabledLanguagesString = ps.getString("siteNode_" + siteNodeId + "_enabledLanguages");
        logger.info((Object)("enabledLanguagesString:" + enabledLanguagesString));
        if (enabledLanguagesString != null && !enabledLanguagesString.equalsIgnoreCase("")) {
            String[] enabledLanguagesStringArray = enabledLanguagesString.split(",");
            int i = 0;
            while (i < enabledLanguagesStringArray.length) {
                try {
                    LanguageVO languageVO = LanguageController.getController().getLanguageVOWithId(new Integer(enabledLanguagesStringArray[i]), db);
                    logger.info((Object)("Adding languageVO to enabledLanguages:" + languageVO.getName()));
                    this.enabledLanguages.add(languageVO);
                }
                catch (Exception e) {
                    logger.warn((Object)("An error occurred when we tried to get enabled language:" + e.getMessage()), (Throwable)e);
                }
                ++i;
            }
        }
    }

    public String doExecute() throws Exception {
        String result = "success";
        Database db = CastorDatabaseService.getDatabase();
        this.beginTransaction(db);
        try {
            block12: {
                block8: {
                    block9: {
                        ContentVersionVO metaInfoContentVersionVO;
                        Integer metaInfoContentId;
                        LanguageVO masterLanguageVO;
                        boolean isMetaInfoInWorkingState;
                        block10: {
                            Integer metaInfoAvailableServiceBindingId;
                            Integer languageId;
                            block11: {
                                if (this.getSiteNodeId() == null) break block8;
                                this.initialize(this.getSiteNodeId(), db);
                                if (this.stay != null && this.stay.equalsIgnoreCase("true") || this.siteNodeVO.getSiteNodeTypeDefinitionId() == null || !this.getShowComponentsFirst().equalsIgnoreCase("true")) break block9;
                                isMetaInfoInWorkingState = false;
                                masterLanguageVO = LanguageController.getController().getMasterLanguage(this.repositoryId, db);
                                languageId = masterLanguageVO.getLanguageId();
                                AvailableServiceBindingVO availableServiceBindingVO = AvailableServiceBindingController.getController().getAvailableServiceBindingVOWithName("Meta information");
                                metaInfoAvailableServiceBindingId = null;
                                if (availableServiceBindingVO != null) {
                                    metaInfoAvailableServiceBindingId = availableServiceBindingVO.getAvailableServiceBindingId();
                                }
                                metaInfoContentId = null;
                                metaInfoContentVersionVO = null;
                                if (this.siteNodeVersionVO == null) break block10;
                                if (this.siteNodeVO == null || this.siteNodeVO.getMetaInfoContentId() == null) break block11;
                                metaInfoContentId = this.siteNodeVO.getMetaInfoContentId();
                                metaInfoContentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(metaInfoContentId, languageId, db);
                                if (metaInfoContentVersionVO == null || !metaInfoContentVersionVO.getStateId().equals(ContentVersionVO.WORKING_STATE)) break block10;
                                isMetaInfoInWorkingState = true;
                                break block10;
                            }
                            List serviceBindings = SiteNodeVersionController.getServiceBindningVOList(this.siteNodeVersionVO.getId(), db);
                            for (ServiceBindingVO serviceBindingVO : serviceBindings) {
                                List boundContents;
                                if (serviceBindingVO.getAvailableServiceBindingId().intValue() != metaInfoAvailableServiceBindingId.intValue() || (boundContents = ContentController.getInTransactionBoundContents(db, serviceBindingVO.getServiceBindingId())).size() <= 0) continue;
                                ContentVO contentVO = (ContentVO)boundContents.get(0);
                                metaInfoContentId = contentVO.getId();
                                metaInfoContentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), languageId, db);
                                if (metaInfoContentVersionVO == null || !metaInfoContentVersionVO.getStateId().equals(ContentVersionVO.WORKING_STATE)) break;
                                isMetaInfoInWorkingState = true;
                                break;
                            }
                        }
                        if (this.siteNodeVO.getMetaInfoContentId() == null || this.siteNodeVO.getMetaInfoContentId() == -1) {
                            SiteNodeController.getController().setMetaInfoContentId(this.siteNodeVO.getId(), metaInfoContentId, db);
                        }
                        if (this.siteNodeVersionVO != null && this.siteNodeVersionVO.getStateId().equals(SiteNodeVersionVO.WORKING_STATE) && !isMetaInfoInWorkingState) {
                            if (metaInfoContentVersionVO != null) {
                                metaInfoContentVersionVO = ContentStateController.changeState(metaInfoContentVersionVO.getId(), ContentVersionVO.WORKING_STATE, "Automatic", true, null, this.getInfoGluePrincipal(), null, db, new ArrayList()).getValueObject();
                            }
                            isMetaInfoInWorkingState = true;
                        }
                        String url = String.valueOf(this.getComponentRendererUrl()) + this.getComponentRendererAction() + "?siteNodeId=" + this.getSiteNodeId() + "&languageId=" + masterLanguageVO.getId() + "&contentId=-1&cmsUserName=" + this.formatter.encodeURI(this.getInfoGluePrincipal().getName());
                        url = this.getResponse().encodeURL(url);
                        this.getResponse().sendRedirect(url);
                        result = "none";
                        break block12;
                    }
                    this.initializeSiteNodeCover(this.getSiteNodeId(), db);
                    result = "success";
                    break block12;
                }
                result = "blank";
            }
            this.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            this.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return result;
    }

    public String doChangeState() throws Exception {
        logger.info((Object)("Gonna change state with comment:" + this.siteNodeVersionVO.getVersionComment()));
        Database db = CastorDatabaseService.getDatabase();
        this.beginTransaction(db);
        try {
            SiteNodeVersionController.getController().updateStateId(this.siteNodeVersionVO.getSiteNodeVersionId(), this.getStateId(), this.siteNodeVersionVO.getVersionComment(), this.getInfoGluePrincipal(), this.getSiteNodeId());
            this.initialize(this.getSiteNodeId(), db);
            this.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return "success";
    }

    public String doCommentVersion() throws Exception {
        logger.info((Object)"Gonna show the comment-view");
        return "commentVersion";
    }

    public Integer getSiteNodeId() {
        return this.siteNodeVO.getSiteNodeId();
    }

    public boolean getIsSiteNodeTypeDefinitionAssigned() {
        return this.siteNodeVO.getSiteNodeTypeDefinitionId() != null;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeVO.setSiteNodeId(siteNodeId);
    }

    public Integer getRepositoryId() {
        if (this.repositoryId != null) {
            return this.repositoryId;
        }
        return this.siteNodeVO.getRepositoryId();
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getUnrefreshedSiteNodeId() {
        return this.unrefreshedSiteNodeId;
    }

    public void setUnrefreshedSiteNodeId(Integer unrefreshedSiteNodeId) {
        this.unrefreshedSiteNodeId = unrefreshedSiteNodeId;
    }

    public Integer getChangeTypeId() {
        return this.changeTypeId;
    }

    public void setChangeTypeId(Integer changeTypeId) {
        this.changeTypeId = changeTypeId;
    }

    public String getName() {
        return this.siteNodeVO.getName();
    }

    public String getPublishDateTime() {
        return new VisualFormatter().formatDate(this.siteNodeVO.getPublishDateTime(), "yyyy-MM-dd HH:mm");
    }

    public String getExpireDateTime() {
        return new VisualFormatter().formatDate(this.siteNodeVO.getExpireDateTime(), "yyyy-MM-dd HH:mm");
    }

    public long getPublishDateTimeAsLong() {
        return this.siteNodeVO.getPublishDateTime().getTime();
    }

    public long getExpireDateTimeAsLong() {
        return this.siteNodeVO.getExpireDateTime().getTime();
    }

    public Boolean getIsBranch() {
        return this.siteNodeVO.getIsBranch();
    }

    public String getContentType() {
        return this.siteNodeVersionVO.getContentType();
    }

    public void setContentType(String contentType) {
        this.siteNodeVersionVO.setContentType(contentType);
    }

    public String getPageCacheKey() {
        return this.siteNodeVersionVO.getPageCacheKey();
    }

    public void setPageCacheKey(String pageCacheKey) {
        this.siteNodeVersionVO.setPageCacheKey(pageCacheKey);
    }

    public String getPageCacheTimeout() {
        return this.siteNodeVersionVO.getPageCacheTimeout();
    }

    public void setPageCacheTimeout(String pageCacheTimeout) {
        this.siteNodeVersionVO.setPageCacheTimeout(pageCacheTimeout);
    }

    public Integer getDisableEditOnSight() {
        return this.siteNodeVersionVO.getDisableEditOnSight();
    }

    public void setDisableEditOnSight(Integer disableEditOnSight) {
        this.siteNodeVersionVO.setDisableEditOnSight(disableEditOnSight);
    }

    public Integer getDisableForceIdentityCheck() {
        return this.siteNodeVersionVO.getDisableForceIdentityCheck();
    }

    public void setDisableForceIdentityCheck(Integer disableForceIdentityCheck) {
        this.siteNodeVersionVO.setDisableForceIdentityCheck(disableForceIdentityCheck);
    }

    public Integer getDisableLanguages() {
        return this.siteNodeVersionVO.getDisableLanguages();
    }

    public void setDisableLanguages(Integer disableLanguages) {
        this.siteNodeVersionVO.setDisableLanguages(disableLanguages);
    }

    public Integer getDisablePageCache() {
        return this.siteNodeVersionVO.getDisablePageCache();
    }

    public void setDisablePageCache(Integer disablePageCache) {
        this.siteNodeVersionVO.setDisablePageCache(disablePageCache);
    }

    public Integer getIsProtected() {
        return this.siteNodeVersionVO.getIsProtected();
    }

    public void setIsProtected(Integer isProtected) {
        this.siteNodeVersionVO.setIsProtected(isProtected);
    }

    public void setStateId(Integer stateId) {
        this.siteNodeVersionVO.setStateId(stateId);
    }

    public Integer getStateId() {
        return this.siteNodeVersionVO.getStateId();
    }

    public SiteNodeVersionVO getSiteNodeVersion() {
        return this.siteNodeVersionVO;
    }

    public Integer getSiteNodeVersionId() {
        return this.siteNodeVersionVO.getSiteNodeVersionId();
    }

    public void setSiteNodeVersionId(Integer siteNodeVersionId) {
        this.siteNodeVersionVO.setSiteNodeVersionId(siteNodeVersionId);
    }

    public void setVersionComment(String versionComment) {
        this.siteNodeVersionVO.setVersionComment(versionComment);
    }

    public String getVersionComment() {
        return this.siteNodeVersionVO.getVersionComment();
    }

    public SiteNodeTypeDefinitionVO getSiteNodeTypeDefinition() {
        return this.siteNodeTypeDefinitionVO;
    }

    public List getAvailableServiceBindings() {
        return this.availableServiceBindings;
    }

    public String getShowComponentsFirst() {
        return CmsPropertyHandler.getShowComponentsFirst();
    }

    public List getSortedAvailableServiceBindings() {
        ArrayList<AvailableServiceBindingVO> sortedAvailableServiceBindings = new ArrayList<AvailableServiceBindingVO>();
        for (AvailableServiceBindingVO availableServiceBinding : this.availableServiceBindings) {
            int index = 0;
            for (AvailableServiceBindingVO sortedAvailableServiceBinding : sortedAvailableServiceBindings) {
                String currentAttribute = availableServiceBinding.getName();
                String sortedAttribute = sortedAvailableServiceBinding.getName();
                if (currentAttribute != null && sortedAttribute != null && currentAttribute.compareTo(sortedAttribute) < 0) break;
                ++index;
            }
            sortedAvailableServiceBindings.add(index, availableServiceBinding);
        }
        return sortedAvailableServiceBindings;
    }

    public List getSortedAvailableContentServiceBindings() {
        ArrayList<AvailableServiceBindingVO> sortedAvailableContentServiceBindings = new ArrayList<AvailableServiceBindingVO>();
        for (AvailableServiceBindingVO sortedAvailableServiceBinding : this.getSortedAvailableServiceBindings()) {
            if (sortedAvailableServiceBinding.getVisualizationAction().indexOf("Structure") != -1) continue;
            sortedAvailableContentServiceBindings.add(sortedAvailableServiceBinding);
        }
        return sortedAvailableContentServiceBindings;
    }

    public List getSortedAvailableStructureServiceBindings() {
        ArrayList<AvailableServiceBindingVO> sortedAvailableStructureServiceBindings = new ArrayList<AvailableServiceBindingVO>();
        for (AvailableServiceBindingVO sortedAvailableServiceBinding : this.getSortedAvailableServiceBindings()) {
            if (sortedAvailableServiceBinding.getVisualizationAction().indexOf("Structure") <= -1) continue;
            sortedAvailableStructureServiceBindings.add(sortedAvailableServiceBinding);
        }
        return sortedAvailableStructureServiceBindings;
    }

    public List getServiceBindings() {
        return this.serviceBindings;
    }

    public String getStateDescription(Integer siteNodeId, Integer languageId) {
        String stateDescription = "Not created";
        return stateDescription;
    }

    public String getQualifyerDescription(Integer serviceBindingId) throws Exception {
        String qualifyerDescription = "";
        List qualifyers = ServiceBindingController.getQualifyerVOList(serviceBindingId);
        for (QualifyerVO qualifyerVO : qualifyers) {
            if (!qualifyerDescription.equalsIgnoreCase("")) {
                qualifyerDescription = String.valueOf(qualifyerDescription) + ",";
            }
            qualifyerDescription = String.valueOf(qualifyerDescription) + qualifyerVO.getName() + "=" + qualifyerVO.getValue();
        }
        return qualifyerDescription;
    }

    public List getListPreparedQualifyers(Integer serviceBindingId) throws Exception {
        List qualifyers = ServiceBindingController.getQualifyerVOList(serviceBindingId);
        for (QualifyerVO qualifyerVO : qualifyers) {
            if (!qualifyerVO.getName().equalsIgnoreCase("contentid")) continue;
            try {
                ContentVO contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), new Integer(qualifyerVO.getValue()));
                qualifyerVO.setPath(contentVO.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return qualifyers;
    }

    public List getSiteNodeTypeDefinitions() throws Exception {
        return SiteNodeTypeDefinitionController.getController().getSortedSiteNodeTypeDefinitionVOList();
    }

    public EventVO getSiteNodeVersionEvent(Integer siteNodeVersionId) {
        EventVO eventVO = null;
        try {
            List events = EventController.getEventVOListForEntity(SiteNodeVersion.class.getName(), siteNodeVersionId);
            if (events != null && events.size() > 0) {
                eventVO = (EventVO)events.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get any events for this version:" + e.getMessage()), (Throwable)e);
        }
        return eventVO;
    }

    public EventVO getSiteNodeEvent(Integer siteNodeId) {
        EventVO eventVO = null;
        try {
            List events = EventController.getEventVOListForEntity(SiteNode.class.getName(), siteNodeId);
            if (events != null && events.size() > 0) {
                eventVO = (EventVO)events.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get any events for this siteNode:" + e.getMessage()), (Throwable)e);
        }
        return eventVO;
    }

    public SiteNodeVersionVO getSiteNodeVersionVO() {
        return this.siteNodeVersionVO;
    }

    public String getStay() {
        return this.stay;
    }

    public void setStay(String stay) {
        this.stay = stay;
    }

    public String getDest() {
        return this.dest;
    }

    public List getReferenceBeanList() {
        return this.referenceBeanList;
    }

    public List getAvailableLanguages() {
        return this.availableLanguages;
    }

    public List getDisabledLanguages() {
        return this.disabledLanguages;
    }

    public List getEnabledLanguages() {
        return this.enabledLanguages;
    }

    public List getReferencingBeanList() {
        return this.referencingBeanList;
    }
}

