/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AvailableServiceBindingController;
import org.infoglue.cms.controllers.kernel.impl.simple.QualifyerController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.management.ServiceDefinitionVO;
import org.infoglue.cms.entities.structure.QualifyerVO;
import org.infoglue.cms.entities.structure.ServiceBindingVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class ViewMultiSelectStructureTreeForServiceBindingAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewMultiSelectStructureTreeForServiceBindingAction.class.getName());
    private static final long serialVersionUID = 1L;
    private Integer siteNodeVersionId;
    private Integer repositoryId;
    private Integer availableServiceBindingId;
    private Integer serviceDefinitionId;
    private Integer bindingTypeId;
    private ConstraintExceptionBuffer ceb;
    private Integer siteNodeId;
    private ServiceDefinitionVO singleServiceDefinitionVO;
    private String qualifyerXML;
    private String tree;
    private String exp = "";
    private List repositories;
    private String qualifyerString = "";
    private List qualifyers = null;
    private Integer entityId;
    private Integer direction;
    private Integer oldSortOrder;
    private Integer serviceBindingId;
    private Integer requestedPosition;
    private ServiceBindingVO serviceBindingVO = null;

    public ViewMultiSelectStructureTreeForServiceBindingAction() {
        this(new ServiceBindingVO());
    }

    public ViewMultiSelectStructureTreeForServiceBindingAction(ServiceBindingVO serviceBindingVO) {
        this.serviceBindingVO = serviceBindingVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public void setSiteNodeVersionId(Integer siteNodeVersionId) {
        this.siteNodeVersionId = siteNodeVersionId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setAvailableServiceBindingId(Integer availableServiceBindingId) {
        this.availableServiceBindingId = availableServiceBindingId;
    }

    public void setServiceDefinitionId(Integer serviceDefinitionId) {
        this.serviceDefinitionId = serviceDefinitionId;
    }

    public void setBindingTypeId(Integer bindingTypeId) {
        this.serviceBindingVO.setBindingTypeId(bindingTypeId);
    }

    public void setPath(String path) {
        this.serviceBindingVO.setPath(path);
    }

    public Integer getSiteNodeVersionId() {
        return this.siteNodeVersionId;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public Integer getAvailableServiceBindingId() {
        return this.availableServiceBindingId;
    }

    public Integer getServiceDefinitionId() {
        return this.singleServiceDefinitionVO.getServiceDefinitionId();
    }

    public Integer getBindingTypeId() {
        return this.bindingTypeId;
    }

    public ServiceDefinitionVO getSingleServiceDefinitionVO() {
        return this.singleServiceDefinitionVO;
    }

    public void setQualifyerXML(String qualifyerXML) {
        this.qualifyerXML = qualifyerXML;
    }

    public String getQualifyerXML() {
        return this.qualifyerXML;
    }

    public void setQualifyerString(String qualifyerString) {
        this.qualifyerString = qualifyerString;
    }

    public void setEntityId(Integer entityId) {
        this.entityId = entityId;
    }

    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    public void setOldSortOrder(Integer oldSortOrder) {
        this.oldSortOrder = oldSortOrder;
    }

    public String getQualifyerString() {
        return this.qualifyerString;
    }

    public List getQualifyers() {
        return this.qualifyers;
    }

    public void setServiceBindingId(Integer serviceBindingId) {
        this.serviceBindingId = serviceBindingId;
    }

    public Integer getServiceBindingId() {
        return this.serviceBindingId;
    }

    public String getTree() {
        return this.tree;
    }

    public void setTree(String string) {
        this.tree = string;
    }

    public String getCurrentAction() {
        return "ViewMultiSelectStructureTreeForServiceBinding.action";
    }

    public List getRepositories() {
        return this.repositories;
    }

    public String getQualifyerPath(String entityId) {
        try {
            return SiteNodeController.getController().getSiteNodeVOWithId(new Integer(entityId)).getName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private void initialize() throws Exception {
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), true);
        List serviceDefinitions = AvailableServiceBindingController.getController().getServiceDefinitionVOList(this.availableServiceBindingId);
        if (serviceDefinitions.size() == 1) {
            this.singleServiceDefinitionVO = (ServiceDefinitionVO)serviceDefinitions.get(0);
        }
    }

    public String doExecute() throws Exception {
        List serviceDefinitions;
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), true);
        if (this.repositoryId == null) {
            this.repositoryId = RepositoryController.getController().getFirstRepositoryVO().getRepositoryId();
        }
        if ((serviceDefinitions = AvailableServiceBindingController.getController().getServiceDefinitionVOList(this.availableServiceBindingId)) == null || serviceDefinitions.size() == 0) {
            return "error";
        }
        if (serviceDefinitions.size() == 1) {
            this.singleServiceDefinitionVO = (ServiceDefinitionVO)serviceDefinitions.get(0);
            if (this.serviceBindingId != null) {
                this.qualifyers = QualifyerController.getBindingQualifyers(this.serviceBindingId);
            }
            return "success";
        }
        return "chooseService";
    }

    public String doChangeRepository() throws Exception {
        this.qualifyers = this.parseQualifyers(this.qualifyerString);
        this.initialize();
        return "success";
    }

    public String doChangeTree() throws Exception {
        this.qualifyers = this.parseQualifyers(this.qualifyerString);
        this.initialize();
        return "success";
    }

    public String doAddQualifyer() throws Exception {
        this.qualifyerString = this.qualifyerString != null && !this.qualifyerString.equals("") ? String.valueOf(this.qualifyerString) + "," + this.entityId : String.valueOf(this.qualifyerString) + this.entityId;
        this.qualifyers = this.parseQualifyers(this.qualifyerString);
        this.initialize();
        return "success";
    }

    public String doAddQualifyerAtPosition() throws Exception {
        if (this.qualifyerString == null || this.qualifyerString.equals("") || this.requestedPosition == null) {
            this.qualifyerString = String.valueOf(this.qualifyerString) + "," + this.entityId;
        } else {
            StringBuffer buf = new StringBuffer();
            StringTokenizer qs = new StringTokenizer(this.qualifyerString, ",");
            int i = 0;
            while (qs.hasMoreTokens()) {
                String qToken;
                if (i++ == this.requestedPosition) {
                    buf.append(this.entityId + ",");
                }
                if ((qToken = qs.nextToken()).length() <= 0) continue;
                buf.append(String.valueOf(qToken) + ",");
            }
            this.qualifyerString = buf.toString();
        }
        this.qualifyers = this.parseQualifyers(this.qualifyerString);
        this.initialize();
        return "success";
    }

    public String doMoveQualifyerToPosition() throws Exception {
        this.entityId = new Integer(((QualifyerVO)this.parseQualifyers(this.qualifyerString).get(this.oldSortOrder)).getValue());
        this.qualifyers = this.parseQualifyers(this.qualifyerString);
        this.qualifyers = this.deleteQualifyer(this.oldSortOrder, this.qualifyers);
        this.qualifyerString = this.parseQualifyers(this.qualifyers);
        if (this.requestedPosition == -1) {
            return this.doAddQualifyer();
        }
        if (this.oldSortOrder < this.requestedPosition) {
            this.requestedPosition = new Integer(this.requestedPosition - 1);
        }
        return this.doAddQualifyerAtPosition();
    }

    public String doMoveQualifyer() throws Exception {
        logger.info((Object)"------------------------------------->");
        this.qualifyers = this.parseQualifyers(this.qualifyerString);
        this.qualifyers = this.moveQualifyer(this.direction, this.oldSortOrder, this.qualifyers);
        this.initialize();
        return "success";
    }

    public String doDeleteQualifyer() throws Exception {
        logger.info((Object)"------------------------------------->");
        this.qualifyers = this.parseQualifyers(this.qualifyerString);
        this.qualifyers = this.deleteQualifyer(this.oldSortOrder, this.qualifyers);
        this.initialize();
        return "success";
    }

    private List parseQualifyers(String qualifyerString) {
        ArrayList<QualifyerVO> qualifyers = new ArrayList<QualifyerVO>();
        StringTokenizer st = new StringTokenizer(qualifyerString, ",");
        int i = 0;
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            QualifyerVO qualifyerVO = new QualifyerVO();
            qualifyerVO.setName("siteNodeId");
            qualifyerVO.setValue(next);
            qualifyerVO.setSortOrder(new Integer(i));
            qualifyers.add(qualifyerVO);
            ++i;
        }
        return qualifyers;
    }

    private String parseQualifyers(List qualifyers) {
        StringBuffer buf = new StringBuffer();
        for (QualifyerVO q : qualifyers) {
            buf.append(String.valueOf(q.getValue()) + ",");
        }
        return buf.toString();
    }

    private List moveQualifyer(Integer direction, Integer oldSortOrder, List qualifyers) {
        logger.info((Object)("-------------------------------------> About to move the qualifyer in direction " + direction + " and old sortOrder was " + oldSortOrder));
        ArrayList<QualifyerVO> newQualifyers = new ArrayList<QualifyerVO>();
        Iterator iterator = qualifyers.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            QualifyerVO qualifyer = (QualifyerVO)iterator.next();
            logger.info((Object)("Found qualifyer " + qualifyer.getValue() + ":" + qualifyer.getSortOrder()));
            if (qualifyer.getSortOrder().equals(oldSortOrder) && direction == 0) {
                logger.info((Object)"About to move it down...");
                if (iterator.hasNext()) {
                    QualifyerVO nextQualifyer = (QualifyerVO)iterator.next();
                    logger.info((Object)("nextQualifyer " + nextQualifyer.getValue() + ":" + nextQualifyer.getSortOrder()));
                    nextQualifyer.setSortOrder(qualifyer.getSortOrder());
                    logger.info((Object)("Set the nextQualifyer sortOrder to " + qualifyer.getSortOrder()));
                    qualifyer.setSortOrder(new Integer(qualifyer.getSortOrder() + 1));
                    logger.info((Object)("Set the qualifyer sortOrder to " + qualifyer.getSortOrder()));
                    newQualifyers.add(nextQualifyer);
                    newQualifyers.add(qualifyer);
                } else {
                    newQualifyers.add(qualifyer);
                }
            } else if (qualifyer.getSortOrder().equals(oldSortOrder) && direction == 1) {
                logger.info((Object)"About to move it up...");
                if (i > 0) {
                    QualifyerVO previousQualifyer = (QualifyerVO)newQualifyers.get(i - 1);
                    logger.info((Object)("Previous qualifyer " + previousQualifyer.getValue() + ":" + previousQualifyer.getSortOrder()));
                    previousQualifyer.setSortOrder(qualifyer.getSortOrder());
                    logger.info((Object)("Set the previous qualifyer sortOrder to " + qualifyer.getSortOrder()));
                    qualifyer.setSortOrder(new Integer(qualifyer.getSortOrder() - 1));
                    logger.info((Object)("Set the qualifyer sortOrder to " + qualifyer.getSortOrder()));
                    newQualifyers.remove(qualifyer);
                    newQualifyers.add(i - 1, qualifyer);
                } else {
                    newQualifyers.add(qualifyer);
                }
            } else {
                newQualifyers.add(qualifyer);
            }
            ++i;
        }
        return newQualifyers;
    }

    private List deleteQualifyer(Integer oldSortOrder, List qualifyers) {
        ArrayList<QualifyerVO> newQualifyers = new ArrayList<QualifyerVO>();
        Iterator iterator = qualifyers.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            QualifyerVO qualifyer = (QualifyerVO)iterator.next();
            logger.info((Object)("-------------------------------->Found qualifyer " + qualifyer.getValue() + ":" + qualifyer.getSortOrder()));
            if (qualifyer.getSortOrder().equals(oldSortOrder)) continue;
            logger.info((Object)("qualifyer:" + qualifyer.getSortOrder()));
            logger.info((Object)("qualifyer:" + qualifyer.getValue()));
            logger.info((Object)("Adding this qualifyer again as it did not match the delete-one:" + oldSortOrder));
            qualifyer.setSortOrder(new Integer(i));
            newQualifyers.add(qualifyer);
            ++i;
        }
        return newQualifyers;
    }

    public String getExp() {
        return this.exp;
    }

    public void setExp(String string) {
        this.exp = string;
    }

    public Integer getRequestedPosition() {
        return this.requestedPosition;
    }

    public void setRequestedPosition(Integer integer) {
        this.requestedPosition = integer;
    }
}

