/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.actions;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.applications.databeans.LinkBean;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionControllerProxy;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;
import org.infoglue.cms.util.sorters.ReflectionComparator;

public class ViewListSiteNodeVersionAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewListSiteNodeVersionAction.class.getName());
    private static final long serialVersionUID = 1L;
    private Set siteNodeVersionVOList = new TreeSet(Collections.reverseOrder(new ReflectionComparator("modifiedDateTime")));
    private Set contentVersionVOList = new TreeSet(Collections.reverseOrder(new ReflectionComparator("modifiedDateTime")));
    private Integer siteNodeVersionId;
    private Integer siteNodeId;
    private Integer repositoryId;
    private String returnAddress;
    private boolean recurseSiteNodes = true;
    private String originalAddress;
    private String userSessionKey;

    protected String doExecute() throws Exception {
        SiteNodeVersionVO siteNodeVersionVO;
        logger.info((Object)("siteNodeId:" + this.siteNodeId));
        logger.info((Object)("siteNodeVersionId:" + this.siteNodeVersionId));
        if (this.siteNodeVersionId == null && (siteNodeVersionVO = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getACLatestActiveSiteNodeVersionVO(this.getInfoGluePrincipal(), this.siteNodeId)) != null) {
            this.siteNodeVersionId = siteNodeVersionVO.getId();
        }
        if (this.siteNodeVersionId != null) {
            AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
            Integer protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(this.siteNodeVersionId);
            if (protectedSiteNodeVersionId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "SiteNodeVersion.SubmitToPublish", protectedSiteNodeVersionId.toString())) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeVersionId", "1005"));
            }
            ceb.throwIfNotEmpty();
            SiteNodeVersionController.getController().getSiteNodeAndAffectedItemsRecursive(this.siteNodeId, SiteNodeVersionVO.WORKING_STATE, this.siteNodeVersionVOList, this.contentVersionVOList, false, this.recurseSiteNodes, this.getInfoGluePrincipal());
        }
        return "success";
    }

    public String doV3() throws Exception {
        this.doExecute();
        this.userSessionKey = "" + System.currentTimeMillis();
        this.setActionMessage(this.userSessionKey, "Publiceringen genomf\u00f6rdes korrekt. Forts\u00e4tt genom att v\u00e4lja n\u00e5got av alternativen nedan.");
        this.addActionLink(this.userSessionKey, new LinkBean("currentPageUrl", "Tillbaka till sidan du utgick fr\u00e5n", "Klicka h\u00e4r om du vill komma tillbaka till sidan d\u00e4r du startade fl\u00f6det.", "Klicka h\u00e4r om du vill komma tillbaka till sidan d\u00e4r du startade fl\u00f6det.", this.originalAddress, false, ""));
        return "successV3";
    }

    public Set getSiteNodeVersions() {
        return this.siteNodeVersionVOList;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public Integer getSiteNodeVersionId() {
        return this.siteNodeVersionId;
    }

    public void setSiteNodeVersionId(Integer siteNodeVersionId) {
        this.siteNodeVersionId = siteNodeVersionId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Set getContentVersionVOList() {
        return this.contentVersionVOList;
    }

    public Set getSiteNodeVersionVOList() {
        return this.siteNodeVersionVOList;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }

    public boolean isRecurseSiteNodes() {
        return this.recurseSiteNodes;
    }

    public void setRecurseSiteNodes(boolean recurseSiteNodes) {
        this.recurseSiteNodes = recurseSiteNodes;
    }

    public String getUserSessionKey() {
        return this.userSessionKey;
    }

    public void setUserSessionKey(String userSessionKey) {
        this.userSessionKey = userSessionKey;
    }

    public String getOriginalAddress() {
        return this.originalAddress;
    }

    public void setOriginalAddress(String originalAddress) {
        this.originalAddress = originalAddress;
    }
}

