/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.actions;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeStateController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.management.ContentTypeDefinition;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.ServiceDefinitionVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class ViewAndCreateContentForServiceBindingAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewAndCreateContentForServiceBindingAction.class.getName());
    private Integer siteNodeVersionId;
    private Integer repositoryId;
    private Integer serviceDefinitionId;
    private Integer bindingTypeId;
    private ConstraintExceptionBuffer ceb;
    private Integer siteNodeId;
    private ServiceDefinitionVO singleServiceDefinitionVO;
    private String tree;
    private List repositories;
    private ContentVO contentVO = new ContentVO();
    private Integer languageId = null;
    private Integer metaInfoContentTypeDefinitionId = null;
    private String changeStateToWorking = null;

    public void setSiteNodeVersionId(Integer siteNodeVersionId) {
        this.siteNodeVersionId = siteNodeVersionId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setServiceDefinitionId(Integer serviceDefinitionId) {
        this.serviceDefinitionId = serviceDefinitionId;
    }

    public Integer getSiteNodeVersionId() {
        return this.siteNodeVersionId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public Integer getServiceDefinitionId() {
        return this.singleServiceDefinitionVO.getServiceDefinitionId();
    }

    public Integer getBindingTypeId() {
        return this.bindingTypeId;
    }

    public ServiceDefinitionVO getSingleServiceDefinitionVO() {
        return this.singleServiceDefinitionVO;
    }

    public String getTree() {
        return this.tree;
    }

    public void setTree(String string) {
        this.tree = string;
    }

    public String getCurrentAction() {
        return "ViewAndCreateContentForServiceBinding.action";
    }

    public String doExecute() throws Exception {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        this.beginTransaction(db);
        try {
            SiteNodeVersion siteNodeVersion;
            Language masterLanguage = LanguageController.getController().getMasterLanguage(db, this.repositoryId);
            this.languageId = masterLanguage.getLanguageId();
            ContentTypeDefinition contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionWithName("Meta info", db);
            this.metaInfoContentTypeDefinitionId = contentTypeDefinition.getId();
            SiteNode siteNode = SiteNodeController.getController().getSiteNodeWithId(this.siteNodeId, db);
            if (this.changeStateToWorking != null && this.changeStateToWorking.equalsIgnoreCase("true") && !(siteNodeVersion = SiteNodeVersionController.getController().getLatestActiveSiteNodeVersion(db, this.siteNodeId)).getStateId().equals(SiteNodeVersionVO.WORKING_STATE)) {
                ArrayList events = new ArrayList();
                SiteNodeStateController.getController().changeState(siteNodeVersion.getId(), SiteNodeVersionVO.WORKING_STATE, "Auto", true, this.getInfoGluePrincipal(), this.siteNodeId, db, events);
            }
            Content metaInfoContent = null;
            if (siteNode.getMetaInfoContentId() != null && siteNode.getMetaInfoContentId() > -1) {
                metaInfoContent = ContentController.getContentController().getContentWithId(siteNode.getMetaInfoContentId(), db);
            }
            if (metaInfoContent == null) {
                siteNode.setMetaInfoContentId(null);
                this.contentVO = SiteNodeController.getController().createSiteNodeMetaInfoContent(db, siteNode, this.repositoryId, this.getInfoGluePrincipal(), null).getValueObject();
                siteNode.setMetaInfoContentId(this.contentVO.getId());
                logger.error((Object)"The site node must have a meta information bound. We tried to recreate it. Old info was lost.");
            } else {
                this.contentVO = metaInfoContent.getValueObject();
            }
            this.languageId = this.getInitialLanguageVO(this.contentVO.getId(), db).getId();
            this.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return "success";
    }

    public LanguageVO getInitialLanguageVO(Integer contentId, Database db) throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        String initialLanguageId = ps.getString("content_" + contentId + "_initialLanguageId");
        ContentController.getContentController();
        ContentVO parentContentVO = ContentController.getParentContent(contentId, db);
        while ((initialLanguageId == null || initialLanguageId.equalsIgnoreCase("-1")) && parentContentVO != null) {
            initialLanguageId = ps.getString("content_" + parentContentVO.getId() + "_initialLanguageId");
            ContentController.getContentController();
            parentContentVO = ContentController.getParentContent(parentContentVO.getId(), db);
        }
        if (initialLanguageId != null && !initialLanguageId.equals("") && !initialLanguageId.equals("-1")) {
            return LanguageController.getController().getLanguageVOWithId(new Integer(initialLanguageId), db);
        }
        return LanguageController.getController().getMasterLanguage(this.repositoryId, db);
    }

    public List getRepositories() {
        return this.repositories;
    }

    public Integer getContentId() {
        return this.contentVO.getId();
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public String getChangeStateToWorking() {
        return this.changeStateToWorking;
    }

    public void setChangeStateToWorking(String changeStateToWorking) {
        this.changeStateToWorking = changeStateToWorking;
    }
}

