/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.actions;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.structuretool.actions.ViewSiteNodeAction;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.usecases.structuretool.UpdateSiteNodeUCC;
import org.infoglue.cms.controllers.usecases.structuretool.UpdateSiteNodeUCCFactory;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.util.ChangeNotificationController;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.NotificationMessage;

public class UpdateSiteNodeAction
extends ViewSiteNodeAction {
    private SiteNodeVO siteNodeVO;
    private Integer siteNodeId;
    private Integer repositoryId;
    private Integer siteNodeTypeDefinitionId;
    private String name;
    private Boolean isBranch;
    private Integer isProtected;
    private Integer disablePageCache;
    private Integer disableEditOnSight;
    private Integer disableLanguages;
    private Integer disableForceIdentityCheck;
    private String contentType;
    private String pageCacheKey;
    private String pageCacheTimeout;
    private ConstraintExceptionBuffer ceb;

    public UpdateSiteNodeAction() {
        this(new SiteNodeVO());
    }

    public UpdateSiteNodeAction(SiteNodeVO siteNodeVO) {
        this.siteNodeVO = siteNodeVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doExecute() throws Exception {
        int i;
        super.initialize(this.getSiteNodeId());
        SiteNodeVO oldSiteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.getSiteNodeId());
        this.siteNodeVO.setCreatorName(this.getInfoGluePrincipal().getName());
        this.siteNodeVO.setMetaInfoContentId(oldSiteNodeVO.getMetaInfoContentId());
        this.ceb = this.siteNodeVO.validate();
        this.ceb.throwIfNotEmpty();
        SiteNodeVersionVO siteNodeVersionVO = new SiteNodeVersionVO();
        siteNodeVersionVO.setContentType(this.getContentType());
        siteNodeVersionVO.setPageCacheKey(this.getPageCacheKey());
        siteNodeVersionVO.setPageCacheTimeout(this.getPageCacheTimeout());
        siteNodeVersionVO.setDisableEditOnSight(this.getDisableEditOnSight());
        siteNodeVersionVO.setDisableLanguages(this.disableLanguages);
        siteNodeVersionVO.setDisablePageCache(this.getDisablePageCache());
        siteNodeVersionVO.setDisableForceIdentityCheck(this.disableForceIdentityCheck);
        siteNodeVersionVO.setIsProtected(this.getIsProtected());
        siteNodeVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
        UpdateSiteNodeUCC updateSiteNodeUCC = UpdateSiteNodeUCCFactory.newUpdateSiteNodeUCC();
        updateSiteNodeUCC.updateSiteNode(this.getInfoGluePrincipal(), this.siteNodeVO, this.siteNodeTypeDefinitionId, siteNodeVersionVO);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        String[] values = this.getRequest().getParameterValues("disabledLanguageId");
        String valueString = "";
        if (values != null) {
            i = 0;
            while (i < values.length) {
                if (i > 0) {
                    valueString = String.valueOf(valueString) + ",";
                }
                valueString = String.valueOf(valueString) + values[i];
                ++i;
            }
        }
        ps.setString("siteNode_" + this.getSiteNodeId() + "_disabledLanguages", valueString);
        values = this.getRequest().getParameterValues("enabledLanguageId");
        valueString = "";
        if (values != null) {
            i = 0;
            while (i < values.length) {
                if (i > 0) {
                    valueString = String.valueOf(valueString) + ",";
                }
                valueString = String.valueOf(valueString) + values[i];
                ++i;
            }
        }
        ps.setString("siteNode_" + this.getSiteNodeId() + "_enabledLanguages", valueString);
        NotificationMessage notificationMessage = new NotificationMessage("UpdateSiteNodeAction", "ServerNodeProperties", this.getInfoGluePrincipal().getName(), 100, "0", "ServerNodeProperties");
        ChangeNotificationController.getInstance().addNotificationMessage(notificationMessage);
        return "success";
    }

    public String doSaveAndExit() throws Exception {
        this.doExecute();
        return "saveAndExit";
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeVO.setSiteNodeId(siteNodeId);
    }

    public Integer getSiteNodeId() {
        return this.siteNodeVO.getSiteNodeId();
    }

    public String getName() {
        return this.siteNodeVO.getName();
    }

    public Boolean getIsBranch() {
        return this.siteNodeVO.getIsBranch();
    }

    public void setName(String name) {
        this.siteNodeVO.setName(name);
    }

    public void setPublishDateTime(String publishDateTime) {
        this.siteNodeVO.setPublishDateTime(new VisualFormatter().parseDate(publishDateTime, "yyyy-MM-dd HH:mm"));
    }

    public void setExpireDateTime(String expireDateTime) {
        this.siteNodeVO.setExpireDateTime(new VisualFormatter().parseDate(expireDateTime, "yyyy-MM-dd HH:mm"));
    }

    public void setIsBranch(Boolean isBranch) {
        this.siteNodeVO.setIsBranch(isBranch);
    }

    public void setSiteNodeTypeDefinitionId(Integer siteNodeTypeDefinitionId) {
        this.siteNodeTypeDefinitionId = siteNodeTypeDefinitionId;
    }

    public Integer getSiteNodeTypeDefinitionId() {
        return this.siteNodeTypeDefinitionId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Integer getDisableEditOnSight() {
        return this.disableEditOnSight;
    }

    public void setDisableEditOnSight(Integer disableEditOnSight) {
        this.disableEditOnSight = disableEditOnSight;
    }

    public Integer getDisableForceIdentityCheck() {
        return this.disableForceIdentityCheck;
    }

    public void setDisableForceIdentityCheck(Integer disableForceIdentityCheck) {
        this.disableForceIdentityCheck = disableForceIdentityCheck;
    }

    public Integer getDisableLanguages() {
        return this.disableLanguages;
    }

    public void setDisableLanguages(Integer disableLanguages) {
        this.disableLanguages = disableLanguages;
    }

    public Integer getDisablePageCache() {
        return this.disablePageCache;
    }

    public void setDisablePageCache(Integer disablePageCache) {
        this.disablePageCache = disablePageCache;
    }

    public Integer getIsProtected() {
        return this.isProtected;
    }

    public void setIsProtected(Integer isProtected) {
        this.isProtected = isProtected;
    }

    public String getPageCacheKey() {
        return this.pageCacheKey;
    }

    public void setPageCacheKey(String pageCacheKey) {
        this.pageCacheKey = pageCacheKey;
    }

    public String getPageCacheTimeout() {
        return this.pageCacheTimeout;
    }

    public void setPageCacheTimeout(String pageCacheTimeout) {
        this.pageCacheTimeout = pageCacheTimeout;
    }
}

