/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.EventController;
import org.infoglue.cms.controllers.kernel.impl.simple.PublicationController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionControllerProxy;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.publishing.PublicationVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.entities.workflow.EventVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;

public class UnpublishSiteNodeVersionAction
extends InfoGlueAbstractAction {
    private List siteNodeVersionVOList = new ArrayList();
    private List siteNodeVOList = new ArrayList();
    private Integer siteNodeId;
    private Integer siteNodeVersionId;
    private Integer repositoryId;
    private List siteNodeVersionIdList = new ArrayList();
    private Integer stateId;
    private Integer languageId;
    private String versionComment;
    private String attemptDirectPublishing = "false";

    public String doInput() throws Exception {
        if (this.siteNodeId != null) {
            SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.siteNodeId);
            this.repositoryId = siteNodeVO.getRepositoryId();
            AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
            Integer protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(this.siteNodeVersionId);
            if (protectedSiteNodeVersionId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "SiteNodeVersion.SubmitToPublish", protectedSiteNodeVersionId.toString())) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1005"));
            }
            ceb.throwIfNotEmpty();
            this.siteNodeVersionVOList = SiteNodeVersionController.getController().getPublishedSiteNodeVersionVOWithParentRecursive(this.siteNodeId);
        }
        return "input";
    }

    public String doInputChooseSiteNodes() throws Exception {
        if (this.siteNodeId != null) {
            SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.siteNodeId);
            this.repositoryId = siteNodeVO.getRepositoryId();
            AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
            Integer protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(this.siteNodeVersionId);
            if (protectedSiteNodeVersionId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "SiteNodeVersion.SubmitToPublish", protectedSiteNodeVersionId.toString())) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1005"));
            }
            ceb.throwIfNotEmpty();
            this.siteNodeVOList = SiteNodeController.getController().getSiteNodeVOWithParentRecursive(this.siteNodeId);
        }
        return "inputChooseSiteNodes";
    }

    public String doExecute() throws Exception {
        this.setSiteNodeVersionIdList(this.getRequest().getParameterValues("sel"));
        Iterator it = this.getSiteNodeVersionIdList().iterator();
        ArrayList<EventVO> events = new ArrayList<EventVO>();
        while (it.hasNext()) {
            Integer siteNodeVersionId = (Integer)it.next();
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getFullSiteNodeVersionVOWithId(siteNodeVersionId);
            EventVO eventVO = new EventVO();
            eventVO.setDescription(this.versionComment);
            eventVO.setEntityClass(SiteNodeVersion.class.getName());
            eventVO.setEntityId(siteNodeVersionId);
            eventVO.setName(siteNodeVersionVO.getSiteNodeName());
            eventVO.setTypeId(EventVO.UNPUBLISH_LATEST);
            eventVO = EventController.create(eventVO, this.repositoryId, this.getInfoGluePrincipal());
            events.add(eventVO);
            List contentVersionVOList = SiteNodeVersionController.getController().getMetaInfoContentVersionVOList(siteNodeVersionId, this.getInfoGluePrincipal());
            for (ContentVersionVO currentContentVersionVO : contentVersionVOList) {
                EventVO versionEventVO = new EventVO();
                versionEventVO.setDescription(this.versionComment);
                versionEventVO.setEntityClass(ContentVersion.class.getName());
                versionEventVO.setEntityId(currentContentVersionVO.getId());
                versionEventVO.setName(currentContentVersionVO.getContentName());
                versionEventVO.setTypeId(EventVO.UNPUBLISH_LATEST);
                versionEventVO = EventController.create(versionEventVO, this.repositoryId, this.getInfoGluePrincipal());
                events.add(versionEventVO);
            }
        }
        if (this.attemptDirectPublishing.equalsIgnoreCase("true")) {
            PublicationVO publicationVO = new PublicationVO();
            publicationVO.setName("Direct publication by " + this.getInfoGluePrincipal().getName());
            publicationVO.setDescription(this.getVersionComment());
            publicationVO.setRepositoryId(this.repositoryId);
            PublicationVO publicationVO2 = PublicationController.getController().createAndPublish(publicationVO, events, false, this.getInfoGluePrincipal());
        }
        return "success";
    }

    public String doUnpublishAll() throws Exception {
        String[] siteNodeIds = this.getRequest().getParameterValues("sel");
        ArrayList<EventVO> events = new ArrayList<EventVO>();
        int i = 0;
        while (i < siteNodeIds.length) {
            String siteNodeIdString = siteNodeIds[i];
            List siteNodeVersionVOList = SiteNodeVersionController.getController().getPublishedActiveFullSiteNodeVersionVOList(new Integer(siteNodeIdString));
            for (SiteNodeVersionVO siteNodeVersionVO : siteNodeVersionVOList) {
                EventVO eventVO = new EventVO();
                eventVO.setDescription(this.versionComment);
                eventVO.setEntityClass(SiteNodeVersion.class.getName());
                eventVO.setEntityId(siteNodeVersionVO.getId());
                eventVO.setName(siteNodeVersionVO.getSiteNodeName());
                eventVO.setTypeId(EventVO.UNPUBLISH_LATEST);
                eventVO = EventController.create(eventVO, this.repositoryId, this.getInfoGluePrincipal());
                events.add(eventVO);
                List contentVersionVOList = SiteNodeVersionController.getController().getMetaInfoContentVersionVOList(siteNodeVersionVO.getId(), this.getInfoGluePrincipal());
                for (ContentVersionVO currentContentVersionVO : contentVersionVOList) {
                    EventVO versionEventVO = new EventVO();
                    versionEventVO.setDescription(this.versionComment);
                    versionEventVO.setEntityClass(ContentVersion.class.getName());
                    versionEventVO.setEntityId(currentContentVersionVO.getId());
                    versionEventVO.setName(currentContentVersionVO.getContentName());
                    versionEventVO.setTypeId(EventVO.UNPUBLISH_LATEST);
                    versionEventVO = EventController.create(versionEventVO, this.repositoryId, this.getInfoGluePrincipal());
                    events.add(versionEventVO);
                }
            }
            ++i;
        }
        if (this.attemptDirectPublishing.equalsIgnoreCase("true")) {
            PublicationVO publicationVO = new PublicationVO();
            publicationVO.setName("Direct publication by " + this.getInfoGluePrincipal().getName());
            publicationVO.setDescription(this.getVersionComment());
            publicationVO.setRepositoryId(this.repositoryId);
            PublicationVO publicationVO2 = PublicationController.getController().createAndPublish(publicationVO, events, false, this.getInfoGluePrincipal());
        }
        return "success";
    }

    public List getSiteNodeVersions() {
        return this.siteNodeVersionVOList;
    }

    public List getSiteNodes() {
        return this.siteNodeVOList;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public void setStateId(Integer stateId) {
        this.stateId = stateId;
    }

    public void setVersionComment(String versionComment) {
        this.versionComment = versionComment;
    }

    public String getVersionComment() {
        return this.versionComment;
    }

    public Integer getStateId() {
        return this.stateId;
    }

    public List getSiteNodeVersionIdList() {
        return this.siteNodeVersionIdList;
    }

    private void setSiteNodeVersionIdList(String[] list) {
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                this.siteNodeVersionIdList.add(new Integer(list[i]));
                ++i;
            }
        }
    }

    public void setAttemptDirectPublishing(String attemptDirectPublishing) {
        this.attemptDirectPublishing = attemptDirectPublishing;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getSiteNodeVersionId() {
        return this.siteNodeVersionId;
    }

    public void setSiteNodeVersionId(Integer siteNodeVersionId) {
        this.siteNodeVersionId = siteNodeVersionId;
    }
}

