/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeControllerProxy;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.dom.DOMBuilder;

public class MoveMultipleSiteNodeAction
extends InfoGlueAbstractAction {
    private Integer originalSiteNodeId;
    private Integer repositoryId;
    private Integer siteNodeId;
    private Integer parentSiteNodeId;
    private List qualifyers = new ArrayList();
    private boolean errorsOccurred = false;
    protected List repositories = null;
    protected String qualifyerXML = null;
    private Integer newParentSiteNodeId;
    private Integer changeTypeId;
    private Integer topSiteNodeId;
    private ConstraintExceptionBuffer ceb;
    private SiteNodeVO siteNodeVO;

    public MoveMultipleSiteNodeAction() {
        this(new SiteNodeVO());
    }

    public MoveMultipleSiteNodeAction(SiteNodeVO siteNodeVO) {
        this.siteNodeVO = siteNodeVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeVO.setSiteNodeId(siteNodeId);
    }

    public Integer getSiteNodeId() {
        return this.siteNodeVO.getSiteNodeId();
    }

    public String doInput() throws Exception {
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
        if (this.qualifyerXML != null && !this.qualifyerXML.equals("")) {
            this.qualifyers = this.parseSiteNodesFromXML(this.qualifyerXML);
        } else {
            SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.getSiteNodeId());
            this.qualifyers.add(siteNodeVO);
        }
        return "input";
    }

    public String doExecute() throws Exception {
        if (this.newParentSiteNodeId == null) {
            this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
            return "chooseDestination";
        }
        this.ceb.throwIfNotEmpty();
        try {
            if (this.qualifyerXML != null && this.qualifyerXML.length() != 0) {
                Document document = new DOMBuilder().getDocument(this.qualifyerXML);
                List siteNodes = this.parseSiteNodesFromXML(this.qualifyerXML);
                for (SiteNodeVO siteNodeVO : siteNodes) {
                    try {
                        SiteNodeControllerProxy.getSiteNodeControllerProxy().acMoveSiteNode(this.getInfoGluePrincipal(), siteNodeVO, this.newParentSiteNodeId);
                    }
                    catch (Exception e) {
                        this.errorsOccurred = true;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.topSiteNodeId = SiteNodeController.getController().getRootSiteNodeVO(this.repositoryId).getId();
        return "success";
    }

    private List parseSiteNodesFromXML(String qualifyerXML) {
        ArrayList<SiteNodeVO> siteNodes = new ArrayList<SiteNodeVO>();
        try {
            Document document = new DOMBuilder().getDocument(qualifyerXML);
            String entity = document.getRootElement().attributeValue("entity");
            HashMap<String, SiteNodeVO> addedSiteNodes = new HashMap<String, SiteNodeVO>();
            List children = document.getRootElement().elements();
            for (Element child : children) {
                String id = child.getStringValue();
                String path = child.attributeValue("path");
                if (addedSiteNodes.containsKey(id)) continue;
                SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(new Integer(id));
                siteNodes.add(siteNodeVO);
                addedSiteNodes.put(id, siteNodeVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return siteNodes;
    }

    public Integer getChangeTypeId() {
        return this.changeTypeId;
    }

    public void setChangeTypeId(Integer changeTypeId) {
        this.changeTypeId = changeTypeId;
    }

    public Integer getNewParentSiteNodeId() {
        return this.newParentSiteNodeId;
    }

    public void setNewParentSiteNodeId(Integer newParentSiteNodeId) {
        this.newParentSiteNodeId = newParentSiteNodeId;
    }

    public Integer getOriginalSiteNodeId() {
        return this.originalSiteNodeId;
    }

    public void setOriginalSiteNodeId(Integer originalSiteNodeId) {
        this.originalSiteNodeId = originalSiteNodeId;
    }

    public Integer getParentSiteNodeId() {
        return this.parentSiteNodeId;
    }

    public void setParentSiteNodeId(Integer parentSiteNodeId) {
        this.parentSiteNodeId = parentSiteNodeId;
    }

    public String getQualifyerXML() {
        return this.qualifyerXML;
    }

    public void setQualifyerXML(String qualifyerXML) {
        this.qualifyerXML = qualifyerXML;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getTopSiteNodeId() {
        return this.topSiteNodeId;
    }

    public void setTopSiteNodeId(Integer topSiteNodeId) {
        this.topSiteNodeId = topSiteNodeId;
    }

    public boolean isErrorsOccurred() {
        return this.errorsOccurred;
    }

    public List getQualifyers() {
        return this.qualifyers;
    }

    public List getRepositories() {
        return this.repositories;
    }

    public SiteNodeVO getSiteNodeVO() {
        return this.siteNodeVO;
    }
}

