/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.InconsistenciesController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeControllerProxy;
import org.infoglue.cms.entities.structure.SiteNodeVO;

public class DeleteSiteNodeAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)DeleteSiteNodeAction.class.getName());
    private SiteNodeVO siteNodeVO;
    private Integer siteNodeId;
    private Integer parentSiteNodeId;
    private Integer changeTypeId;
    private Integer repositoryId;
    private String[] registryId;
    private Integer contentId;
    private List referenceBeanList = new ArrayList();

    public DeleteSiteNodeAction() {
        this(new SiteNodeVO());
    }

    public DeleteSiteNodeAction(SiteNodeVO siteNodeVO) {
        this.siteNodeVO = siteNodeVO;
    }

    protected String doExecute() throws Exception {
        this.referenceBeanList = RegistryController.getController().getReferencingObjectsForSiteNode(this.siteNodeVO.getSiteNodeId());
        if (this.referenceBeanList != null && this.referenceBeanList.size() > 0) {
            return "showRelations";
        }
        try {
            this.parentSiteNodeId = SiteNodeController.getParentSiteNode(this.siteNodeVO.getSiteNodeId()).getSiteNodeId();
        }
        catch (Exception e) {
            logger.info((Object)"The siteNode must have been a root-siteNode because we could not find a parent.");
        }
        SiteNodeControllerProxy.getSiteNodeControllerProxy().acDelete(this.getInfoGluePrincipal(), this.siteNodeVO);
        return "success";
    }

    public String doDeleteReference() throws Exception {
        int i = 0;
        while (i < this.registryId.length) {
            String registryIdString = this.registryId[i];
            Integer registryId = new Integer(registryIdString);
            try {
                InconsistenciesController.getController().removeReferences(registryId, this.getInfoGluePrincipal());
            }
            catch (Exception e) {
                logger.debug((Object)"Error trying to remove reference - must be removed before...");
            }
            try {
                RegistryController.getController().delete(registryId);
            }
            catch (Exception e) {
                logger.debug((Object)"Error trying to remove reference - must be removed before...");
            }
            ++i;
        }
        return this.doExecute();
    }

    public String doFixPage() throws Exception {
        return "fixPage";
    }

    public String doFixPageHeader() throws Exception {
        return "fixPageHeader";
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeVO.setSiteNodeId(siteNodeId);
    }

    public Integer getOriginalSiteNodeId() {
        return this.siteNodeVO.getSiteNodeId();
    }

    public void setParentSiteNodeId(Integer parentSiteNodeId) {
        this.parentSiteNodeId = parentSiteNodeId;
    }

    public void setChangeTypeId(Integer changeTypeId) {
        this.changeTypeId = changeTypeId;
    }

    public Integer getSiteNodeId() {
        return this.parentSiteNodeId;
    }

    public Integer getUnrefreshedSiteNodeId() {
        return this.parentSiteNodeId;
    }

    public Integer getChangeTypeId() {
        return this.changeTypeId;
    }

    public String getErrorKey() {
        return "SiteNodeVersion.stateId";
    }

    public String getReturnAddress() {
        return "ViewSiteNode.action?siteNodeId=" + this.siteNodeVO.getId() + "&repositoryId=" + this.siteNodeVO.getRepositoryId();
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public List getReferenceBeanList() {
        return this.referenceBeanList;
    }

    public String[] getRegistryId() {
        return this.registryId;
    }

    public void setRegistryId(String[] registryId) {
        this.registryId = registryId;
    }
}

