/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.actions;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.applications.databeans.LinkBean;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.PageTemplateController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeTypeDefinitionController;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.sorters.ReflectionComparator;

public class CreateSiteNodeAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)CreateSiteNodeAction.class.getName());
    private Integer siteNodeId;
    private String name;
    private Boolean isBranch;
    private Integer parentSiteNodeId;
    private Integer siteNodeTypeDefinitionId;
    private Integer pageTemplateContentId;
    private Integer repositoryId;
    private String returnAddress;
    private String originalAddress;
    private ConstraintExceptionBuffer ceb;
    private SiteNodeVO siteNodeVO;
    private SiteNodeVO newSiteNodeVO;
    private SiteNodeVO parentSiteNodeVO;
    private String sortProperty = "name";
    private String userSessionKey;

    public CreateSiteNodeAction() {
        this(new SiteNodeVO());
    }

    public CreateSiteNodeAction(SiteNodeVO siteNodeVO) {
        this.siteNodeVO = siteNodeVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public void setParentSiteNodeId(Integer parentSiteNodeId) {
        this.parentSiteNodeId = parentSiteNodeId;
    }

    public Integer getParentSiteNodeId() {
        return this.parentSiteNodeId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setSiteNodeTypeDefinitionId(Integer siteNodeTypeDefinitionId) {
        this.siteNodeTypeDefinitionId = siteNodeTypeDefinitionId;
    }

    public Integer getSiteNodeTypeDefinitionId() {
        return this.siteNodeTypeDefinitionId;
    }

    public String getName() {
        return this.siteNodeVO.getName();
    }

    public String getPublishDateTime() {
        return new VisualFormatter().formatDate(this.siteNodeVO.getPublishDateTime(), "yyyy-MM-dd HH:mm");
    }

    public String getExpireDateTime() {
        return new VisualFormatter().formatDate(this.siteNodeVO.getExpireDateTime(), "yyyy-MM-dd HH:mm");
    }

    public Boolean getIsBranch() {
        return this.siteNodeVO.getIsBranch();
    }

    public void setName(String name) {
        this.siteNodeVO.setName(name);
    }

    public void setPublishDateTime(String publishDateTime) {
        logger.info((Object)("publishDateTime:" + publishDateTime));
        this.siteNodeVO.setPublishDateTime(new VisualFormatter().parseDate(publishDateTime, "yyyy-MM-dd HH:mm"));
    }

    public void setExpireDateTime(String expireDateTime) {
        logger.info((Object)("expireDateTime:" + expireDateTime));
        this.siteNodeVO.setExpireDateTime(new VisualFormatter().parseDate(expireDateTime, "yyyy-MM-dd HH:mm"));
    }

    public void setIsBranch(Boolean isBranch) {
        this.siteNodeVO.setIsBranch(isBranch);
    }

    public Integer getSiteNodeId() {
        return this.newSiteNodeVO.getSiteNodeId();
    }

    public String getSortProperty() {
        return this.sortProperty;
    }

    public List getSortedPageTemplates(String sortProperty) throws Exception {
        SiteNodeVO parentSiteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(this.parentSiteNodeId);
        LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(parentSiteNodeVO.getRepositoryId());
        List components = PageTemplateController.getController().getPageTemplates(this.getInfoGluePrincipal(), masterLanguageVO.getId());
        Collections.sort(components, new ReflectionComparator(sortProperty));
        return components;
    }

    public String getDigitalAssetUrl(Integer contentId, String key) throws Exception {
        String imageHref = null;
        try {
            LanguageVO masterLanguage = LanguageController.getController().getMasterLanguage(ContentController.getContentController().getContentVOWithId(contentId).getRepositoryId());
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, masterLanguage.getId());
            List digitalAssets = DigitalAssetController.getDigitalAssetVOList(contentVersionVO.getId());
            for (DigitalAssetVO digitalAssetVO : digitalAssets) {
                if (!digitalAssetVO.getAssetKey().equals(key)) continue;
                imageHref = DigitalAssetController.getDigitalAssetUrl(digitalAssetVO.getId());
                break;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the digitalAsset: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public List getSiteNodeTypeDefinitions() throws Exception {
        return SiteNodeTypeDefinitionController.getController().getSortedSiteNodeTypeDefinitionVOList();
    }

    public String doExecute() throws Exception {
        this.ceb = this.siteNodeVO.validate();
        this.ceb.throwIfNotEmpty();
        logger.info((Object)("name:" + this.siteNodeVO.getName()));
        logger.info((Object)("publishDateTime:" + this.siteNodeVO.getPublishDateTime()));
        logger.info((Object)("expireDateTime:" + this.siteNodeVO.getExpireDateTime()));
        logger.info((Object)("isBranch:" + this.siteNodeVO.getIsBranch()));
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        this.beginTransaction(db);
        try {
            SiteNode newSiteNode = SiteNodeControllerProxy.getSiteNodeControllerProxy().acCreate(this.getInfoGluePrincipal(), this.parentSiteNodeId, this.siteNodeTypeDefinitionId, this.repositoryId, this.siteNodeVO, db);
            this.newSiteNodeVO = newSiteNode.getValueObject();
            SiteNodeController.getController().createSiteNodeMetaInfoContent(db, newSiteNode, this.repositoryId, this.getInfoGluePrincipal(), this.pageTemplateContentId);
            this.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return "success";
    }

    public String doInput() throws Exception {
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        Integer protectedSiteNodeVersionId = SiteNodeControllerProxy.getController().getProtectedSiteNodeVersionId(this.parentSiteNodeId);
        if (protectedSiteNodeVersionId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "SiteNodeVersion.CreateSiteNode", protectedSiteNodeVersionId.toString())) {
            ceb.add(new AccessConstraintException("SiteNode.siteNodeId", "1002"));
        }
        ceb.throwIfNotEmpty();
        return "input";
    }

    public String doExecuteV3() throws Exception {
        this.ceb = this.siteNodeVO.validate();
        this.ceb.throwIfNotEmpty();
        logger.info((Object)("name:" + this.siteNodeVO.getName()));
        logger.info((Object)("publishDateTime:" + this.siteNodeVO.getPublishDateTime()));
        logger.info((Object)("expireDateTime:" + this.siteNodeVO.getExpireDateTime()));
        logger.info((Object)("isBranch:" + this.siteNodeVO.getIsBranch()));
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        this.beginTransaction(db);
        try {
            SiteNode newSiteNode = SiteNodeControllerProxy.getSiteNodeControllerProxy().acCreate(this.getInfoGluePrincipal(), this.parentSiteNodeId, this.siteNodeTypeDefinitionId, this.repositoryId, this.siteNodeVO, db);
            this.newSiteNodeVO = newSiteNode.getValueObject();
            SiteNodeController.getController().createSiteNodeMetaInfoContent(db, newSiteNode, this.repositoryId, this.getInfoGluePrincipal(), this.pageTemplateContentId);
            this.commitTransaction(db);
            this.addActionLink(this.userSessionKey, new LinkBean("newPageUrl", "Direkt till sidan du skapade", "Klicka h\u00e4r om du vill komma direkt till sidan du just startat.", "Klicka h\u00e4r om du vill komma direkt till sidan du just startat.", this.getDecoratedPageUrl(this.newSiteNodeVO.getId()), false, ""));
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        if (this.returnAddress != null && !this.returnAddress.equals("")) {
            String arguments = "userSessionKey=" + this.userSessionKey + "&isAutomaticRedirect=false";
            String messageUrl = String.valueOf(this.returnAddress) + (this.returnAddress.indexOf("?") > -1 ? "&" : "?") + arguments;
            this.getResponse().sendRedirect(messageUrl);
            return "none";
        }
        return "successV3";
    }

    public String doInputV3() throws Exception {
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        Integer protectedSiteNodeVersionId = SiteNodeControllerProxy.getController().getProtectedSiteNodeVersionId(this.parentSiteNodeId);
        if (protectedSiteNodeVersionId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "SiteNodeVersion.CreateSiteNode", protectedSiteNodeVersionId.toString())) {
            ceb.add(new AccessConstraintException("SiteNode.siteNodeId", "1002"));
        }
        ceb.throwIfNotEmpty();
        this.userSessionKey = "" + System.currentTimeMillis();
        this.parentSiteNodeVO = SiteNodeControllerProxy.getController().getSiteNodeVOWithId(this.parentSiteNodeId);
        this.setActionMessage(this.userSessionKey, "Sidan skapades korrekt under &quot;" + this.parentSiteNodeVO.getName() + "&quot;. Forts\u00e4tt genom att v\u00e4lja n\u00e5got av alternativen nedan.");
        this.addActionLink(this.userSessionKey, new LinkBean("currentPageUrl", "Tillbaka till sidan du utgick fr\u00e5n", "Klicka h\u00e4r om du vill komma tillbaka till sidan d\u00e4r du startade fl\u00f6det.", "Klicka h\u00e4r om du vill komma tillbaka till sidan d\u00e4r du startade fl\u00f6det.", this.originalAddress, false, ""));
        return "inputV3";
    }

    private String getDecoratedPageUrl(Integer siteNodeId) throws Exception {
        int startIndex;
        RepositoryVO repositoryVO = RepositoryController.getController().getRepositoryVOWithId(this.repositoryId);
        String dnsName = repositoryVO.getDnsName();
        String workingUrl = null;
        String keyword = "working=";
        int n = startIndex = dnsName == null ? -1 : dnsName.indexOf(keyword);
        if (startIndex != -1) {
            int endIndex = dnsName.indexOf(",", startIndex);
            dnsName = endIndex > -1 ? dnsName.substring(startIndex, endIndex) : dnsName.substring(startIndex);
            workingUrl = String.valueOf(dnsName.split("=")[1]) + CmsPropertyHandler.getComponentRendererUrl() + "ViewPage!renderDecoratedPage.action";
        } else {
            workingUrl = CmsPropertyHandler.getPreviewDeliveryUrl().replaceFirst("ViewPage.action", "ViewPage!renderDecoratedPage.action");
        }
        return workingUrl + "?siteNodeId=" + siteNodeId;
    }

    public Integer getPageTemplateContentId() {
        return this.pageTemplateContentId;
    }

    public void setPageTemplateContentId(Integer pageTemplateContentId) {
        this.pageTemplateContentId = pageTemplateContentId;
    }

    public SiteNodeVO getParentSiteNodeVO() {
        return this.parentSiteNodeVO;
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public String getUserSessionKey() {
        return this.userSessionKey;
    }

    public void setUserSessionKey(String userSessionKey) {
        this.userSessionKey = userSessionKey;
    }

    public String getOriginalAddress() {
        return this.originalAddress;
    }

    public void setOriginalAddress(String originalAddress) {
        this.originalAddress = originalAddress;
    }
}

