/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.structuretool.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.applications.contenttool.actions.ViewContentTreeActionInterface;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.io.FileHelper;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import webwork.action.ActionContext;
import webwork.multipart.MultiPartRequestWrapper;

public class CreatePageTemplateAction
extends InfoGlueAbstractAction
implements ViewContentTreeActionInterface {
    private static final Logger logger = Logger.getLogger((String)CreatePageTemplateAction.class.getName());
    private List repositories;
    private Integer contentId;
    private String tree;
    private String hideLeafs;
    private Integer parentContentId;
    private Integer repositoryId;
    private Integer componentId;
    private Integer pagePartContentId;
    private ConstraintExceptionBuffer ceb;
    private Integer siteNodeId;
    private String name;
    private String returnAddress;

    public String doInput() throws Exception {
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
        return "input";
    }

    public String doExecute() throws Exception {
        logger.info((Object)("contentId:" + this.contentId));
        logger.info((Object)("parentContentId:" + this.parentContentId));
        logger.info((Object)("repositoryId:" + this.repositoryId));
        logger.info((Object)("siteNodeId:" + this.siteNodeId));
        logger.info((Object)("name:" + this.name));
        ContentTypeDefinitionVO contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName("PageTemplate");
        if (this.componentId != null) {
            contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName("PagePartTemplate");
        }
        if (contentTypeDefinitionVO == null) {
            ContentTypeDefinitionVO newContentTypeDefinitionVO;
            String xml;
            if (this.componentId != null) {
                xml = FileHelper.getFileAsString(new File(String.valueOf(CmsPropertyHandler.getContextRootPath()) + "cms/defaults/contenttypes/PagePartTemplate.xml"));
                newContentTypeDefinitionVO = new ContentTypeDefinitionVO();
                newContentTypeDefinitionVO.setName("PagePartTemplate");
                newContentTypeDefinitionVO.setSchemaValue(xml);
                newContentTypeDefinitionVO.setType(ContentTypeDefinitionVO.CONTENT);
                contentTypeDefinitionVO = ContentTypeDefinitionController.getController().create(newContentTypeDefinitionVO);
            } else {
                xml = FileHelper.getFileAsString(new File(String.valueOf(CmsPropertyHandler.getContextRootPath()) + "cms/defaults/contenttypes/PageTemplate.xml"));
                newContentTypeDefinitionVO = new ContentTypeDefinitionVO();
                newContentTypeDefinitionVO.setName("PageTemplate");
                newContentTypeDefinitionVO.setSchemaValue(xml);
                newContentTypeDefinitionVO.setType(ContentTypeDefinitionVO.CONTENT);
                contentTypeDefinitionVO = ContentTypeDefinitionController.getController().create(newContentTypeDefinitionVO);
            }
        }
        ContentVO contentVO = new ContentVO();
        contentVO.setCreatorName(this.getInfoGluePrincipal().getName());
        contentVO.setIsBranch(new Boolean(false));
        contentVO.setName(this.name);
        contentVO.setRepositoryId(this.repositoryId);
        contentVO = ContentControllerProxy.getController().create(this.parentContentId, contentTypeDefinitionVO.getId(), this.repositoryId, contentVO);
        String componentStructure = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><components></components>";
        ContentVO metaInfoContentVO = ContentController.getContentController().getContentVOWithId(this.contentId);
        Integer originalMetaInfoMasterLanguageId = LanguageController.getController().getMasterLanguage(metaInfoContentVO.getRepositoryId()).getId();
        Integer destinationMasterLanguageId = LanguageController.getController().getMasterLanguage(this.repositoryId).getId();
        ContentVersionVO originalContentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(this.contentId, originalMetaInfoMasterLanguageId);
        logger.info((Object)("originalMetaInfoMasterLanguageId:" + originalMetaInfoMasterLanguageId));
        logger.info((Object)("contentId:" + this.contentId));
        logger.info((Object)("originalContentVersionVO:" + originalContentVersionVO));
        componentStructure = ContentVersionController.getContentVersionController().getAttributeValue(originalContentVersionVO.getId(), "ComponentStructure", false);
        logger.info((Object)("componentStructure:" + componentStructure));
        if (this.componentId != null) {
            logger.info((Object)("We should strip all but componentId:" + this.componentId));
            Document document = XMLHelper.readDocumentFromByteArray(componentStructure.getBytes("UTF-8"));
            String componentXPath = "//component[@id=" + this.componentId + "]";
            Node node = XPathAPI.selectSingleNode((Node)document.getDocumentElement(), (String)componentXPath);
            if (node != null) {
                Element component = (Element)node;
                component.setAttribute("pagePartTemplateContentId", "-1");
                component.setAttribute("isInherited", "true");
                String modifiedXML = XMLHelper.serializeDom(component, new StringBuffer()).toString();
                logger.info((Object)("modifiedXML:" + modifiedXML));
                componentStructure = "<?xml version='1.0' encoding='UTF-8'?><components>" + modifiedXML + "</components>";
            }
        }
        String versionValue = "<?xml version='1.0' encoding='UTF-8'?><article xmlns=\"x-schema:ArticleSchema.xml\"><attributes><Name><![CDATA[" + this.name + "]]></Name><ComponentStructure><![CDATA[" + componentStructure + "]]></ComponentStructure></attributes></article>";
        ContentVersionVO contentVersionVO = new ContentVersionVO();
        contentVersionVO.setVersionComment("Saved page template");
        contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
        contentVersionVO.setVersionValue(versionValue);
        ContentVersionVO newContentVersion = ContentVersionController.getContentVersionController().create(contentVO.getId(), destinationMasterLanguageId, contentVersionVO, null);
        InputStream is = null;
        File file = null;
        try {
            try {
                ActionContext.getContext();
                MultiPartRequestWrapper mpr = ActionContext.getMultiPartRequest();
                logger.info((Object)("mpr:" + mpr));
                if (mpr != null) {
                    Enumeration names = mpr.getFileNames();
                    while (names.hasMoreElements()) {
                        String name = (String)names.nextElement();
                        String contentType = mpr.getContentType(name);
                        String fileSystemName = mpr.getFilesystemName(name);
                        logger.info((Object)("name:" + name));
                        logger.info((Object)("contentType:" + contentType));
                        logger.info((Object)("fileSystemName:" + fileSystemName));
                        file = mpr.getFile(name);
                        String fileName = fileSystemName;
                        fileName = new VisualFormatter().replaceNonAscii(fileName, '_');
                        String tempFileName = "tmp_" + System.currentTimeMillis() + "_" + fileName;
                        String filePath = CmsPropertyHandler.getDigitalAssetPath();
                        fileSystemName = String.valueOf(filePath) + File.separator + tempFileName;
                        DigitalAssetVO newAsset = new DigitalAssetVO();
                        newAsset.setAssetContentType(contentType);
                        newAsset.setAssetKey("thumbnail");
                        newAsset.setAssetFileName(fileName);
                        newAsset.setAssetFilePath(filePath);
                        newAsset.setAssetFileSize(new Integer(new Long(file.length()).intValue()));
                        is = new FileInputStream(file);
                        DigitalAssetController.create(newAsset, is, newContentVersion.getContentVersionId(), this.getInfoGluePrincipal());
                    }
                } else {
                    logger.error((Object)"File upload failed for some reason.");
                }
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tried to upload a new asset:" + e.getMessage()), (Throwable)e);
                try {
                    is.close();
                    file.delete();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                is.close();
                file.delete();
            }
            catch (Exception exception) {}
        }
        return "success";
    }

    public String doUpdate() throws Exception {
        logger.info((Object)("pagePartContentId:" + this.pagePartContentId));
        logger.info((Object)("contentId:" + this.contentId));
        logger.info((Object)("componentId:" + this.componentId));
        ContentVO pagePartContentVO = ContentController.getContentController().getContentVOWithId(this.pagePartContentId);
        Integer pagePartMasterLanguageId = LanguageController.getController().getMasterLanguage(pagePartContentVO.getRepositoryId()).getId();
        ContentVersionVO pagePartContentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(this.pagePartContentId, pagePartMasterLanguageId);
        Locale pagePartMasterLocale = LanguageController.getController().getLocaleWithId(pagePartMasterLanguageId);
        ContentVO metaInfoContentVO = ContentController.getContentController().getContentVOWithId(this.contentId);
        Integer originalMetaInfoMasterLanguageId = LanguageController.getController().getMasterLanguage(metaInfoContentVO.getRepositoryId()).getId();
        ContentVersionVO originalContentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(this.contentId, originalMetaInfoMasterLanguageId);
        logger.info((Object)("originalMetaInfoMasterLanguageId:" + originalMetaInfoMasterLanguageId));
        logger.info((Object)("contentId:" + this.contentId));
        logger.info((Object)("originalContentVersionVO:" + originalContentVersionVO));
        String componentStructure = ContentVersionController.getContentVersionController().getAttributeValue(originalContentVersionVO.getId(), "ComponentStructure", false);
        logger.info((Object)("componentStructure:" + componentStructure));
        if (this.componentId != null) {
            logger.info((Object)("We should strip all but componentId:" + this.componentId));
            Document document = XMLHelper.readDocumentFromByteArray(componentStructure.getBytes("UTF-8"));
            String componentXPath = "//component[@id=" + this.componentId + "]";
            Node node = XPathAPI.selectSingleNode((Node)document.getDocumentElement(), (String)componentXPath);
            if (node != null) {
                Element component = (Element)node;
                component.setAttribute("pagePartTemplateContentId", "-1");
                component.setAttribute("isInherited", "true");
                String modifiedXML = XMLHelper.serializeDom(component, new StringBuffer()).toString();
                logger.info((Object)("modifiedXML:" + modifiedXML));
                componentStructure = "<?xml version='1.0' encoding='UTF-8'?><components>" + modifiedXML + "</components>";
            }
        }
        String versionValue = "<?xml version='1.0' encoding='UTF-8'?><article xmlns=\"x-schema:ArticleSchema.xml\"><attributes><Name><![CDATA[" + this.name + "]]></Name><ComponentStructure><![CDATA[" + componentStructure + "]]></ComponentStructure></attributes></article>";
        ContentVersionVO contentVersionVO = pagePartContentVersionVO;
        contentVersionVO.setVersionComment("Saved page template");
        contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
        contentVersionVO.setVersionValue(versionValue);
        ContentVersionController.getContentVersionController().update(pagePartContentVO.getId(), pagePartMasterLanguageId, contentVersionVO, this.getInfoGluePrincipal());
        return "success";
    }

    public Integer getTopRepositoryId() throws ConstraintException, SystemException, Bug {
        List repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
        Integer topRepositoryId = null;
        if (this.repositoryId != null) {
            topRepositoryId = this.repositoryId;
        }
        if (repositories.size() > 0) {
            topRepositoryId = ((RepositoryVO)repositories.get(0)).getRepositoryId();
        }
        return topRepositoryId;
    }

    public void setHideLeafs(String hideLeafs) {
        this.hideLeafs = hideLeafs;
    }

    public String getHideLeafs() {
        return this.hideLeafs;
    }

    public String getTree() {
        return this.tree;
    }

    public void setTree(String tree) {
        this.tree = tree;
    }

    public void setParentContentId(Integer parentContentId) {
        this.parentContentId = parentContentId;
    }

    public Integer getParentContentId() {
        return this.parentContentId;
    }

    public List getRepositories() {
        return this.repositories;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getRepositoryId() {
        try {
            if (this.repositoryId == null) {
                this.repositoryId = (Integer)this.getHttpSession().getAttribute("repositoryId");
                if (this.repositoryId == null) {
                    this.repositoryId = this.getTopRepositoryId();
                    this.getHttpSession().setAttribute("repositoryId", (Object)this.repositoryId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.repositoryId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(String string) {
        this.returnAddress = string;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getComponentId() {
        return this.componentId;
    }

    public void setComponentId(Integer componentId) {
        this.componentId = componentId;
    }

    public Integer getPagePartContentId() {
        return this.pagePartContentId;
    }

    public void setPagePartContentId(Integer pagePartContentId) {
        this.pagePartContentId = pagePartContentId;
    }

    private Element addPropertyElement(Element parent, String name, String path, String type, Locale locale) {
        Element element = parent.getOwnerDocument().createElement("property");
        element.setAttribute("name", name);
        if (type.equalsIgnoreCase("siteNodeBinding") || type.equalsIgnoreCase("contentBinding")) {
            element.setAttribute("path", path);
            element.setAttribute("path_" + locale.getLanguage(), path);
        } else {
            element.setAttribute("path_" + locale.getLanguage(), path);
        }
        element.setAttribute("type", type);
        parent.appendChild(element);
        return element;
    }
}

