/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.publishingtool.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.ImageButton;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.util.CmsPropertyHandler;

public class ViewPublishingToolToolBarAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewPublishingToolToolBarAction.class.getName());
    private static final long serialVersionUID = 1L;
    private String title = "";
    private String name = "";
    private String toolbarKey = "";
    private String url = "";
    private Integer repositoryId = null;
    private Integer systemUserId = null;
    private Integer roleId = null;
    private Integer languageId = null;
    private Integer functionId = null;
    private Integer serviceDefinitionId = null;
    private Integer availableServiceBindingId = null;
    private Integer siteNodeTypeDefinitionId = null;
    private static HashMap buttonsMap = new HashMap();

    public String doExecute() throws Exception {
        return "success";
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getSystemUserId() {
        return this.systemUserId;
    }

    public void setSystemUserId(Integer systemUserId) {
        this.systemUserId = systemUserId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public Integer getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Integer roleId) {
        this.roleId = roleId;
    }

    public Integer getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(Integer functionId) {
        this.functionId = functionId;
    }

    public Integer getServiceDefinitionId() {
        return this.serviceDefinitionId;
    }

    public void setServiceDefinitionId(Integer serviceDefinitionId) {
        this.serviceDefinitionId = serviceDefinitionId;
    }

    public Integer getAvailableServiceBindingId() {
        return this.availableServiceBindingId;
    }

    public void setAvailableServiceBindingId(Integer availableServiceBindingId) {
        this.availableServiceBindingId = availableServiceBindingId;
    }

    public Integer getSiteNodeTypeDefinitionId() {
        return this.siteNodeTypeDefinitionId;
    }

    public void setSiteNodeTypeDefinitionId(Integer siteNodeTypeDefinitionId) {
        this.siteNodeTypeDefinitionId = siteNodeTypeDefinitionId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getToolbarKey() {
        return this.toolbarKey;
    }

    public void setToolbarKey(String toolbarKey) {
        this.toolbarKey = toolbarKey;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public List getButtons() {
        logger.info((Object)("Title:" + this.title));
        if (this.toolbarKey.equalsIgnoreCase("publications")) {
            return this.getPublicationsButtons();
        }
        return null;
    }

    private List getPublicationsButtons() {
        ArrayList<ImageButton> buttons = new ArrayList<ImageButton>();
        buttons.add(new ImageButton(true, "javascript:submitToPreview();", this.getLocalizedString(this.getSession().getLocale(), "images.publishingtool.buttons.previewContent"), "tool.publishtool.preview.header", "Preview marked versions"));
        buttons.add(new ImageButton(true, "javascript:submitToCreate();", this.getLocalizedString(this.getSession().getLocale(), "images.publishingtool.buttons.createEdition"), "tool.publishtool.createEdition.header", "Create a new edition of the marked versions"));
        buttons.add(new ImageButton(true, "javascript:submitToUnpublish('publication');", this.getLocalizedString(this.getSession().getLocale(), "images.publishingtool.buttons.unpublishEdition"), "tool.publishtool.unpublishEdition.header", "Unpublish the marked edition and send the versions back to publishable state"));
        buttons.add(new ImageButton(true, "javascript:submitToDeny();", this.getLocalizedString(this.getSession().getLocale(), "images.publishingtool.buttons.denyPublishing"), "tool.publishtool.denyPublication.header", "Deny the checked items from publication"));
        try {
            int startIndex;
            RepositoryVO repositoryVO = RepositoryController.getController().getRepositoryVOWithId(this.repositoryId);
            String repositoryName = repositoryVO.getName();
            String dnsName = repositoryVO.getDnsName();
            String previewUrl = null;
            String keyword = "preview=";
            int n = startIndex = dnsName == null ? -1 : dnsName.indexOf(keyword);
            if (startIndex != -1) {
                int endIndex = dnsName.indexOf(",", startIndex);
                dnsName = endIndex > -1 ? dnsName.substring(startIndex, endIndex) : dnsName.substring(startIndex);
                previewUrl = String.valueOf(dnsName.split("=")[1]) + CmsPropertyHandler.getComponentRendererUrl().replaceAll("Working", "Preview") + "ViewPage.action";
            } else {
                previewUrl = CmsPropertyHandler.getStagingDeliveryUrl();
            }
            buttons.add(new ImageButton(true, "javascript:openPopup('" + previewUrl + "?repositoryName=" + repositoryName + "', 'StagingPreview', 'width=800,height=600,resizable=yes,toolbar=yes,scrollbars=yes,status=yes,location=yes,menubar=yes');", this.getLocalizedString(this.getSession().getLocale(), "images.publishingtool.buttons.previewEnvironment"), "tool.publishtool.previewEnvironment.header"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buttons;
    }
}

