/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.publishingtool.actions;

import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.PublicationController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.publishing.EditionBrowser;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;

public class ViewPublicationsAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private int startIndex = 0;
    private Integer repositoryId;
    private Integer publicationId;
    private RepositoryVO repositoryVO;
    private List publicationEvents;
    private List publicationDetailVOList;
    private EditionBrowser editionBrowser;
    private String filter = null;

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int i) {
        this.startIndex = i;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer i) {
        this.repositoryId = i;
    }

    public RepositoryVO getRepositoryVO() {
        return this.repositoryVO;
    }

    public List getPublicationEvents() {
        return this.publicationEvents;
    }

    public EditionBrowser getEditionBrowser() {
        return this.editionBrowser;
    }

    public void setEditionBrowser(EditionBrowser b) {
        this.editionBrowser = b;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        if (CmsPropertyHandler.getAllowPublicationEventFilter().equalsIgnoreCase("true")) {
            this.filter = filter;
            if (this.filter != null) {
                this.getHttpSession().setAttribute("publishEventFilter", (Object)this.filter);
            }
        }
    }

    public String doExecute() throws Exception {
        if (this.filter == null) {
            if (CmsPropertyHandler.getAllowPublicationEventFilter().equalsIgnoreCase("true")) {
                String storedFilter = (String)this.getHttpSession().getAttribute("publishEventFilter");
                if (storedFilter != null) {
                    this.filter = storedFilter;
                }
            } else {
                this.filter = CmsPropertyHandler.getDefaultPublicationEventFilter();
            }
        }
        this.repositoryVO = RepositoryController.getController().getRepositoryVOWithId(this.repositoryId);
        this.publicationEvents = PublicationController.getPublicationEvents(this.repositoryId, this.getInfoGluePrincipal(), this.filter);
        this.editionBrowser = PublicationController.getEditionPage(this.repositoryId, this.startIndex);
        return "success";
    }

    public String doShowPublicationDetails() throws Exception {
        this.publicationDetailVOList = PublicationController.getPublicationDetailVOList(this.publicationId);
        return "showPublicationDetails";
    }

    public static List getPublicationDetails(Integer publicationId) throws SystemException {
        return PublicationController.getPublicationDetailVOList(publicationId);
    }

    public ContentVO getOwningContent(Integer id) throws SystemException {
        return PublicationController.getOwningContentVO(id);
    }

    public SiteNodeVO getOwningSiteNode(Integer id) throws SystemException {
        return PublicationController.getOwningSiteNodeVO(id);
    }

    public String escape(String string) {
        return string.replace('\'', '\u00b4');
    }

    public void setPublicationId(Integer publicationId) {
        this.publicationId = publicationId;
    }

    public List getPublicationDetailVOList() {
        return this.publicationDetailVOList;
    }
}

