/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.publishingtool.actions;

import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.applications.publishingtool.actions.ViewPublicationsAction;
import org.infoglue.cms.controllers.kernel.impl.simple.EventController;
import org.infoglue.cms.controllers.kernel.impl.simple.PublicationController;
import org.infoglue.cms.entities.publishing.PublicationVO;
import org.infoglue.cms.entities.workflow.EventVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.validators.ConstraintRule;

public class CreateEditionAction
extends ViewPublicationsAction {
    private PublicationVO publicationVO;
    private ConstraintExceptionBuffer ceb;
    private String name;
    private String description;
    private List events;

    public CreateEditionAction() {
        this(new PublicationVO());
    }

    public CreateEditionAction(PublicationVO publicationVO) {
        this.publicationVO = publicationVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public ConstraintRule getRule(String fieldName) {
        return this.publicationVO.getRule(fieldName);
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.publicationVO.getName();
    }

    public void setName(String name) {
        this.publicationVO.setName(name);
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.publicationVO.getDescription();
    }

    public void setDescription(String description) {
        this.publicationVO.setDescription(description);
    }

    public List getEvents() {
        return this.events;
    }

    public String doExecute() throws Exception {
        this.publicationVO.setRepositoryId(this.getRepositoryId());
        this.ceb = this.publicationVO.validate();
        this.setEvents(this.getRequest().getParameterValues("sel"));
        this.ceb.throwIfNotEmpty();
        this.publicationVO = PublicationController.getController().createAndPublish(this.publicationVO, this.events, false, this.getInfoGluePrincipal());
        return "success";
    }

    public String doInput() throws Exception {
        this.publicationVO.PrepareValidation();
        this.setEvents(this.getRequest().getParameterValues("sel"));
        return "input";
    }

    private void setEvents(String[] eventArguments) throws SystemException, Exception {
        ArrayList<EventVO> events = new ArrayList<EventVO>();
        int i = 0;
        while (i < eventArguments.length) {
            EventVO eventVO = EventController.getEventVOWithId(new Integer(eventArguments[i]));
            events.add(eventVO);
            ++i;
        }
        this.events = events;
    }
}

