/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.mydesktoptool.actions;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.WorkflowException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ShortcutController;
import org.infoglue.cms.controllers.kernel.impl.simple.WorkflowController;
import org.infoglue.cms.entities.mydesktop.WorkflowActionVO;
import org.infoglue.cms.entities.mydesktop.WorkflowStepVO;
import org.infoglue.cms.entities.mydesktop.WorkflowVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.sorters.ReflectionComparator;
import org.infoglue.cms.util.workflow.StepFilter;
import webwork.action.ActionContext;

public class ViewMyDesktopToolStartPageAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewMyDesktopToolStartPageAction.class.getName());
    private static final long serialVersionUID = 6543209932597662088L;
    protected static final String INVALID_ACTION = "invalidAction";
    private static final WorkflowController controller = WorkflowController.getController();
    private static final ShortcutController shortcutController = ShortcutController.getController();
    private static final VisualFormatter formatter = new VisualFormatter();
    private List availableWorkflowVOList;
    private List workflowVOList;
    private List availableShortcutVOList;
    private WorkflowVO workflow = new WorkflowVO();
    private int actionId;
    private String finalReturnAddress = "";

    public List getWorkflowVOList() {
        Collections.sort(this.workflowVOList, new ReflectionComparator("workflowId"));
        return this.workflowVOList;
    }

    public List getAvailableWorkflowVOList() {
        return this.availableWorkflowVOList;
    }

    public List getAvailableShortcutVOList() {
        return this.availableShortcutVOList;
    }

    public List getWorkflowActionVOList() {
        return this.getAvailableActions(null);
    }

    public List getWorkflowActionVOList(StepFilter filter) {
        return this.getAvailableActions(filter);
    }

    WorkflowVO getWorkflow() {
        return this.workflow;
    }

    public void setWorkflowName(String name) {
        this.workflow.setName(name);
    }

    private String getWorkflowName() {
        return this.workflow.getName();
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public void setWorkflowId(long workflowId) {
        this.workflow.setWorkflowId(new Long(workflowId));
    }

    private long getWorkflowId() {
        return this.workflow.getIdAsPrimitive();
    }

    public String doExecute() throws SystemException {
        this.populateLists();
        return "success";
    }

    public String doTaskList() throws SystemException {
        this.populateActiveWorkflowVOList();
        return "successTaskList";
    }

    public String doStartWorkflow() throws SystemException {
        this.workflow = controller.initializeWorkflow(this.getInfoGluePrincipal(), this.getWorkflowName(), this.actionId, WorkflowController.createWorkflowParameters(ActionContext.getRequest()));
        return this.redirectToView();
    }

    public String doInvoke() throws SystemException {
        logger.info((Object)"****************************************");
        logger.info((Object)("workflowId:" + this.getWorkflowId()));
        logger.info((Object)("actionId:" + this.actionId));
        logger.info((Object)"****************************************");
        try {
            if (this.finalReturnAddress != null && !this.finalReturnAddress.equals("")) {
                logger.info((Object)("Final return address get's set to " + this.finalReturnAddress));
                controller.getPropertySet(this.getInfoGluePrincipal(), this.getWorkflowId()).setString("finalReturnAddress", this.finalReturnAddress);
            } else {
                String finalReturnAddressCandidate = controller.getPropertySet(this.getInfoGluePrincipal(), this.getWorkflowId()).getString("finalReturnAddress");
                logger.info((Object)("finalReturnAddressCandidate " + finalReturnAddressCandidate));
                if (finalReturnAddressCandidate != null && !finalReturnAddressCandidate.equals("")) {
                    this.finalReturnAddress = finalReturnAddressCandidate;
                    logger.info((Object)("Setting Final return address get's set to " + this.finalReturnAddress + " from properties.."));
                }
            }
            this.workflow = controller.invokeAction(this.getInfoGluePrincipal(), this.getWorkflowId(), this.actionId, WorkflowController.createWorkflowParameters(ActionContext.getRequest()));
            return this.redirectToView();
        }
        catch (InvalidActionException e) {
            logger.error((Object)("An error occurred when invoking an action:" + e.getMessage()), (Throwable)e);
            return INVALID_ACTION;
        }
        catch (WorkflowException e) {
            throw new SystemException(e);
        }
    }

    private String redirectToView() throws SystemException {
        Iterator i = this.workflow.getAvailableActions().iterator();
        while (i.hasNext()) {
            String url = this.getViewUrl((WorkflowActionVO)i.next());
            if (url.length() <= 0) continue;
            return this.redirect(url);
        }
        if (this.finalReturnAddress != null && !this.finalReturnAddress.equals("")) {
            return this.redirect(this.finalReturnAddress);
        }
        logger.info((Object)"No action view, coming back to mydesktop...");
        return this.doExecute();
    }

    private void populateLists() throws SystemException {
        this.availableWorkflowVOList = controller.getAvailableWorkflowVOList(this.getInfoGluePrincipal());
        String showAllWorkflows = CmsPropertyHandler.getShowAllWorkflows();
        this.workflowVOList = showAllWorkflows == null || showAllWorkflows.equalsIgnoreCase("true") ? controller.getCurrentWorkflowVOList(this.getInfoGluePrincipal()) : controller.getMyCurrentWorkflowVOList(this.getInfoGluePrincipal());
        this.availableShortcutVOList = shortcutController.getAvailableShortcutVOList(this.getInfoGluePrincipal());
    }

    private List getAvailableActions(StepFilter filter) {
        ArrayList actions = new ArrayList();
        Iterator workflows = this.workflowVOList.iterator();
        while (workflows.hasNext()) {
            actions.addAll(((WorkflowVO)workflows.next()).getAvailableActions(filter));
        }
        return actions;
    }

    private String getViewUrl(WorkflowActionVO action) throws SystemException {
        if (!action.hasView()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(action.getView());
        if (ViewMyDesktopToolStartPageAction.containsQuestionMark(action.getView())) {
            buffer.append('&');
        } else {
            buffer.append('?');
        }
        return buffer.append("workflowId=").append(this.getWorkflowId()).append("&actionId=").append(action.getId()).append("&returnAddress=").append(this.getReturnAddress()).append("&finalReturnAddress=").append(this.getFinalReturnAddress()).append('&').append(this.getRequest().getQueryString()).toString();
    }

    private static boolean containsQuestionMark(String s) {
        return s.indexOf("?") >= 0;
    }

    private String getReturnAddress() throws SystemException {
        try {
            String cmsFullBaseUrl = CmsPropertyHandler.getCmsFullBaseUrl();
            logger.info((Object)("cmsFullBaseUrl:" + cmsFullBaseUrl));
            if (cmsFullBaseUrl != null && !cmsFullBaseUrl.equals("")) {
                return URLEncoder.encode(String.valueOf(cmsFullBaseUrl) + "/ViewMyDesktopToolStartPage!invoke.action", "UTF-8");
            }
            return URLEncoder.encode(String.valueOf(this.getURLBase()) + "/ViewMyDesktopToolStartPage!invoke.action", "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException(e);
        }
    }

    private String redirect(String url) throws SystemException {
        try {
            logger.info((Object)("Url in doInvoke:" + url));
            this.getResponse().sendRedirect(url);
            return "none";
        }
        catch (IOException e) {
            throw new SystemException(e);
        }
    }

    private String getFinalReturnAddress() throws SystemException {
        try {
            return URLEncoder.encode(this.finalReturnAddress, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException(e);
        }
    }

    public void setFinalReturnAddress(String finalReturnAddress) {
        if (finalReturnAddress != null && !finalReturnAddress.equals("null")) {
            this.finalReturnAddress = finalReturnAddress;
        }
    }

    private void populateActiveWorkflowVOList() throws SystemException {
        String showAllWorkflows = CmsPropertyHandler.getShowAllWorkflows();
        this.workflowVOList = showAllWorkflows == null || showAllWorkflows.equalsIgnoreCase("true") ? controller.getCurrentWorkflowVOList(this.getInfoGluePrincipal()) : controller.getMyCurrentWorkflowVOList(this.getInfoGluePrincipal());
    }

    public String doGetActiveWorkflowProperties() throws Exception {
        StringBuffer sb = new StringBuffer();
        String activeWorkflowId = this.getRequest().getParameter("activeWorkflowId");
        this.populateActiveWorkflowVOList();
        List currentWorkflowVOList = this.workflowVOList;
        for (WorkflowVO workflowVO : currentWorkflowVOList) {
            if (!activeWorkflowId.equals(workflowVO.getId().toString())) continue;
            sb.append("<div id=\"activeWorkflowDetailsProperties\" class=\"propertiesDiv\" style=\"z-index:10\">");
            sb.append("\t<div id=\"activeWorkflowDetailsPropertiesHandle\" class=\"propertiesDivHandle\">");
            sb.append("\t\t<div id=\"propertiesDivLeftHandle\" class=\"propertiesDivLeftHandle\" style=\"width: 300px;\">" + workflowVO.getName() + "&nbsp;-&nbsp;#" + workflowVO.getId() + "</div><div id=\"propertiesDivRightHandle\" class=\"propertiesDivRightHandle\"><a href=\"javascript:hideDiv('activeWorkflowDetailsProperties');\" class=\"white\">close</a></div>");
            sb.append("\t</div>");
            sb.append("\t<div id=\"activeWorkflowDetailsPropertiesBody\" class=\"propertiesDivBody\">");
            sb.append("\t\t<table border=\"0\" cellpadding=\"4\" cellspacing=\"0\" width=\"100%\">");
            for (WorkflowStepVO workflowStepVO : workflowVO.getSteps()) {
                sb.append("\t\t<tr>");
                sb.append("\t\t\t<td style=\"" + (workflowStepVO.getFinishDate() == null ? "color: black;" : "color: silver;") + "\">" + workflowStepVO.getName() + "</td>");
                sb.append("\t\t\t<td style=\"" + (workflowStepVO.getFinishDate() == null ? "color: black;" : "color: silver;") + "\">" + (workflowStepVO.getOwner() != null ? workflowStepVO.getOwner() : "Not specified") + "</td>");
                sb.append("\t\t\t<td style=\"" + (workflowStepVO.getFinishDate() == null ? "color: black;" : "color: silver;") + "\">" + (workflowStepVO.getCaller() != null ? workflowStepVO.getCaller() : "Not specified") + "</td>");
                sb.append("\t\t\t<td style=\"" + (workflowStepVO.getFinishDate() == null ? "color: black;" : "color: silver;") + "\">" + workflowStepVO.getStatus() + "</td>");
                sb.append("\t\t\t<td style=\"" + (workflowStepVO.getFinishDate() == null ? "color: black;" : "color: silver;") + "\">" + (workflowStepVO.getStartDate() == null ? "Not started" : formatter.formatDate(workflowStepVO.getStartDate(), "yyyy-MM-dd")) + "</td>");
                sb.append("\t\t\t<td style=\"" + (workflowStepVO.getFinishDate() == null ? "color: black;" : "color: silver;") + "\">" + (workflowStepVO.getFinishDate() == null ? "Not completed" : formatter.formatDate(workflowStepVO.getFinishDate(), "yyyy-MM-dd")) + "</td>");
                sb.append("\t\t</tr>");
            }
            sb.append("\t\t</table>");
            sb.append("\t\t</div>");
            sb.append("\t</div>");
            break;
        }
        this.getResponse().setContentType("text/plain");
        this.getResponse().getWriter().println(sb.toString());
        return "none";
    }

    public String doGetAvailableWorkflowProperties() throws Exception {
        StringBuffer sb = new StringBuffer();
        String workflowName = this.getRequest().getParameter("workflowName");
        try {
            List availableWorkflowVOList = controller.getAvailableWorkflowVOList(this.getInfoGluePrincipal());
            for (WorkflowVO availableWorkflowVO : availableWorkflowVOList) {
                if (!workflowName.equals(availableWorkflowVO.getName())) continue;
                sb.append("<div id=\"availableWorkflowDetailsProperties\" class=\"propertiesDiv\" style=\"z-index: 10;\">");
                sb.append("\t<div id=\"availableWorkflowDetailsPropertiesHandle\" class=\"propertiesDivHandle\">");
                sb.append("\t\t<div id=\"propertiesDivLeftHandle\" class=\"propertiesDivLeftHandle\">" + availableWorkflowVO.getName() + "</div><div id=\"propertiesDivRightHandle\" class=\"propertiesDivRightHandle\"><a href=\"javascript:hideDiv('availableWorkflowDetailsProperties');\" class=\"white\">close</a></div>");
                sb.append("\t</div>");
                sb.append("\t<div id=\"availableWorkflowDetailsPropertiesBody\" class=\"propertiesDivBody\">");
                sb.append("\t\t<table border=\"0\" cellpadding=\"4\" cellspacing=\"0\" width=\"100%\">");
                for (WorkflowStepVO workflowStepVO : availableWorkflowVO.getDeclaredSteps()) {
                    sb.append("\t\t<tr style=\"background-color: white;\">");
                    sb.append("\t\t\t<td>" + workflowStepVO.getName() + "</td>");
                    sb.append("\t\t\t<td>" + (workflowStepVO.getOwner() != null ? workflowStepVO.getOwner() : "Not specified") + "</td>");
                    sb.append("\t\t</tr>");
                    for (WorkflowActionVO workflowActionVO : workflowStepVO.getActions()) {
                        sb.append("<tr style=\"background-color: #eeeeee;\">");
                        sb.append("\t<td style=\"padding-left: 20px; font-size:10px;\">" + workflowActionVO.getName() + "</td>");
                        sb.append("\t\t<td style=\"padding-left: 20px; font-size:10px;\"><!--" + workflowActionVO.getView() + "--></td>");
                        sb.append("\t</tr>");
                    }
                }
                sb.append("\t\t</table>");
                sb.append("\t</div>");
                sb.append("</div>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getResponse().setContentType("text/plain");
        this.getResponse().getWriter().println(sb.toString());
        return "none";
    }
}

