/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions.deployment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.applications.databeans.AssetKeyDefinition;
import org.infoglue.cms.applications.managementtool.actions.deployment.DeploymentCompareBean;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.WorkflowDefinitionController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.CategoryAttribute;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.management.ContentTypeAttribute;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.workflow.WorkflowDefinitionVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.sorters.ComponentDeploymentComparator;
import org.infoglue.cms.util.sorters.ReflectionComparator;
import org.infoglue.deliver.util.HttpUtilities;
import org.infoglue.deliver.util.webservices.DynamicWebservice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewDeploymentSynchronizeServersAction
extends InfoGlueAbstractAction {
    public static final Logger logger = Logger.getLogger((String)ViewDeploymentSynchronizeServersAction.class.getName());
    private static final long serialVersionUID = 1L;
    private boolean synchronizeContentTypeDefinitions;
    private boolean synchronizeCategories;
    private boolean synchronizeWorkflows;
    private boolean synchronizeComponents;
    private Integer deploymentServerIndex = null;
    private String synchronizationMethod = "pull";
    private List<DeploymentCompareBean> deviatingContentTypes = new ArrayList<DeploymentCompareBean>();
    private List<DeploymentCompareBean> deviatingCategoryVOList = new ArrayList<DeploymentCompareBean>();
    private List<DeploymentCompareBean> deviatingWorkflows = new ArrayList<DeploymentCompareBean>();
    private List<DeploymentCompareBean> deviatingContents = new ArrayList<DeploymentCompareBean>();
    private List<DeploymentCompareBean> deviatingSiteNodes = new ArrayList<DeploymentCompareBean>();
    private static ContentTypeDefinitionController contentTypeDefinitionController = ContentTypeDefinitionController.getController();
    private static CategoryController categoryController = CategoryController.getController();

    public String doInput() throws Exception {
        try {
            DeploymentCompareBean bean;
            List<String> deploymentServers = CmsPropertyHandler.getDeploymentServers();
            logger.info((Object)("deploymentServers:" + deploymentServers.size()));
            String deploymentServerUrl = deploymentServers.get(this.deploymentServerIndex);
            logger.info((Object)("deploymentServerUrl:" + deploymentServerUrl));
            String targetEndpointAddress = String.valueOf(deploymentServerUrl) + "/services/RemoteDeploymentService";
            logger.info((Object)("targetEndpointAddress:" + targetEndpointAddress));
            logger.info((Object)("synchronizeContentTypeDefinitions:" + this.synchronizeContentTypeDefinitions));
            logger.info((Object)("synchronizeCategories:" + this.synchronizeCategories));
            if (this.synchronizeContentTypeDefinitions) {
                Object[] contentTypeDefinitionVOArray = (Object[])this.invokeOperation(targetEndpointAddress, "getContentTypeDefinitions", "contentTypeDefinition", null, new Class[]{ContentTypeDefinitionVO.class}, "infoglue");
                List<Object> remoteContentTypeDefinitionVOList = Arrays.asList(contentTypeDefinitionVOArray);
                Collections.sort(remoteContentTypeDefinitionVOList, new ReflectionComparator("name"));
                if (this.synchronizationMethod.equalsIgnoreCase("pull")) {
                    for (ContentTypeDefinitionVO contentTypeDefinitionVO : remoteContentTypeDefinitionVOList) {
                        ContentTypeDefinitionVO localContentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName(contentTypeDefinitionVO.getName());
                        DeploymentCompareBean deploymentCompareBean = new DeploymentCompareBean();
                        deploymentCompareBean.setRemoteVersion(contentTypeDefinitionVO);
                        if (localContentTypeDefinitionVO != null) {
                            deploymentCompareBean.setLocalVersion(localContentTypeDefinitionVO);
                        }
                        this.deviatingContentTypes.add(deploymentCompareBean);
                    }
                } else {
                    logger.info((Object)"Getting what content types are not the same from a push perspective...");
                    List localContentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
                    for (ContentTypeDefinitionVO localContentTypeDefinitionVO : localContentTypeDefinitionVOList) {
                        Iterator<Object> iterator = remoteContentTypeDefinitionVOList.iterator();
                        ContentTypeDefinitionVO remoteContentTypeDefinitionVO = null;
                        while (iterator.hasNext()) {
                            ContentTypeDefinitionVO remoteContentTypeDefinitionVOCandidate = (ContentTypeDefinitionVO)iterator.next();
                            if (!remoteContentTypeDefinitionVOCandidate.getName().equals(localContentTypeDefinitionVO.getName())) continue;
                            remoteContentTypeDefinitionVO = remoteContentTypeDefinitionVOCandidate;
                        }
                        bean = new DeploymentCompareBean();
                        bean.setLocalVersion(localContentTypeDefinitionVO);
                        if (remoteContentTypeDefinitionVO != null) {
                            bean.setRemoteVersion(remoteContentTypeDefinitionVO);
                        }
                        this.deviatingContentTypes.add(bean);
                    }
                }
            }
            if (this.synchronizeCategories) {
                Object[] categoryVOArray = (Object[])this.invokeOperation(targetEndpointAddress, "getAllActiveCategories", "category", null, new Class[]{CategoryVO.class}, "infoglue");
                List<Object> remoteCategoryVOList = Arrays.asList(categoryVOArray);
                Collections.sort(remoteCategoryVOList, new ReflectionComparator("name"));
                List allLocalCategories = CategoryController.getController().findAllActiveCategories(true);
                if (this.synchronizationMethod.equalsIgnoreCase("push")) {
                    this.compareCategoryLists(remoteCategoryVOList, allLocalCategories);
                } else {
                    this.compareCategoryLists(allLocalCategories, remoteCategoryVOList);
                }
            }
            if (this.synchronizeWorkflows) {
                Object[] workflowVOArray = (Object[])this.invokeOperation(targetEndpointAddress, "getWorkflowDefinitions", "workflowDefinition", null, new Class[]{WorkflowDefinitionVO.class}, "infoglue");
                List<Object> remoteWorkflowDefinitionVOList = Arrays.asList(workflowVOArray);
                Collections.sort(remoteWorkflowDefinitionVOList, new ReflectionComparator("name"));
                if (this.synchronizationMethod.equalsIgnoreCase("pull")) {
                    for (WorkflowDefinitionVO workflowDefinitionVO : remoteWorkflowDefinitionVOList) {
                        WorkflowDefinitionVO localWorkflowDefinitionVO = WorkflowDefinitionController.getController().getWorkflowDefinitionVOWithName(workflowDefinitionVO.getName());
                        DeploymentCompareBean deploymentCompareBean = new DeploymentCompareBean();
                        deploymentCompareBean.setRemoteVersion(workflowDefinitionVO);
                        if (localWorkflowDefinitionVO != null) {
                            deploymentCompareBean.setLocalVersion(localWorkflowDefinitionVO);
                        }
                        this.deviatingWorkflows.add(deploymentCompareBean);
                    }
                } else {
                    logger.info((Object)"Getting what workflow definitions are not the same from a push perspective...");
                    List localWorkflowDefinitionVOList = WorkflowDefinitionController.getController().getWorkflowDefinitionVOList();
                    for (WorkflowDefinitionVO localWorkflowDefinitionVO : localWorkflowDefinitionVOList) {
                        Iterator<Object> iterator = remoteWorkflowDefinitionVOList.iterator();
                        WorkflowDefinitionVO remoteWorkflowDefinitionVO = null;
                        while (iterator.hasNext()) {
                            WorkflowDefinitionVO remoteWorkflowDefinitionVOCandidate = (WorkflowDefinitionVO)iterator.next();
                            if (!remoteWorkflowDefinitionVOCandidate.getName().equals(localWorkflowDefinitionVO.getName())) continue;
                            remoteWorkflowDefinitionVO = remoteWorkflowDefinitionVOCandidate;
                        }
                        bean = new DeploymentCompareBean();
                        bean.setLocalVersion(localWorkflowDefinitionVO);
                        if (remoteWorkflowDefinitionVO != null) {
                            bean.setRemoteVersion(remoteWorkflowDefinitionVO);
                        }
                        this.deviatingWorkflows.add(bean);
                    }
                }
            }
            if (this.synchronizeComponents) {
                Object[] contentVOArray = (Object[])this.invokeOperation(targetEndpointAddress, "getComponents", "content", null, new Class[]{ContentVO.class, ContentVersionVO.class}, "infoglue", new Class[]{ContentVO.class, ContentVersionVO.class});
                List<Object> remoteContentVOList = Arrays.asList(contentVOArray);
                List components = ContentController.getContentController().getContentVOWithContentTypeDefinition("HTMLTemplate");
                ComponentDeploymentComparator componentDeploymentComparator = new ComponentDeploymentComparator("modifiedDateTime", "desc");
                Collections.sort(remoteContentVOList, componentDeploymentComparator);
                if (this.synchronizationMethod.equalsIgnoreCase("pull")) {
                    for (ContentVO contentVO : remoteContentVOList) {
                        Iterator componentsIterator = components.iterator();
                        ContentVO localContentVO = null;
                        while (componentsIterator.hasNext()) {
                            ContentVO candidate = (ContentVO)componentsIterator.next();
                            if (!candidate.getName().equals(contentVO.getName())) continue;
                            localContentVO = candidate;
                        }
                        DeploymentCompareBean bean3 = new DeploymentCompareBean();
                        bean3.setRemoteVersion(contentVO);
                        if (localContentVO != null) {
                            bean3.setLocalVersion(localContentVO);
                            LanguageVO languageVO = LanguageController.getController().getMasterLanguage(localContentVO.getRepositoryId());
                            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(localContentVO.getId(), languageVO.getId());
                            if (contentVersionVO != null) {
                                localContentVO.setVersions(new String[]{contentVersionVO.getVersionValue()});
                                localContentVO.setContentVersion(contentVersionVO);
                            }
                        }
                        this.deviatingContents.add(bean3);
                    }
                } else {
                    for (ContentVO contentVO : components) {
                        String fullPath = ContentController.getContentController().getContentPath(contentVO.getId(), true, true);
                        contentVO.setFullPath(fullPath);
                        Iterator<Object> remoteContentVOListIterator = remoteContentVOList.iterator();
                        ContentVO remoteContentVO = null;
                        while (remoteContentVOListIterator.hasNext()) {
                            ContentVO remoteContentVOCandidate = (ContentVO)remoteContentVOListIterator.next();
                            if (!contentVO.getName().equals(remoteContentVOCandidate.getName())) continue;
                            remoteContentVO = remoteContentVOCandidate;
                        }
                        DeploymentCompareBean bean4 = new DeploymentCompareBean();
                        LanguageVO languageVO = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId());
                        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), languageVO.getId());
                        if (contentVersionVO != null) {
                            contentVO.setVersions(new String[]{contentVersionVO.getVersionValue()});
                            contentVO.setContentVersion(contentVersionVO);
                        }
                        bean4.setLocalVersion(contentVO);
                        if (remoteContentVO != null) {
                            bean4.setRemoteVersion(remoteContentVO);
                        }
                        this.deviatingContents.add(bean4);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error in sync tool:" + e.getMessage()), (Throwable)e);
        }
        return "input";
    }

    private void compareCategoryLists(List remoteCategoryVOList, List<CategoryVO> allLocalCategories) {
        for (CategoryVO remoteCategoryVO : remoteCategoryVOList) {
            boolean categoryExists = false;
            CategoryVO localCategoryVO2 = null;
            for (CategoryVO localCategoryVO2 : allLocalCategories) {
                if (!localCategoryVO2.getName().equals(remoteCategoryVO.getName())) continue;
                categoryExists = true;
                break;
            }
            if (!categoryExists) {
                DeploymentCompareBean bean = new DeploymentCompareBean();
                bean.setRemoteVersion(remoteCategoryVO);
                this.deviatingCategoryVOList.add(bean);
            }
            if (remoteCategoryVO.getChildren() == null || remoteCategoryVO.getChildren().size() <= 0) continue;
            if (localCategoryVO2 != null) {
                this.compareCategoryLists(remoteCategoryVO.getChildren(), localCategoryVO2.getChildren());
                continue;
            }
            this.compareCategoryLists(remoteCategoryVO.getChildren(), new ArrayList<CategoryVO>());
        }
    }

    public String doUpdateContentTypes() throws Exception {
        List<String> deploymentServers = CmsPropertyHandler.getDeploymentServers();
        String deploymentServerUrl = deploymentServers.get(this.deploymentServerIndex);
        logger.info((Object)("Synchronization method:" + this.synchronizationMethod));
        String targetEndpointAddress = String.valueOf(deploymentServerUrl) + "/services/RemoteDeploymentService";
        if (this.synchronizationMethod == null || this.synchronizationMethod.equalsIgnoreCase("pull")) {
            String[] deviatingContentTypeNameArray;
            Object[] contentTypeDefinitionVOArray = (Object[])this.invokeOperation(targetEndpointAddress, "getContentTypeDefinitions", "contentTypeDefinition", null, new Class[]{ContentTypeDefinitionVO.class}, "infoglue");
            List<Object> remoteContentTypeDefinitionVOList = Arrays.asList(contentTypeDefinitionVOArray);
            Collections.sort(remoteContentTypeDefinitionVOList, new ReflectionComparator("name"));
            String[] missingContentTypeNameArray = this.getRequest().getParameterValues("missingContentTypeName");
            if (missingContentTypeNameArray != null) {
                int i = 0;
                while (i < missingContentTypeNameArray.length) {
                    String missingContentTypeName = missingContentTypeNameArray[i];
                    for (ContentTypeDefinitionVO contentTypeDefinitionVO : remoteContentTypeDefinitionVOList) {
                        if (!contentTypeDefinitionVO.getName().equals(missingContentTypeName)) continue;
                        ContentTypeDefinitionController.getController().create(contentTypeDefinitionVO);
                    }
                    ++i;
                }
            }
            if ((deviatingContentTypeNameArray = this.getRequest().getParameterValues("deviatedContentTypeName")) != null) {
                int i = 0;
                while (i < deviatingContentTypeNameArray.length) {
                    String deviatingContentTypeName = deviatingContentTypeNameArray[i];
                    for (ContentTypeDefinitionVO contentTypeDefinitionVO : remoteContentTypeDefinitionVOList) {
                        String[] assetKeyArray;
                        String[] categoryNameArray;
                        if (!contentTypeDefinitionVO.getName().equals(deviatingContentTypeName)) continue;
                        ContentTypeDefinitionVO localContentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName(contentTypeDefinitionVO.getName());
                        String newSchemaValue = localContentTypeDefinitionVO.getSchemaValue();
                        String[] attributeNameArray = this.getRequest().getParameterValues(String.valueOf(deviatingContentTypeName) + "_attributeName");
                        if (attributeNameArray != null) {
                            int j = 0;
                            while (j < attributeNameArray.length) {
                                String attributeName = attributeNameArray[j];
                                newSchemaValue = contentTypeDefinitionController.copyAttribute(contentTypeDefinitionVO.getSchemaValue(), newSchemaValue, attributeName);
                                ++j;
                            }
                        }
                        if ((categoryNameArray = this.getRequest().getParameterValues(String.valueOf(deviatingContentTypeName) + "_categoryName")) != null) {
                            int j = 0;
                            while (j < categoryNameArray.length) {
                                String categoryName = categoryNameArray[j];
                                newSchemaValue = contentTypeDefinitionController.copyCategory(contentTypeDefinitionVO.getSchemaValue(), newSchemaValue, categoryName);
                                ++j;
                            }
                        }
                        if ((assetKeyArray = this.getRequest().getParameterValues(String.valueOf(deviatingContentTypeName) + "_assetKey")) != null) {
                            int j = 0;
                            while (j < assetKeyArray.length) {
                                String assetKey = assetKeyArray[j];
                                newSchemaValue = contentTypeDefinitionController.copyAssetKey(contentTypeDefinitionVO.getSchemaValue(), newSchemaValue, assetKey);
                                ++j;
                            }
                        }
                        localContentTypeDefinitionVO.setSchemaValue(newSchemaValue);
                        ContentTypeDefinitionController.getController().update(localContentTypeDefinitionVO);
                    }
                    ++i;
                }
            }
        } else {
            String[] deviatingContentTypeNameArray;
            HashMap<String, Cloneable> input = new HashMap<String, Cloneable>();
            ArrayList<ContentTypeDefinitionVO> contentTypeDefinitionVOList = new ArrayList<ContentTypeDefinitionVO>();
            String[] missingContentTypeNameArray = this.getRequest().getParameterValues("missingContentTypeName");
            if (missingContentTypeNameArray != null) {
                int i = 0;
                while (i < missingContentTypeNameArray.length) {
                    String missingContentTypeName = missingContentTypeNameArray[i];
                    logger.info((Object)("Updating missingContentTypeName:" + missingContentTypeName));
                    ContentTypeDefinitionVO localContentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName(missingContentTypeName);
                    logger.info((Object)("Updating localContentTypeDefinitionVO:" + localContentTypeDefinitionVO));
                    contentTypeDefinitionVOList.add(localContentTypeDefinitionVO);
                    ++i;
                }
            }
            if ((deviatingContentTypeNameArray = this.getRequest().getParameterValues("deviatedContentTypeName")) != null) {
                int i = 0;
                while (i < deviatingContentTypeNameArray.length) {
                    String deviatingContentTypeName = deviatingContentTypeNameArray[i];
                    logger.info((Object)("Updating deviatingContentTypeName:" + deviatingContentTypeName));
                    ContentTypeDefinitionVO contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName(deviatingContentTypeName);
                    logger.info((Object)("Updating localContentTypeDefinitionVO as it was different:" + contentTypeDefinitionVO));
                    contentTypeDefinitionVOList.add(contentTypeDefinitionVO);
                    HashMap hashMap = new HashMap();
                    ArrayList<String> attributes = new ArrayList<String>();
                    String[] attributeNameArray = this.getRequest().getParameterValues(String.valueOf(deviatingContentTypeName) + "_attributeName");
                    if (attributeNameArray != null) {
                        int j = 0;
                        while (j < attributeNameArray.length) {
                            String attributeName = attributeNameArray[j];
                            attributes.add(attributeName);
                            ++j;
                        }
                    }
                    ArrayList<String> categories = new ArrayList<String>();
                    String[] categoryNameArray = this.getRequest().getParameterValues(String.valueOf(deviatingContentTypeName) + "_categoryName");
                    if (categoryNameArray != null) {
                        int j = 0;
                        while (j < categoryNameArray.length) {
                            String categoryName = categoryNameArray[j];
                            categories.add(categoryName);
                            ++j;
                        }
                    }
                    ArrayList<String> assets = new ArrayList<String>();
                    String[] assetKeyArray = this.getRequest().getParameterValues(String.valueOf(deviatingContentTypeName) + "_assetKey");
                    if (assetKeyArray != null) {
                        int j = 0;
                        while (j < assetKeyArray.length) {
                            String assetKey = assetKeyArray[j];
                            assets.add(assetKey);
                            ++j;
                        }
                    }
                    hashMap.put("attributes", attributes);
                    hashMap.put("categories", categories);
                    hashMap.put("assets", assets);
                    input.put("deviationArguments_" + deviatingContentTypeName, hashMap);
                    ++i;
                }
            }
            logger.info((Object)("contentTypeDefinitionVOList to send:" + contentTypeDefinitionVOList.size()));
            input.put("contentTypeDefinitionVOList", contentTypeDefinitionVOList);
            if (missingContentTypeNameArray != null) {
                ArrayList missingContentTypeNameList = new ArrayList();
                missingContentTypeNameList.addAll(Arrays.asList(missingContentTypeNameArray));
                input.put("missingContentTypeNameArray", missingContentTypeNameList);
            }
            if (deviatingContentTypeNameArray != null) {
                ArrayList deviatingContentTypeNameList = new ArrayList();
                deviatingContentTypeNameList.addAll(Arrays.asList(deviatingContentTypeNameArray));
                input.put("deviatingContentTypeNameArray", deviatingContentTypeNameList);
            }
            Boolean bl = (Boolean)this.invokeOperation(targetEndpointAddress, "updateContentTypeDefinitions", "contentTypeDefinition", input, new Class[]{Boolean.class}, "java", new Class[]{ContentTypeDefinitionVO.class});
        }
        return this.doInput();
    }

    public String doUpdateCategories() throws Exception {
        List<String> deploymentServers = CmsPropertyHandler.getDeploymentServers();
        String deploymentServerUrl = deploymentServers.get(this.deploymentServerIndex);
        String targetEndpointAddress = String.valueOf(deploymentServerUrl) + "/services/RemoteDeploymentService";
        if (this.synchronizationMethod == null || this.synchronizationMethod.equalsIgnoreCase("pull")) {
            Object[] categoryVOArray = (Object[])this.invokeOperation(targetEndpointAddress, "getAllActiveCategories", "category", null, new Class[]{CategoryVO.class}, "infoglue");
            List<Object> remoteCategoryVOList = Arrays.asList(categoryVOArray);
            Collections.sort(remoteCategoryVOList, new ReflectionComparator("name"));
            List allLocalCategories = CategoryController.getController().findAllActiveCategories();
            HashMap handledRemoteCategoryPaths = new HashMap();
            Hashtable requestMap = HttpUtilities.requestToHashtable(this.getRequest());
            categoryController.compareAndCompleteCategoryLists(remoteCategoryVOList, allLocalCategories, null, handledRemoteCategoryPaths, requestMap);
        } else {
            HashMap<String, Object> input = new HashMap<String, Object>();
            Hashtable requestMap = HttpUtilities.requestToHashtable(this.getRequest());
            List allLocalCategories = CategoryController.getController().findAllActiveCategories();
            input.put("categoryVOList", allLocalCategories);
            input.put("requestMap", requestMap);
            Boolean bl = (Boolean)this.invokeOperation(targetEndpointAddress, "updateCategories", "category", input, new Class[]{Boolean.class}, "java", new Class[]{CategoryVO.class});
        }
        return this.doInput();
    }

    public String doUpdateWorkflows() throws Exception {
        List<String> deploymentServers = CmsPropertyHandler.getDeploymentServers();
        String deploymentServerUrl = deploymentServers.get(this.deploymentServerIndex);
        String targetEndpointAddress = String.valueOf(deploymentServerUrl) + "/services/RemoteDeploymentService";
        if (this.synchronizationMethod == null || this.synchronizationMethod.equalsIgnoreCase("pull")) {
            Object[] workflowDefinitionVOArray = (Object[])this.invokeOperation(targetEndpointAddress, "getWorkflowDefinitions", "workflowDefinition", null, new Class[]{WorkflowDefinitionVO.class}, "infoglue");
            List<Object> remoteWorkflowDefinitionVOList = Arrays.asList(workflowDefinitionVOArray);
            Collections.sort(remoteWorkflowDefinitionVOList, new ReflectionComparator("name"));
            String[] missingWorkflowDefinitionNameArray = this.getRequest().getParameterValues("missingWorkflowDefinitionName");
            if (missingWorkflowDefinitionNameArray != null) {
                int i = 0;
                while (i < missingWorkflowDefinitionNameArray.length) {
                    String missingWorkflowDefinitionName = missingWorkflowDefinitionNameArray[i];
                    for (WorkflowDefinitionVO workflowDefinitionVO : remoteWorkflowDefinitionVOList) {
                        if (!workflowDefinitionVO.getName().equals(missingWorkflowDefinitionName)) continue;
                        WorkflowDefinitionController.getController().create(workflowDefinitionVO);
                    }
                    ++i;
                }
            }
        } else {
            HashMap<String, Object> input = new HashMap<String, Object>();
            Hashtable requestMap = HttpUtilities.requestToHashtable(this.getRequest());
            List workflowDefinitionVOList = WorkflowDefinitionController.getController().getWorkflowDefinitionVOList();
            input.put("workflowDefinitionVOList", workflowDefinitionVOList);
            input.put("requestMap", requestMap);
            Boolean bl = (Boolean)this.invokeOperation(targetEndpointAddress, "updateWorkflows", "workflow", input, new Class[]{Boolean.class}, "java", new Class[]{WorkflowDefinitionVO.class});
        }
        return this.doInput();
    }

    public String doUpdateComponents() throws Exception {
        List<String> deploymentServers = CmsPropertyHandler.getDeploymentServers();
        String deploymentServerUrl = deploymentServers.get(this.deploymentServerIndex);
        String targetEndpointAddress = String.valueOf(deploymentServerUrl) + "/services/RemoteDeploymentService";
        ContentTypeDefinitionVO contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName("HTMLTemplate");
        if (this.synchronizationMethod == null || this.synchronizationMethod.equalsIgnoreCase("pull")) {
            Object[] contentVOArray = (Object[])this.invokeOperation(targetEndpointAddress, "getComponents", "content", null, new Class[]{ContentVO.class}, "infoglue");
            List<Object> remoteContentVOList = Arrays.asList(contentVOArray);
            Collections.sort(remoteContentVOList, new ReflectionComparator("name"));
            String[] missingRemoteContentIdArray = this.getRequest().getParameterValues("missingContentId");
            logger.info((Object)("missingRemoteContentIdArray:" + missingRemoteContentIdArray));
            ArrayList missingComponents = new ArrayList();
            if (missingRemoteContentIdArray != null) {
                int i = 0;
                while (i < missingRemoteContentIdArray.length) {
                    String missingRemoteContentId = missingRemoteContentIdArray[i];
                    logger.info((Object)("Updating remote component with missingRemoteContentId:" + missingRemoteContentId));
                    for (ContentVO contentVO : remoteContentVOList) {
                        if (!contentVO.getId().equals(new Integer(missingRemoteContentId))) continue;
                        logger.info((Object)("Creating local copy of " + contentVO.getName() + " - " + contentVO.getFullPath()));
                        String fullPath = contentVO.getFullPath();
                        logger.info((Object)("fullPath:" + fullPath));
                        int n = fullPath.indexOf(" - /");
                        String repositoryString = fullPath.substring(0, n);
                        String restString = fullPath.substring(n + 4);
                        logger.info((Object)("restString:" + restString));
                        restString = restString.substring(0, restString.lastIndexOf("/"));
                        logger.info((Object)("restString:" + restString));
                        restString = restString.indexOf("/") > -1 ? restString.substring(restString.indexOf("/") + 1) : "";
                        logger.info((Object)("restString:" + restString));
                        logger.info((Object)("repositoryString:" + repositoryString));
                        logger.info((Object)("restString:" + restString));
                        try {
                            RepositoryVO repositoryVO = RepositoryController.getController().getRepositoryVOWithName(repositoryString);
                            logger.info((Object)("repositoryVO:" + repositoryVO));
                            if (repositoryVO == null) break;
                            LanguageVO languageVO = LanguageController.getController().getMasterLanguage(repositoryVO.getRepositoryId());
                            ContentVO parentContent = ContentController.getContentController().getContentVOWithPath(repositoryVO.getId(), restString, true, this.getInfoGluePrincipal());
                            logger.info((Object)("parentContent:" + parentContent));
                            ContentVO newContentVO = ContentController.getContentController().create(parentContent.getId(), contentTypeDefinitionVO.getContentTypeDefinitionId(), parentContent.getRepositoryId(), contentVO);
                            logger.info((Object)("Now we want to create the version also on:" + newContentVO.getName()));
                            ContentVersionVO contentVersionVO = new ContentVersionVO();
                            contentVersionVO.setVersionComment("deployment");
                            contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
                            if (contentVO.getVersions() == null || contentVO.getVersions().length <= 0) break;
                            contentVersionVO.setVersionValue(contentVO.getVersions()[0]);
                            ContentVersionController.getContentVersionController().create(newContentVO.getId(), languageVO.getId(), contentVersionVO, null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    ++i;
                }
            }
            String[] deviatingRemoteContentIdArray = this.getRequest().getParameterValues("deviatingContentId");
            List components = ContentController.getContentController().getContentVOWithContentTypeDefinition("HTMLTemplate");
            if (deviatingRemoteContentIdArray != null) {
                int i = 0;
                while (i < deviatingRemoteContentIdArray.length) {
                    String string = deviatingRemoteContentIdArray[i];
                    for (ContentVO contentVO : remoteContentVOList) {
                        String[] versionValues;
                        if (!contentVO.getId().equals(string) || (versionValues = contentVO.getVersions()) == null || versionValues.length <= 0) continue;
                        String remoteVersionValue = versionValues[0];
                        Iterator componentsIterator = components.iterator();
                        ContentVO localContentVO = null;
                        while (componentsIterator.hasNext()) {
                            ContentVO candidate = (ContentVO)componentsIterator.next();
                            if (!candidate.getName().equals(contentVO.getName())) continue;
                            localContentVO = candidate;
                        }
                        LanguageVO languageVO = LanguageController.getController().getMasterLanguage(localContentVO.getRepositoryId());
                        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(localContentVO.getId(), languageVO.getId());
                        if (contentVersionVO == null) continue;
                        contentVersionVO.setVersionValue(remoteVersionValue);
                        ContentVersionController.getContentVersionController().update(contentVersionVO.getId(), contentVersionVO);
                    }
                    ++i;
                }
            }
        } else {
            logger.info((Object)"Updating components with push....");
            HashMap input = new HashMap();
            String[] missingLocalContentIdArray = this.getRequest().getParameterValues("missingContentId");
            logger.info((Object)("missingLocalContentIdArray:" + missingLocalContentIdArray));
            ArrayList<ContentVO> missingComponents = new ArrayList<ContentVO>();
            if (missingLocalContentIdArray != null) {
                int i = 0;
                while (i < missingLocalContentIdArray.length) {
                    String missingLocalContentId = missingLocalContentIdArray[i];
                    ContentVO contentVO = ContentController.getContentController().getContentVOWithId((int)new Integer(missingLocalContentId));
                    if (contentVO != null) {
                        LanguageVO languageVO = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId());
                        String string = ContentController.getContentController().getContentPath(contentVO.getId(), true, true);
                        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), languageVO.getId());
                        if (contentVersionVO != null) {
                            contentVO.setVersions(new String[]{contentVersionVO.getVersionValue()});
                        }
                        contentVO.setFullPath(string);
                        missingComponents.add(contentVO);
                    }
                    ++i;
                }
            }
            String[] deviatingLocalContentIdArray = this.getRequest().getParameterValues("deviatingContentId");
            logger.info((Object)("deviatingLocalContentIdArray:" + deviatingLocalContentIdArray));
            ArrayList<ContentVO> deviatingComponents = new ArrayList<ContentVO>();
            if (deviatingLocalContentIdArray != null) {
                int i = 0;
                while (i < deviatingLocalContentIdArray.length) {
                    String deviatingLocalContentId = deviatingLocalContentIdArray[i];
                    ContentVO contentVO = ContentController.getContentController().getContentVOWithId((int)new Integer(deviatingLocalContentId));
                    if (contentVO != null) {
                        LanguageVO languageVO = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId());
                        String string = ContentController.getContentController().getContentPath(contentVO.getId(), true, true);
                        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), languageVO.getId());
                        if (contentVersionVO != null) {
                            contentVO.setVersions(new String[]{contentVersionVO.getVersionValue()});
                        }
                        contentVO.setFullPath(string);
                        deviatingComponents.add(contentVO);
                    }
                    ++i;
                }
            }
            input.put("missingComponents", missingComponents);
            input.put("deviatingComponents", deviatingComponents);
            Boolean bl = (Boolean)this.invokeOperation(targetEndpointAddress, "updateComponents", "content", input, new Class[]{Boolean.class}, "java", new Class[]{ContentVO.class, ContentVersionVO.class});
        }
        return this.doInput();
    }

    @Override
    public String doExecute() throws Exception {
        List<String> deploymentServers = CmsPropertyHandler.getDeploymentServers();
        String deploymentServerUrl = deploymentServers.get(this.deploymentServerIndex);
        return "success";
    }

    public void setDeploymentServerIndex(Integer deploymentServerIndex) {
        this.deploymentServerIndex = deploymentServerIndex;
    }

    public List<DeploymentCompareBean> getDeviatingContents() {
        return this.deviatingContents;
    }

    public List<DeploymentCompareBean> getDeviatingContentTypes() {
        return this.deviatingContentTypes;
    }

    public List<DeploymentCompareBean> getDeviatingSiteNodes() {
        return this.deviatingSiteNodes;
    }

    public List<DeploymentCompareBean> getDeviatingWorkflows() {
        return this.deviatingWorkflows;
    }

    public List<DeploymentCompareBean> getDeviatingCategoryVOList() {
        return this.deviatingCategoryVOList;
    }

    public List getDeviatingAttributes(String remoteSchemaValue, String localSchemaValue) {
        ArrayList<ContentTypeAttribute> deviatingAttributes = new ArrayList<ContentTypeAttribute>();
        List remoteAttributes = ContentTypeDefinitionController.getController().getContentTypeAttributes(remoteSchemaValue);
        List localAttributes = ContentTypeDefinitionController.getController().getContentTypeAttributes(localSchemaValue);
        for (ContentTypeAttribute conentTypeAttribute : remoteAttributes) {
            Iterator localAttributesIterator = localAttributes.iterator();
            boolean attributeExisted = false;
            while (localAttributesIterator.hasNext()) {
                ContentTypeAttribute localConentTypeAttribute = (ContentTypeAttribute)localAttributesIterator.next();
                if (!localConentTypeAttribute.getName().equals(conentTypeAttribute.getName())) continue;
                attributeExisted = true;
            }
            if (attributeExisted) continue;
            deviatingAttributes.add(conentTypeAttribute);
        }
        return deviatingAttributes;
    }

    public List getDeviatingAssetKeys(String remoteSchemaValue, String localSchemaValue) throws Exception {
        ArrayList<AssetKeyDefinition> deviatingAssetKeys = new ArrayList<AssetKeyDefinition>();
        List remoteAssetKeys = ContentTypeDefinitionController.getController().getDefinedAssetKeys(remoteSchemaValue);
        List localAssetKeys = ContentTypeDefinitionController.getController().getDefinedAssetKeys(localSchemaValue);
        for (AssetKeyDefinition assetKeyDefinition : remoteAssetKeys) {
            Iterator localAssetKeysIterator = localAssetKeys.iterator();
            boolean assetKeyExisted = false;
            while (localAssetKeysIterator.hasNext()) {
                AssetKeyDefinition localAssetKeyDefinition = (AssetKeyDefinition)localAssetKeysIterator.next();
                if (!localAssetKeyDefinition.getAssetKey().equals(localAssetKeyDefinition.getAssetKey())) continue;
                assetKeyExisted = true;
            }
            if (assetKeyExisted) continue;
            deviatingAssetKeys.add(assetKeyDefinition);
        }
        return deviatingAssetKeys;
    }

    public List getDeviatingCategories(String remoteSchemaValue, String localSchemaValue) throws Exception {
        ArrayList<CategoryAttribute> deviatingCategories = new ArrayList<CategoryAttribute>();
        List remoteCategoryKeys = this.getDefinedCategoryKeys(remoteSchemaValue);
        List localCategoryKeys = this.getDefinedCategoryKeys(localSchemaValue);
        for (CategoryAttribute categoryAttribute : remoteCategoryKeys) {
            Iterator localCategoriesIterator = localCategoryKeys.iterator();
            boolean categoryExisted = false;
            while (localCategoriesIterator.hasNext()) {
                CategoryAttribute localCategoryAttribute = (CategoryAttribute)localCategoriesIterator.next();
                if (!localCategoryAttribute.getCategoryName().equals(categoryAttribute.getCategoryName())) continue;
                categoryExisted = true;
            }
            if (categoryExisted) continue;
            deviatingCategories.add(categoryAttribute);
        }
        return deviatingCategories;
    }

    public List getDefinedCategoryKeys(String schemaValue) throws Exception {
        List categoryKeys = ContentTypeDefinitionController.getController().getDefinedCategoryKeys(schemaValue);
        for (CategoryAttribute info : categoryKeys) {
            if (info.getCategoryId() != null) {
                info.setCategoryName(this.getCategoryName(info.getCategoryId()));
                continue;
            }
            info.setCategoryName("Undefined");
        }
        return categoryKeys;
    }

    public String getCategoryName(Integer id) {
        try {
            return CategoryController.getController().findById(id).getName();
        }
        catch (SystemException e) {
            return "Category not found";
        }
    }

    protected Object invokeOperation(String endpointAddress, String operationName, String name, Object argument, Class[] returnType, String nameSpace) throws JspException {
        return this.invokeOperation(endpointAddress, operationName, name, argument, returnType, nameSpace, null);
    }

    protected Object invokeOperation(String endpointAddress, String operationName, String name, Object argument, Class[] returnType, String nameSpace, Class[] extraClassInfo) throws JspException {
        Object result = null;
        try {
            InfoGluePrincipal principal = this.getInfoGluePrincipal();
            DynamicWebservice ws = new DynamicWebservice(principal);
            ws.setTargetEndpointAddress(endpointAddress);
            ws.setOperationName(operationName);
            int i = 0;
            while (i < returnType.length) {
                ws.setReturnType(returnType[i], new QName(nameSpace, ws.getClassName(returnType[i])));
                ++i;
            }
            if (argument != null) {
                if (argument instanceof Map || argument instanceof HashMap) {
                    ws.addArgument(name, (Map)argument, extraClassInfo);
                } else if (argument instanceof List || argument instanceof ArrayList) {
                    ws.addArgument(name, (List)argument, extraClassInfo);
                } else {
                    ws.addArgument(name, argument);
                }
            }
            ws.callService();
            result = ws.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JspTagException(e.getMessage());
        }
        return result;
    }

    public String getCategoryPath(Integer categoryId) throws SystemException {
        return CategoryController.getController().getCategoryPath(categoryId);
    }

    public void setSynchronizeCategories(boolean synchronizeCategories) {
        this.synchronizeCategories = synchronizeCategories;
    }

    public void setSynchronizeContentTypeDefinitions(boolean synchronizeContentTypeDefinitions) {
        this.synchronizeContentTypeDefinitions = synchronizeContentTypeDefinitions;
    }

    public void setSynchronizeWorkflows(boolean synchronizeWorkflows) {
        this.synchronizeWorkflows = synchronizeWorkflows;
    }

    public boolean getSynchronizeCategories() {
        return this.synchronizeCategories;
    }

    public boolean getSynchronizeContentTypeDefinitions() {
        return this.synchronizeContentTypeDefinitions;
    }

    public boolean getSynchronizeWorkflows() {
        return this.synchronizeWorkflows;
    }

    public void setSynchronizeComponents(boolean synchronizeComponents) {
        this.synchronizeComponents = synchronizeComponents;
    }

    public boolean getSynchronizeComponents() {
        return this.synchronizeComponents;
    }

    public String getSynchronizationMethod() {
        return this.synchronizationMethod;
    }

    public void setSynchronizationMethod(String synchronizationMethod) {
        this.synchronizationMethod = synchronizationMethod;
    }
}

