/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.managementtool.actions.ViewEntityPropertiesAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.UserProperties;
import org.infoglue.cms.entities.management.UserPropertiesVO;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;

public class ViewUserPropertiesAction
extends ViewEntityPropertiesAction {
    private static final Logger logger = Logger.getLogger((String)ViewUserPropertiesAction.class.getName());
    private static final long serialVersionUID = 1L;
    private String userName;
    private UserPropertiesVO userPropertiesVO;
    private List userPropertiesVOList;

    protected void initialize(String userName) throws Exception {
        super.initialize();
        logger.info((Object)("userName:" + userName));
        List contentTypeDefinitionVOList = UserPropertiesController.getController().getContentTypeDefinitionVOList(userName);
        if (contentTypeDefinitionVOList != null && contentTypeDefinitionVOList.size() > 0) {
            this.setContentTypeDefinitionVO((ContentTypeDefinitionVO)contentTypeDefinitionVOList.get(0));
        }
        InfoGluePrincipal infoGluePrincipal = UserControllerProxy.getController().getUser(userName);
        this.userPropertiesVOList = UserPropertiesController.getController().getUserPropertiesVOList(userName, this.getLanguageId());
        if (this.userPropertiesVOList != null && this.userPropertiesVOList.size() > 0) {
            this.userPropertiesVO = (UserPropertiesVO)this.userPropertiesVOList.get(0);
            this.setContentTypeDefinitionId(this.userPropertiesVO.getContentTypeDefinitionId());
        } else {
            this.setContentTypeDefinitionId(this.getContentTypeDefinitionVO().getContentTypeDefinitionId());
        }
        logger.info((Object)("this.userPropertiesVO:" + this.userPropertiesVO));
        this.setAttributes(ContentTypeDefinitionController.getController().getContentTypeAttributes(this.getContentTypeDefinitionVO().getSchemaValue()));
        logger.info((Object)("attributes:" + this.getContentTypeAttributes().size()));
        logger.info((Object)("availableLanguages:" + this.getAvailableLanguages().size()));
    }

    public String doExecute() throws Exception {
        this.initialize(this.getUserName());
        this.setCurrentAction("ViewUserProperties.action");
        this.setUpdateAction("UpdateUserProperties");
        this.setUpdateAndExitAction("UpdateUserProperties");
        this.setCancelAction("ViewSystemUser!v3.action");
        this.setToolbarKey("tool.managementtool.viewUserProperties.header");
        this.setTitleKey("tool.managementtool.viewUserProperties.header");
        this.setArguments("");
        this.setEntityName(UserProperties.class.getName());
        return "success";
    }

    public String doV3() throws Exception {
        this.initialize(this.getUserName());
        this.setCurrentAction("ViewUserProperties!v3.action");
        this.setUpdateAction("UpdateUserProperties!v3");
        this.setUpdateAndExitAction("UpdateUserProperties!saveAndExitV3");
        this.setCancelAction("ViewSystemUser!v3.action");
        this.setToolbarKey("tool.managementtool.viewUserProperties.header");
        this.setTitleKey("tool.managementtool.viewUserProperties.header");
        this.setArguments("");
        this.setEntityName(UserProperties.class.getName());
        return "successV3";
    }

    public List getDigitalAssets() {
        List digitalAssets = null;
        try {
            if (this.userPropertiesVO != null && this.userPropertiesVO.getId() != null) {
                digitalAssets = UserPropertiesController.getController().getDigitalAssetVOList(this.userPropertiesVO.getId());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of digitalAssets: " + e.getMessage()), (Throwable)e);
        }
        return digitalAssets;
    }

    public List getRelatedCategories(String attribute) {
        try {
            if (this.userPropertiesVO != null && this.userPropertiesVO.getId() != null) {
                return this.getPropertiesCategoryController().findByPropertiesAttribute(attribute, UserProperties.class.getName(), this.userPropertiesVO.getId());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of defined category keys: " + e.getMessage()), (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    public String getXML() {
        return this.userPropertiesVO == null ? null : this.userPropertiesVO.getValue();
    }

    public String getUserName() {
        return this.userName;
    }

    public UserPropertiesVO getUserPropertiesVO() {
        return this.userPropertiesVO;
    }

    public List getUserPropertiesVOList() {
        return this.userPropertiesVOList;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.setOwnerEntityId(userName);
    }

    public Integer getEntityId() {
        return this.userPropertiesVO.getId();
    }

    public void setOwnerEntityId(String ownerEntityId) {
        super.setOwnerEntityId(ownerEntityId);
        this.userName = ownerEntityId;
    }

    public String getReturnAddress() throws Exception {
        String URIEncoding = CmsPropertyHandler.getURIEncoding();
        return String.valueOf(this.getCurrentAction()) + "?userName=" + URLEncoder.encode(this.userName, URIEncoding) + "&languageId=" + this.getLanguageId();
    }

    public String getCancelAddress() throws Exception {
        String URIEncoding = CmsPropertyHandler.getURIEncoding();
        return String.valueOf(this.getCancelAction()) + "?userName=" + URLEncoder.encode(this.userName, URIEncoding);
    }
}

