/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.net.URLEncoder;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.managementtool.actions.ViewEntityPropertiesAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.GroupProperties;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.UserPropertiesVO;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.dom.DOMBuilder;

public class ViewSystemUserPropertiesAction
extends ViewEntityPropertiesAction {
    private static final Logger logger = Logger.getLogger((String)ViewSystemUserPropertiesAction.class.getName());
    private static final long serialVersionUID = 1L;
    private String userName;
    private UserPropertiesVO userPropertiesVO;
    private List userPropertiesVOList;
    private List availableLanguages;
    private List contentTypeDefinitionVOList;
    private List attributes;
    private ContentTypeDefinitionVO contentTypeDefinitionVO;
    private Integer contentTypeDefinitionId;
    private Integer languageId;
    private Integer currentEditorId;
    private String attributeName = "";
    private String textAreaId = "";

    protected void initialize(String userName) throws Exception {
        this.availableLanguages = LanguageController.getController().getLanguageVOList();
        if (this.languageId == null && this.availableLanguages.size() > 0) {
            this.languageId = ((LanguageVO)this.availableLanguages.get(0)).getLanguageId();
        }
        logger.info((Object)("Language:" + this.languageId));
        List contentTypeDefinitionVOList = UserPropertiesController.getController().getContentTypeDefinitionVOList(userName);
        if (contentTypeDefinitionVOList != null && contentTypeDefinitionVOList.size() > 0) {
            this.contentTypeDefinitionVO = (ContentTypeDefinitionVO)contentTypeDefinitionVOList.get(0);
        }
        logger.info((Object)("contentTypeDefinitionVO:" + this.contentTypeDefinitionVO.getName()));
        InfoGluePrincipal infoGluePrincipal = UserControllerProxy.getController().getUser(userName);
        this.userPropertiesVOList = UserPropertiesController.getController().getUserPropertiesVOList(userName, this.languageId);
        if (this.userPropertiesVOList != null && this.userPropertiesVOList.size() > 0) {
            this.userPropertiesVO = (UserPropertiesVO)this.userPropertiesVOList.get(0);
            this.contentTypeDefinitionId = this.userPropertiesVO.getLanguageId();
        } else {
            this.contentTypeDefinitionId = this.contentTypeDefinitionVO.getContentTypeDefinitionId();
        }
        this.attributes = ContentTypeDefinitionController.getController().getContentTypeAttributes(this.contentTypeDefinitionVO.getSchemaValue());
        logger.info((Object)("attributes:" + this.attributes.size()));
        logger.info((Object)("availableLanguages:" + this.availableLanguages.size()));
    }

    public String doExecute() throws Exception {
        this.initialize(this.getUserName());
        this.setCurrentAction("ViewSystemUserProperties.action");
        this.setUpdateAction("UpdateSystemUserProperties");
        this.setUpdateAndExitAction("UpdateSystemUserProperties!saveAndExitV3");
        this.setCancelAction("ViewSystemUser.action");
        this.setToolbarKey("tool.managementtool.viewUserProperties.header");
        this.setTitleKey("tool.managementtool.viewUserProperties.header");
        this.setArguments("");
        this.setEntityName(GroupProperties.class.getName());
        return "success";
    }

    public String doV3() throws Exception {
        this.initialize(this.getUserName());
        this.setCurrentAction("ViewSystemUserProperties!v3.action");
        this.setUpdateAction("UpdateSystemUserProperties!v3");
        this.setUpdateAndExitAction("UpdateSystemUserProperties!saveAndExitV3");
        this.setCancelAction("ViewSystemUser!v3.action");
        this.setToolbarKey("tool.managementtool.viewUserProperties.header");
        this.setTitleKey("tool.managementtool.viewUserProperties.header");
        this.setArguments("");
        this.setEntityName(GroupProperties.class.getName());
        return "successV3";
    }

    public String getAttributeValue(String key) {
        logger.info((Object)("Getting: " + key));
        String value = "";
        try {
            String xml = this.getXML();
            if (xml != null) {
                logger.info((Object)("key:" + key));
                logger.info((Object)("XML:" + this.getXML()));
                DOMBuilder domBuilder = new DOMBuilder();
                Document document = domBuilder.getDocument(this.getXML());
                logger.info((Object)("rootElement:" + document.getRootElement().asXML()));
                Node node = document.getRootElement().selectSingleNode("attributes/" + key);
                if (node != null) {
                    value = node.getStringValue();
                    logger.info((Object)("Getting value: " + value));
                    if (value != null) {
                        value = new VisualFormatter().escapeHTML(value);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public List getAvailableLanguages() {
        return this.availableLanguages;
    }

    public Integer getContentTypeDefinitionId() {
        return this.contentTypeDefinitionId;
    }

    public UserPropertiesVO getUserPropertiesVO() {
        return this.userPropertiesVO;
    }

    public String getXML() {
        return this.userPropertiesVO == null ? null : this.userPropertiesVO.getValue();
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public Integer getCurrentEditorId() {
        return this.currentEditorId;
    }

    public void setCurrentEditorId(Integer integer) {
        this.currentEditorId = integer;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getTextAreaId() {
        return this.textAreaId;
    }

    public void setTextAreaId(String textAreaId) {
        this.textAreaId = textAreaId;
    }

    public List getContentTypeAttributes() {
        return this.attributes;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getReturnAddress() throws Exception {
        String URIEncoding = CmsPropertyHandler.getURIEncoding();
        return String.valueOf(this.getCurrentAction()) + "?userName=" + URLEncoder.encode(this.userName, URIEncoding) + "&amp;languageId=" + this.getLanguageId();
    }

    public String getCancelAddress() throws Exception {
        String URIEncoding = CmsPropertyHandler.getURIEncoding();
        return String.valueOf(this.getCancelAction()) + "?userName=" + URLEncoder.encode(this.userName, URIEncoding);
    }
}

