/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;

public class ViewSystemUserAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private String userName;
    private boolean supportsUpdate = true;
    private InfoGluePrincipal infoGluePrincipal;
    private List roles = new ArrayList();
    private List assignedRoleVOList;
    private List groups = new ArrayList();
    private List assignedGroupVOList;
    private List contentTypeDefinitionVOList;
    private List assignedContentTypeDefinitionVOList;

    protected void initialize(String userName) throws Exception {
        this.infoGluePrincipal = UserControllerProxy.getController().getUser(userName);
        if (this.infoGluePrincipal == null) {
            throw new SystemException("No user found called '" + userName + "'. This could be an encoding issue if you gave your user a login name with non ascii chars in it. Look in the administrative manual on how to solve it.");
        }
        this.supportsUpdate = this.infoGluePrincipal.getAutorizationModule().getSupportUpdate();
        this.assignedRoleVOList = this.infoGluePrincipal.getRoles();
        if (this.supportsUpdate) {
            this.roles = this.infoGluePrincipal.getAutorizationModule().getRoles();
        }
        this.assignedGroupVOList = this.infoGluePrincipal.getGroups();
        if (this.supportsUpdate) {
            this.groups = this.infoGluePrincipal.getAutorizationModule().getGroups();
        }
        this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList(ContentTypeDefinitionVO.EXTRANET_USER_PROPERTIES);
        this.assignedContentTypeDefinitionVOList = UserPropertiesController.getController().getContentTypeDefinitionVOList(userName);
    }

    public String doExecute() throws Exception {
        this.initialize(this.getUserName());
        return "success";
    }

    public String doV3() throws Exception {
        this.initialize(this.getUserName());
        return "successV3";
    }

    public List getAssignedRoles() throws Exception {
        return this.assignedRoleVOList;
    }

    public List getAllRoles() throws Exception {
        return this.roles;
    }

    public List getAssignedGroups() throws Exception {
        return this.assignedGroupVOList;
    }

    public List getAllGroups() throws Exception {
        return this.groups;
    }

    public List getContentTypeDefinitionVOList() {
        return this.contentTypeDefinitionVOList;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getFirstName() {
        return this.infoGluePrincipal.getFirstName();
    }

    public String getLastName() {
        return this.infoGluePrincipal.getLastName();
    }

    public String getEmail() {
        return this.infoGluePrincipal.getEmail();
    }

    public boolean getSupportsUpdate() {
        return this.supportsUpdate;
    }

    public List getAssignedContentTypeDefinitionVOList() {
        return this.assignedContentTypeDefinitionVOList;
    }
}

