/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGluePropertiesAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ServerNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.management.ServerNodeVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGlueAuthenticationFilter;
import org.infoglue.cms.util.NotificationMessage;
import org.infoglue.cms.util.RemoteCacheUpdater;
import org.infoglue.deliver.util.CacheController;

public class ViewServerNodePropertiesAction
extends InfoGluePropertiesAbstractAction {
    private static final long serialVersionUID = 1L;
    private ServerNodeVO serverNodeVO = new ServerNodeVO();
    private PropertySet propertySet = null;
    private List serverNodeVOList = null;
    private String key = null;
    private String activeDivId = "commonSettings";

    protected void initialize(Integer serverNodeId) throws Exception {
        if (serverNodeId != null && serverNodeId > -1) {
            this.serverNodeVO = ServerNodeController.getController().getServerNodeVOWithId(serverNodeId);
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        this.propertySet = PropertySetManager.getInstance((String)"jdbc", args);
    }

    public String doExecute() throws Exception {
        this.initialize(this.getServerNodeId());
        return "success";
    }

    private void populate(PropertySet ps, String key) {
        String value = this.getRequest().getParameter(key);
        if (value != null && !value.equals("")) {
            ps.setString("serverNode_" + this.getServerNodeId() + "_" + key, value);
        }
    }

    private void populateData(PropertySet ps, String key) {
        try {
            String value = this.getRequest().getParameter(key);
            if (value != null && !value.equals("")) {
                ps.setData("serverNode_" + this.getServerNodeId() + "_" + key, value.getBytes("utf-8"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String doSave() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        this.populate(ps, "isPageCacheOn");
        this.populate(ps, "useSelectivePageCacheUpdate");
        this.populate(ps, "expireCacheAutomatically");
        this.populate(ps, "cacheExpireInterval");
        this.populate(ps, "deliverRequestTimeout");
        this.populate(ps, "liveDeliverRequestTimeout");
        this.populate(ps, "killLiveRequestWhichTimedout");
        this.populate(ps, "useHighLoadLimiter");
        this.populate(ps, "maxActiveRequests");
        this.populate(ps, "maxRequestTime");
        this.populate(ps, "session.timeout");
        this.populate(ps, "compressPageCache");
        this.populate(ps, "compressPageResponse");
        this.populate(ps, "siteNodesToRecacheOnPublishing");
        this.populate(ps, "recachePublishingMethod");
        this.populate(ps, "recacheUrl");
        this.populate(ps, "useUpdateSecurity");
        this.populate(ps, "allowedAdminIP");
        this.populate(ps, "pageKey");
        this.populate(ps, "componentKey");
        this.populateData(ps, "cacheSettings");
        this.populate(ps, "cmsBaseUrl");
        this.populate(ps, "cmsFullBaseUrl");
        this.populate(ps, "componentEditorUrl");
        this.populate(ps, "componentRendererUrl");
        this.populate(ps, "componentRendererAction");
        this.populate(ps, "editOnSiteUrl");
        this.populate(ps, "useFreeMarker");
        this.populate(ps, "webServerAddress");
        this.populate(ps, "applicationBaseAction");
        this.populate(ps, "digitalAssetBaseUrl");
        this.populate(ps, "imagesBaseUrl");
        this.populate(ps, "digitalAssetPath");
        this.populate(ps, "urlFormatting");
        this.populate(ps, "enableNiceURI");
        this.populate(ps, "enableDiskAssets");
        this.populate(ps, "disableAssetDeletionInWorkThread");
        this.populate(ps, "disableAssetDeletionInLiveThread");
        this.populate(ps, "niceURIEncoding");
        this.populate(ps, "niceURIAttributeName");
        this.populateData(ps, "niceURICharacterReplacingMapping");
        this.populate(ps, "niceURIUseLowerCase");
        this.populate(ps, "duplicateAssetsBetweenVersions");
        this.populate(ps, "requestArgumentDelimiter");
        this.populate(ps, "errorHandling");
        this.populate(ps, "errorUrl");
        this.populate(ps, "errorBusyUrl");
        this.populate(ps, "externalThumbnailGeneration");
        this.populate(ps, "URIEncoding");
        this.populate(ps, "workflowEncoding");
        this.populate(ps, "formsEncoding");
        this.populate(ps, "uploadFromEncoding");
        this.populate(ps, "uploadToEncoding");
        this.populate(ps, "assetKeyFromEncoding");
        this.populate(ps, "assetKeyToEncoding");
        this.populate(ps, "useShortTableNames");
        this.populate(ps, "useImprovedContentCategorySearch");
        this.populate(ps, "logDatabaseMessages");
        this.populate(ps, "statistics.enabled");
        this.populate(ps, "statisticsLogPath");
        this.populate(ps, "statisticsLogOneFilePerDay");
        this.populate(ps, "statisticsLogger");
        this.populate(ps, "enablePortal");
        this.populate(ps, "portletBase");
        this.populate(ps, "mail.smtp.host");
        this.populate(ps, "mail.smtp.port");
        this.populate(ps, "mail.smtp.auth");
        this.populate(ps, "mail.smtp.user");
        this.populate(ps, "mail.smtp.password");
        this.populate(ps, "mail.contentType");
        this.populate(ps, "systemEmailSender");
        this.populate(ps, "warningEmailReceiver");
        this.populate(ps, "loginUrl");
        this.populate(ps, "logoutUrl");
        this.populate(ps, "invalidLoginUrl");
        this.populate(ps, "successLoginBaseUrl");
        this.populate(ps, "authenticatorClass");
        this.populate(ps, "authorizerClass");
        this.populate(ps, "serverName");
        this.populate(ps, "authConstraint");
        this.populate(ps, "extraParametersFile");
        this.populateData(ps, "extraSecurityParameters");
        this.populate(ps, "casValidateUrl");
        this.populate(ps, "casProxyValidateUrl");
        this.populate(ps, "casServiceUrl");
        this.populate(ps, "casLogoutUrl");
        this.populate(ps, "deliver_loginUrl");
        this.populate(ps, "deliver_logoutUrl");
        this.populate(ps, "deliver_invalidLoginUrl");
        this.populate(ps, "deliver_successLoginBaseUrl");
        this.populate(ps, "deliver_authenticatorClass");
        this.populate(ps, "deliver_authorizerClass");
        this.populate(ps, "deliver_serverName");
        this.populate(ps, "deliver_authConstraint");
        this.populate(ps, "deliver_extraParametersFile");
        this.populateData(ps, "deliver_extraSecurityParameters");
        this.populate(ps, "deliver_security.anonymous.username");
        this.populate(ps, "deliver_security.anonymous.password");
        this.populate(ps, "deliver_casValidateUrl");
        this.populate(ps, "deliver_casProxyValidateUrl");
        this.populate(ps, "deliver_casServiceUrl");
        this.populate(ps, "deliver_casLogoutUrl");
        this.populate(ps, "workingStyleInformation");
        this.populate(ps, "finalStyleInformation");
        this.populate(ps, "publishStyleInformation");
        this.populate(ps, "publishedStyleInformation");
        this.populateData(ps, "customContentTypeIcons");
        this.populateData(ps, "shortcuts");
        this.populateData(ps, "WYSIWYGToolbarComboPreviewCSS");
        this.populateData(ps, "WYSIWYGEditorAreaCSS");
        this.populate(ps, "disableImageEditor");
        this.populate(ps, "hideProtectedProperties");
        this.populate(ps, "protectContentTypes");
        this.populate(ps, "protectWorkflows");
        this.populate(ps, "protectCategories");
        this.populate(ps, "maxRows");
        this.populate(ps, "defaultNumberOfYearsBeforeExpire");
        this.populate(ps, "enableDateTimeDirectEditing");
        this.populate(ps, "showContentVersionFirst");
        this.populate(ps, "tree");
        this.populate(ps, "treemode");
        this.populate(ps, "disableCustomIcons");
        this.populate(ps, "showComponentsFirst");
        this.populate(ps, "showAllWorkflows");
        this.populate(ps, "editOnSight");
        this.populate(ps, "previewDeliveryUrl");
        this.populate(ps, "stagingDeliveryUrl");
        this.populateData(ps, "internalDeliveryUrls");
        this.populateData(ps, "publicDeliveryUrls");
        this.populateData(ps, "toolLanguages");
        this.populateData(ps, "deploymentServers");
        this.populate(ps, "decoratedPageInvoker");
        this.populate(ps, "edition.pageSize");
        this.populate(ps, "content.tree.sort");
        this.populate(ps, "structure.tree.sort");
        this.populate(ps, "structure.tree.isHidden");
        this.populate(ps, "content.tree.hideForbidden");
        this.populate(ps, "structure.tree.hideForbidden");
        this.populate(ps, "enforceRigidContentAccess");
        this.populate(ps, "disableEmptyUrls");
        this.populate(ps, "cacheUpdateAction");
        this.populate(ps, "logPath");
        this.populate(ps, "logTransactions");
        this.populate(ps, "enableExtranetCookies");
        this.populate(ps, "useAlternativeBrowserLanguageCheck");
        this.populate(ps, "caseSensitiveRedirects");
        this.populate(ps, "useDNSNameInURI");
        this.populate(ps, "extranetCookieTimeout");
        this.populate(ps, "webServicesBaseUrl");
        this.populate(ps, "livePublicationThreadClass");
        this.populate(ps, "publicationThreadDelay");
        this.populate(ps, "pathsToRecacheOnPublishing");
        this.populate(ps, "disableTemplateDebug");
        this.populate(ps, "exportFormat");
        this.populate(ps, "dbRelease");
        this.populate(ps, "dbUser");
        this.populate(ps, "dbPassword");
        this.populate(ps, "masterServer");
        this.populate(ps, "slaveServer");
        this.populate(ps, "buildName");
        this.populate(ps, "adminToolsPath");
        this.populate(ps, "dbScriptPath");
        this.populate(ps, "digitalAssetUploadPath");
        this.populate(ps, "inputCharacterEncoding");
        this.populate(ps, "deliver_inputCharacterEncoding");
        this.populate(ps, "protectDeliverWorking");
        this.populate(ps, "protectDeliverPreview");
        this.populate(ps, "forceIdentityCheck");
        this.populate(ps, "allowCrossSiteSubmitToPublish");
        this.populate(ps, "usePasswordEncryption");
        this.populate(ps, "allowPublicationEventFilter");
        this.populate(ps, "defaultPublicationEventFilter");
        this.populate(ps, "numberOfVersionsToKeepDuringClean");
        this.populate(ps, "keepOnlyOldPublishedVersionsDuringClean");
        this.populateData(ps, "assetUploadTransformationsSettings");
        try {
            UserControllerProxy.getController().updateAnonymousUserPassword();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        try {
            CacheController.clearServerNodeProperty(true);
            InfoGlueAuthenticationFilter.initializeCMSProperties();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        NotificationMessage notificationMessage = new NotificationMessage("ViewServerNodePropertiesAction.doSave():", "ServerNodeProperties", this.getInfoGluePrincipal().getName(), 100, "0", "ServerNodeProperties");
        RemoteCacheUpdater.getSystemNotificationMessages().add(notificationMessage);
        return "save";
    }

    public String doDeleteProperty() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        ps.remove("serverNode_" + this.getServerNodeId() + "_" + this.key);
        try {
            CacheController.clearServerNodeProperty(true);
            InfoGlueAuthenticationFilter.initializeCMSProperties();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        NotificationMessage notificationMessage = new NotificationMessage("ViewServerNodePropertiesAction.doSave():", "ServerNodeProperties", this.getInfoGluePrincipal().getName(), 100, "0", "ServerNodeProperties");
        RemoteCacheUpdater.getSystemNotificationMessages().add(notificationMessage);
        return "save";
    }

    public String doSaveAndExit() throws Exception {
        this.doSave();
        return "saveAndExit";
    }

    public Integer getServerNodeId() {
        return this.serverNodeVO.getServerNodeId();
    }

    public void setServerNodeId(Integer serverNodeId) throws Exception {
        this.serverNodeVO.setServerNodeId(serverNodeId);
    }

    public ServerNodeVO getServerNodeVO() {
        return this.serverNodeVO;
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public String getPropertyValue(String prefix, String key) {
        String value = this.propertySet.getString("serverNode_" + this.getServerNodeId() + "_" + prefix + "_" + key);
        return value != null ? value : "";
    }

    public String getPropertyValue(String key) {
        String value = this.propertySet.getString("serverNode_" + this.getServerNodeId() + "_" + key);
        return value != null ? value : "";
    }

    public String getDataPropertyValue(String key) throws Exception {
        byte[] valueBytes = this.propertySet.getData("serverNode_" + this.getServerNodeId() + "_" + key);
        return valueBytes != null ? new String(valueBytes, "utf-8") : "";
    }

    public String getDataPropertyValue(String prefix, String key) throws Exception {
        byte[] valueBytes = this.propertySet.getData("serverNode_" + this.getServerNodeId() + "_" + prefix + "_" + key);
        return valueBytes != null ? new String(valueBytes, "utf-8") : "";
    }

    public List getServerNodeVOList() {
        return this.serverNodeVOList;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getActiveDivId() {
        return this.activeDivId;
    }

    public void setActiveDivId(String activeDivId) {
        this.activeDivId = activeDivId;
    }
}

