/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.managementtool.actions.ViewEntityPropertiesAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RolePropertiesController;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.RoleProperties;
import org.infoglue.cms.entities.management.RolePropertiesVO;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.CmsPropertyHandler;

public class ViewRolePropertiesAction
extends ViewEntityPropertiesAction {
    private static final Logger logger = Logger.getLogger((String)ViewRolePropertiesAction.class.getName());
    private static final long serialVersionUID = 1L;
    private String roleName;
    private RolePropertiesVO rolePropertiesVO;
    private List rolePropertiesVOList;

    protected void initialize(String roleName) throws Exception {
        super.initialize();
        logger.info((Object)("roleName:" + roleName));
        List contentTypeDefinitionVOList = RolePropertiesController.getController().getContentTypeDefinitionVOList(roleName);
        if (contentTypeDefinitionVOList != null && contentTypeDefinitionVOList.size() > 0) {
            this.setContentTypeDefinitionVO((ContentTypeDefinitionVO)contentTypeDefinitionVOList.get(0));
        }
        InfoGlueRole infoGlueRole = RoleControllerProxy.getController().getRole(roleName);
        this.rolePropertiesVOList = RolePropertiesController.getController().getRolePropertiesVOList(roleName, this.getLanguageId());
        if (this.rolePropertiesVOList != null && this.rolePropertiesVOList.size() > 0) {
            this.rolePropertiesVO = (RolePropertiesVO)this.rolePropertiesVOList.get(0);
            this.setContentTypeDefinitionId(this.rolePropertiesVO.getContentTypeDefinitionId());
        } else {
            this.setContentTypeDefinitionId(this.getContentTypeDefinitionVO().getContentTypeDefinitionId());
        }
        logger.info((Object)("this.rolePropertiesVO:" + this.rolePropertiesVO));
        this.setAttributes(ContentTypeDefinitionController.getController().getContentTypeAttributes(this.getContentTypeDefinitionVO().getSchemaValue()));
        logger.info((Object)("attributes:" + this.getContentTypeAttributes().size()));
        logger.info((Object)("availableLanguages:" + this.getAvailableLanguages().size()));
    }

    public String doExecute() throws Exception {
        this.initialize(this.getRoleName());
        this.setCurrentAction("ViewRoleProperties.action");
        this.setUpdateAction("UpdateRoleProperties");
        this.setUpdateAndExitAction("UpdateRoleProperties!saveAndExit");
        this.setCancelAction("ViewRole.action");
        this.setToolbarKey("tool.managementtool.viewRoleProperties.header");
        this.setTitleKey("tool.managementtool.viewRoleProperties.header");
        this.setArguments("");
        this.setEntityName(RoleProperties.class.getName());
        return "success";
    }

    public String doV3() throws Exception {
        this.initialize(this.getRoleName());
        this.setCurrentAction("ViewRoleProperties!v3.action");
        this.setUpdateAction("UpdateRoleProperties!v3");
        this.setUpdateAndExitAction("UpdateRoleProperties!saveAndExitV3");
        this.setCancelAction("ViewRole!v3.action");
        this.setToolbarKey("tool.managementtool.viewRoleProperties.header");
        this.setTitleKey("tool.managementtool.viewRoleProperties.header");
        this.setArguments("");
        this.setEntityName(RoleProperties.class.getName());
        return "successV3";
    }

    public List getDigitalAssets() {
        List digitalAssets = null;
        try {
            if (this.rolePropertiesVO != null && this.rolePropertiesVO.getId() != null) {
                digitalAssets = RolePropertiesController.getController().getDigitalAssetVOList(this.rolePropertiesVO.getId());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of digitalAssets: " + e.getMessage()), (Throwable)e);
        }
        return digitalAssets;
    }

    public List getRelatedCategories(String attribute) {
        try {
            if (this.rolePropertiesVO != null && this.rolePropertiesVO.getId() != null) {
                return this.getPropertiesCategoryController().findByPropertiesAttribute(attribute, RoleProperties.class.getName(), this.rolePropertiesVO.getId());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of defined category keys: " + e.getMessage()), (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    public String getXML() {
        return this.rolePropertiesVO == null ? null : this.rolePropertiesVO.getValue();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public RolePropertiesVO getRolePropertiesVO() {
        return this.rolePropertiesVO;
    }

    public List getRolePropertiesVOList() {
        return this.rolePropertiesVOList;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
        this.setOwnerEntityId(roleName);
    }

    public Integer getEntityId() {
        return this.rolePropertiesVO.getId();
    }

    public void setOwnerEntityId(String ownerEntityId) {
        super.setOwnerEntityId(ownerEntityId);
        this.roleName = ownerEntityId;
    }

    public String getReturnAddress() throws Exception {
        String URIEncoding = CmsPropertyHandler.getURIEncoding();
        return String.valueOf(this.getCurrentAction()) + "?roleName=" + URLEncoder.encode(this.roleName, URIEncoding) + "&languageId=" + this.getLanguageId();
    }

    public String getCancelAddress() throws Exception {
        String URIEncoding = CmsPropertyHandler.getURIEncoding();
        return String.valueOf(this.getCancelAction()) + "?roleName=" + URLEncoder.encode(this.roleName, URIEncoding);
    }
}

