/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RolePropertiesController;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.security.InfoGlueRole;

public class ViewRoleAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private String roleName;
    private boolean supportsUpdate = true;
    private InfoGlueRole infoGlueRole;
    private List infoGluePrincipals = new ArrayList();
    private List assignedInfoGluePrincipals;
    private List contentTypeDefinitionVOList;
    private List assignedContentTypeDefinitionVOList;

    protected void initialize(String roleName) throws Exception {
        this.infoGlueRole = RoleControllerProxy.getController().getRole(roleName);
        this.supportsUpdate = this.infoGlueRole.getAutorizationModule().getSupportUpdate();
        this.assignedInfoGluePrincipals = this.infoGlueRole.getAutorizationModule().getRoleUsers(roleName);
        if (this.supportsUpdate) {
            this.infoGluePrincipals = this.infoGlueRole.getAutorizationModule().getUsers();
        }
        this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList(ContentTypeDefinitionVO.EXTRANET_ROLE_PROPERTIES);
        this.assignedContentTypeDefinitionVOList = RolePropertiesController.getController().getContentTypeDefinitionVOList(roleName);
    }

    public String doExecute() throws Exception {
        this.initialize(this.getRoleName());
        return "success";
    }

    public String doV3() throws Exception {
        this.initialize(this.getRoleName());
        return "successV3";
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getDescription() {
        return this.infoGlueRole.getDescription();
    }

    public List getAllInfoGluePrincipals() throws Exception {
        return this.infoGluePrincipals;
    }

    public List getAssignedInfoGluePrincipals() throws Exception {
        return this.assignedInfoGluePrincipals;
    }

    public List getAssignedContentTypeDefinitionVOList() {
        return this.assignedContentTypeDefinitionVOList;
    }

    public List getContentTypeDefinitionVOList() {
        return this.contentTypeDefinitionVOList;
    }

    public void setAssignedContentTypeDefinitionVOList(List list) {
        this.assignedContentTypeDefinitionVOList = list;
    }

    public void setContentTypeDefinitionVOList(List list) {
        this.contentTypeDefinitionVOList = list;
    }

    public boolean getSupportsUpdate() {
        return this.supportsUpdate;
    }
}

