/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGluePropertiesAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.RepositoryVO;

public class ViewRepositoryPropertiesAction
extends InfoGluePropertiesAbstractAction {
    private static final long serialVersionUID = 1L;
    private RepositoryVO repositoryVO = new RepositoryVO();
    private PropertySet propertySet = null;
    private List contentTypeDefinitionVOList = null;
    private List repositoryVOList = null;
    private String WYSIWYGConfig = null;
    private String stylesXML = null;
    private String extraProperties = null;
    private String defaultFolderContentTypeName = null;
    private String defaultTemplateRepository = null;
    private String parentRepository = null;

    protected void initialize(Integer repositoryId) throws Exception {
        byte[] extraPropertiesBytes;
        byte[] StylesXMLBytes;
        this.repositoryVO = RepositoryController.getController().getRepositoryVOWithId(repositoryId);
        this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList(ContentTypeDefinitionVO.CONTENT);
        this.repositoryVOList = RepositoryController.getController().getRepositoryVOList();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        byte[] WYSIWYGConfigBytes = ps.getData("repository_" + this.getRepositoryId() + "_WYSIWYGConfig");
        if (WYSIWYGConfigBytes != null) {
            this.WYSIWYGConfig = new String(WYSIWYGConfigBytes, "utf-8");
        }
        if ((StylesXMLBytes = ps.getData("repository_" + this.getRepositoryId() + "_StylesXML")) != null) {
            this.stylesXML = new String(StylesXMLBytes, "utf-8");
        }
        if ((extraPropertiesBytes = ps.getData("repository_" + this.getRepositoryId() + "_extraProperties")) != null) {
            this.extraProperties = new String(extraPropertiesBytes, "utf-8");
        }
        this.defaultFolderContentTypeName = ps.getString("repository_" + this.getRepositoryId() + "_defaultFolderContentTypeName");
        this.defaultTemplateRepository = ps.getString("repository_" + this.getRepositoryId() + "_defaultTemplateRepository");
        this.parentRepository = ps.getString("repository_" + this.getRepositoryId() + "_parentRepository");
    }

    public String doExecute() throws Exception {
        this.initialize(this.getRepositoryId());
        return "success";
    }

    public String doSave() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        ps.setData("repository_" + this.getRepositoryId() + "_WYSIWYGConfig", this.WYSIWYGConfig.getBytes("utf-8"));
        ps.setData("repository_" + this.getRepositoryId() + "_StylesXML", this.stylesXML.getBytes("utf-8"));
        ps.setData("repository_" + this.getRepositoryId() + "_extraProperties", this.extraProperties.getBytes("utf-8"));
        ps.setString("repository_" + this.getRepositoryId() + "_defaultFolderContentTypeName", this.defaultFolderContentTypeName);
        ps.setString("repository_" + this.getRepositoryId() + "_defaultTemplateRepository", this.defaultTemplateRepository);
        ps.setString("repository_" + this.getRepositoryId() + "_parentRepository", this.parentRepository);
        RepositoryVO repositoryVO = RepositoryController.getController().getFirstRepositoryVO();
        repositoryVO.setDescription(String.valueOf(repositoryVO.getDescription()) + ".");
        RepositoryController.getController().update(repositoryVO);
        return "save";
    }

    public String doSaveAndExit() throws Exception {
        this.doSave();
        return "saveAndExit";
    }

    public Integer getRepositoryId() {
        return this.repositoryVO.getRepositoryId();
    }

    public void setRepositoryId(Integer repositoryId) throws Exception {
        this.repositoryVO.setRepositoryId(repositoryId);
    }

    public RepositoryVO getRepositoryVO() {
        return this.repositoryVO;
    }

    public String getWYSIWYGConfig() {
        return this.WYSIWYGConfig;
    }

    public void setWYSIWYGConfig(String config) {
        this.WYSIWYGConfig = config;
    }

    public String getWYSIWYGStyles() {
        return this.stylesXML;
    }

    public void setWYSIWYGStyles(String stylesXML) {
        this.stylesXML = stylesXML;
    }

    public String getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(String extraProperties) {
        this.extraProperties = extraProperties;
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public String getDefaultFolderContentTypeName() {
        return this.defaultFolderContentTypeName;
    }

    public void setDefaultFolderContentTypeName(String defaultFolderContentTypeName) {
        this.defaultFolderContentTypeName = defaultFolderContentTypeName;
    }

    public String getDefaultTemplateRepository() {
        return this.defaultTemplateRepository;
    }

    public void setDefaultTemplateRepository(String defaultTemplateRepository) {
        this.defaultTemplateRepository = defaultTemplateRepository;
    }

    public String getParentRepository() {
        return this.parentRepository;
    }

    public void setParentRepository(String parentRepository) {
        this.parentRepository = parentRepository;
    }

    public List getContentTypeDefinitionVOList() {
        return this.contentTypeDefinitionVOList;
    }

    public List getRepositoryVOList() {
        return this.repositoryVOList;
    }
}

